package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIEditor;

public class HtmlEditor extends UIEditor{

static final public  String COMPONENT_FAMILY = "org.richfaces.Editor";

static final public  String COMPONENT_TYPE = "org.richfaces.Editor";

/*
* Attribute enables to get the Editor area to resize to the boundaries of the contents.
*/
private  boolean _autoResize = false;

private  boolean _autoResizeSet = false;

/*
* Attribute defines configuration properties file name
*/
private  String _configuration = null;

/*
* Attribute defines property file name witch contains descriptors of custom plugins
*/
private  String _customPlugins = null;

/*
* Attribute defines how dialogs/popups should be opened. Default value is "modal"
*/
private  String _dialogType = null;

/*
* Attribute defines height of component.
*/
private  Integer _height = null;

/*
* A localized user presentable name for this component.
*/
private  String _label = null;

/*
* Attribute defines Editor language
*/
private  String _language = null;

/*
* Attribute enables to specify a function name to be executed each time content is modified by TinyMCE.
*/
private  String _onchange = null;

/*
* Attribute defines a function name to be executed when all Editor instances have finished their initialization.
*/
private  String _oninit = null;

/*
* Attribute enables to add custom logic to be executed when the contents is extracted/saved.
*/
private  String _onsave = null;

/*
* Attribute enables to add events to Editor instances before they get rendered.
*/
private  String _onsetup = null;

/*
* Attribute defines Editor plugins
*/
private  String _plugins = null;

/*
* Attribute defines Editor is readonly
*/
private  boolean _readonly = false;

private  boolean _readonlySet = false;

/*
* Attribute defines Editor skin
*/
private  String _skin = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* In visual mode the attribute works the same way as "tab_focus" TinyMCE's property the attribute enables 
				you to specify an element ID to focus, when the TAB  key  is pressed .
				You can also use the special ":prev" and ":next"  values that will then place the focus on 
				an input element placed before/after the TinyMCE instance in the DOM. 
				While in "source" mode the attribute works like standard HTML tabindex attribute.
*/
private  String _tabindex = null;

/*
* Attribute defines Editor theme
*/
private  String _theme = null;

/*
* Sets editor type. Default value is "TinyMCE"
*/
private  String _type = null;

/*
* Attribute defines if model value should be converted to Seam Text. Default value is "false"
*/
private  boolean _useSeamText = false;

private  boolean _useSeamTextSet = false;

/*
* Attribute defines if tinyMCE WYSIWYG should be disabled. Default value is "visual"
*/
private  String _viewMode = null;

/*
* Attribute defines width of component.
*/
private  Integer _width = null;


public HtmlEditor(){
setRendererType("org.richfaces.EditorRenderer");
}

public boolean isAutoResize(){
	if (this._autoResizeSet) {
	    return (this._autoResize);
	}
	ValueExpression ve = getValueExpression("autoResize");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._autoResize);
	    }
	    
	    return value;
	} else {
	    return (this._autoResize);
	}

}

public void setAutoResize(boolean _autoResize){
this._autoResize = _autoResize;
this._autoResizeSet = true;
}

public String getConfiguration(){
	if (this._configuration != null) {
		return this._configuration;
	}
	ValueExpression ve = getValueExpression("configuration");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setConfiguration(String _configuration){
this._configuration = _configuration;
}

public String getCustomPlugins(){
	if (this._customPlugins != null) {
		return this._customPlugins;
	}
	ValueExpression ve = getValueExpression("customPlugins");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCustomPlugins(String _customPlugins){
this._customPlugins = _customPlugins;
}

public String getDialogType(){
	if (this._dialogType != null) {
		return this._dialogType;
	}
	ValueExpression ve = getValueExpression("dialogType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "modal";
	

}

public void setDialogType(String _dialogType){
this._dialogType = _dialogType;
}

public Integer getHeight(){
	if (this._height != null) {
		return this._height;
	}
	ValueExpression ve = getValueExpression("height");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHeight(Integer _height){
this._height = _height;
}

public String getLabel(){
	if (this._label != null) {
		return this._label;
	}
	ValueExpression ve = getValueExpression("label");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLabel(String _label){
this._label = _label;
}

public String getLanguage(){
	if (this._language != null) {
		return this._language;
	}
	ValueExpression ve = getValueExpression("language");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLanguage(String _language){
this._language = _language;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOninit(){
	if (this._oninit != null) {
		return this._oninit;
	}
	ValueExpression ve = getValueExpression("oninit");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninit(String _oninit){
this._oninit = _oninit;
}

public String getOnsave(){
	if (this._onsave != null) {
		return this._onsave;
	}
	ValueExpression ve = getValueExpression("onsave");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnsave(String _onsave){
this._onsave = _onsave;
}

public String getOnsetup(){
	if (this._onsetup != null) {
		return this._onsetup;
	}
	ValueExpression ve = getValueExpression("onsetup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnsetup(String _onsetup){
this._onsetup = _onsetup;
}

public String getPlugins(){
	if (this._plugins != null) {
		return this._plugins;
	}
	ValueExpression ve = getValueExpression("plugins");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setPlugins(String _plugins){
this._plugins = _plugins;
}

public boolean isReadonly(){
	if (this._readonlySet) {
	    return (this._readonly);
	}
	ValueExpression ve = getValueExpression("readonly");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._readonly);
	    }
	    
	    return value;
	} else {
	    return (this._readonly);
	}

}

public void setReadonly(boolean _readonly){
this._readonly = _readonly;
this._readonlySet = true;
}

public String getSkin(){
	if (this._skin != null) {
		return this._skin;
	}
	ValueExpression ve = getValueExpression("skin");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSkin(String _skin){
this._skin = _skin;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTabindex(){
	if (this._tabindex != null) {
		return this._tabindex;
	}
	ValueExpression ve = getValueExpression("tabindex");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTabindex(String _tabindex){
this._tabindex = _tabindex;
}

public String getTheme(){
	if (this._theme != null) {
		return this._theme;
	}
	ValueExpression ve = getValueExpression("theme");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTheme(String _theme){
this._theme = _theme;
}

public String getType(){
	if (this._type != null) {
		return this._type;
	}
	ValueExpression ve = getValueExpression("type");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "TinyMCE";
	

}

public void setType(String _type){
this._type = _type;
}

public boolean isUseSeamText(){
	if (this._useSeamTextSet) {
	    return (this._useSeamText);
	}
	ValueExpression ve = getValueExpression("useSeamText");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._useSeamText);
	    }
	    
	    return value;
	} else {
	    return (this._useSeamText);
	}

}

public void setUseSeamText(boolean _useSeamText){
this._useSeamText = _useSeamText;
this._useSeamTextSet = true;
}

public String getViewMode(){
	if (this._viewMode != null) {
		return this._viewMode;
	}
	ValueExpression ve = getValueExpression("viewMode");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "visual";
	

}

public void setViewMode(String _viewMode){
this._viewMode = _viewMode;
}

public Integer getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setWidth(Integer _width){
this._width = _width;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[26];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_autoResize);
state[2] = Boolean.valueOf(_autoResizeSet);
state[3] = _configuration;
state[4] = _customPlugins;
state[5] = _dialogType;
state[6] = _height;
state[7] = _label;
state[8] = _language;
state[9] = _onchange;
state[10] = _oninit;
state[11] = _onsave;
state[12] = _onsetup;
state[13] = _plugins;
state[14] = Boolean.valueOf(_readonly);
state[15] = Boolean.valueOf(_readonlySet);
state[16] = _skin;
state[17] = _style;
state[18] = _styleClass;
state[19] = _tabindex;
state[20] = _theme;
state[21] = _type;
state[22] = Boolean.valueOf(_useSeamText);
state[23] = Boolean.valueOf(_useSeamTextSet);
state[24] = _viewMode;
state[25] = _width;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_autoResize = ((Boolean)states[1]).booleanValue();
		_autoResizeSet = ((Boolean)states[2]).booleanValue();
		_configuration = (String)states[3];;
		_customPlugins = (String)states[4];;
		_dialogType = (String)states[5];;
		_height = (Integer)states[6];;
		_label = (String)states[7];;
		_language = (String)states[8];;
		_onchange = (String)states[9];;
		_oninit = (String)states[10];;
		_onsave = (String)states[11];;
		_onsetup = (String)states[12];;
		_plugins = (String)states[13];;
		_readonly = ((Boolean)states[14]).booleanValue();
		_readonlySet = ((Boolean)states[15]).booleanValue();
		_skin = (String)states[16];;
		_style = (String)states[17];;
		_styleClass = (String)states[18];;
		_tabindex = (String)states[19];;
		_theme = (String)states[20];;
		_type = (String)states[21];;
		_useSeamText = ((Boolean)states[22]).booleanValue();
		_useSeamTextSet = ((Boolean)states[23]).booleanValue();
		_viewMode = (String)states[24];;
		_width = (Integer)states[25];;
	
}

}
