package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIToolBarGroup;

public class HtmlToolBarGroup extends UIToolBarGroup{

static public final  String COMPONENT_FAMILY = "org.richfaces.ToolBar";

static public final  String COMPONENT_TYPE = "org.richfaces.ToolBarGroup";

/*
* A separator for the items in a group. Possible
	    	values are "none", "line", "square", "disc" and "grid" Default value is "none".
*/
private  String _itemSeparator = null;

/*
* A location of a group on a tool bar. Possible values are "left" and "right". Default value is "left".
*/
private  String _location = null;

/*
* HTML: a script expression; a pointer button is clicked on an item
*/
private  String _onitemclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked on an item
*/
private  String _onitemdblclick = null;

/*
* HTML: a script expression; a key is pressed down on an item
*/
private  String _onitemkeydown = null;

/*
* HTML: a script expression; a key is pressed and released on an item
*/
private  String _onitemkeypress = null;

/*
* HTML: a script expression; a key is released on an item
*/
private  String _onitemkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down on an item
*/
private  String _onitemmousedown = null;

/*
* HTML: a script expression; a pointer is moved on an item
*/
private  String _onitemmousemove = null;

/*
* HTML: a script expression; a pointer is moved away from an item
*/
private  String _onitemmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto an item
*/
private  String _onitemmouseover = null;

/*
* HTML: script expression; a pointer button is released on an item
*/
private  String _onitemmouseup = null;

/*
* A CSS class to be applied to tool bar group separators.
*/
private  String _separatorClass = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;


public HtmlToolBarGroup(){
setRendererType("org.richfaces.ToolBarGroupRenderer");
}

public String getItemSeparator(){
	if (this._itemSeparator != null) {
		return this._itemSeparator;
	}
	ValueExpression ve = getValueExpression("itemSeparator");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "none";
	

}

public void setItemSeparator(String _itemSeparator){
this._itemSeparator = _itemSeparator;
}

public String getLocation(){
	if (this._location != null) {
		return this._location;
	}
	ValueExpression ve = getValueExpression("location");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "left";
	

}

public void setLocation(String _location){
this._location = _location;
}

public String getOnitemclick(){
	if (this._onitemclick != null) {
		return this._onitemclick;
	}
	ValueExpression ve = getValueExpression("onitemclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnitemclick(String _onitemclick){
this._onitemclick = _onitemclick;
}

public String getOnitemdblclick(){
	if (this._onitemdblclick != null) {
		return this._onitemdblclick;
	}
	ValueExpression ve = getValueExpression("onitemdblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnitemdblclick(String _onitemdblclick){
this._onitemdblclick = _onitemdblclick;
}

public String getOnitemkeydown(){
	if (this._onitemkeydown != null) {
		return this._onitemkeydown;
	}
	ValueExpression ve = getValueExpression("onitemkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnitemkeydown(String _onitemkeydown){
this._onitemkeydown = _onitemkeydown;
}

public String getOnitemkeypress(){
	if (this._onitemkeypress != null) {
		return this._onitemkeypress;
	}
	ValueExpression ve = getValueExpression("onitemkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnitemkeypress(String _onitemkeypress){
this._onitemkeypress = _onitemkeypress;
}

public String getOnitemkeyup(){
	if (this._onitemkeyup != null) {
		return this._onitemkeyup;
	}
	ValueExpression ve = getValueExpression("onitemkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnitemkeyup(String _onitemkeyup){
this._onitemkeyup = _onitemkeyup;
}

public String getOnitemmousedown(){
	if (this._onitemmousedown != null) {
		return this._onitemmousedown;
	}
	ValueExpression ve = getValueExpression("onitemmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnitemmousedown(String _onitemmousedown){
this._onitemmousedown = _onitemmousedown;
}

public String getOnitemmousemove(){
	if (this._onitemmousemove != null) {
		return this._onitemmousemove;
	}
	ValueExpression ve = getValueExpression("onitemmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnitemmousemove(String _onitemmousemove){
this._onitemmousemove = _onitemmousemove;
}

public String getOnitemmouseout(){
	if (this._onitemmouseout != null) {
		return this._onitemmouseout;
	}
	ValueExpression ve = getValueExpression("onitemmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnitemmouseout(String _onitemmouseout){
this._onitemmouseout = _onitemmouseout;
}

public String getOnitemmouseover(){
	if (this._onitemmouseover != null) {
		return this._onitemmouseover;
	}
	ValueExpression ve = getValueExpression("onitemmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnitemmouseover(String _onitemmouseover){
this._onitemmouseover = _onitemmouseover;
}

public String getOnitemmouseup(){
	if (this._onitemmouseup != null) {
		return this._onitemmouseup;
	}
	ValueExpression ve = getValueExpression("onitemmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnitemmouseup(String _onitemmouseup){
this._onitemmouseup = _onitemmouseup;
}

public String getSeparatorClass(){
	if (this._separatorClass != null) {
		return this._separatorClass;
	}
	ValueExpression ve = getValueExpression("separatorClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSeparatorClass(String _separatorClass){
this._separatorClass = _separatorClass;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[16];
state[0] = super.saveState(context);
state[1] = _itemSeparator;
state[2] = _location;
state[3] = _onitemclick;
state[4] = _onitemdblclick;
state[5] = _onitemkeydown;
state[6] = _onitemkeypress;
state[7] = _onitemkeyup;
state[8] = _onitemmousedown;
state[9] = _onitemmousemove;
state[10] = _onitemmouseout;
state[11] = _onitemmouseover;
state[12] = _onitemmouseup;
state[13] = _separatorClass;
state[14] = _style;
state[15] = _styleClass;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_itemSeparator = (String)states[1];;
		_location = (String)states[2];;
		_onitemclick = (String)states[3];;
		_onitemdblclick = (String)states[4];;
		_onitemkeydown = (String)states[5];;
		_onitemkeypress = (String)states[6];;
		_onitemkeyup = (String)states[7];;
		_onitemmousedown = (String)states[8];;
		_onitemmousemove = (String)states[9];;
		_onitemmouseout = (String)states[10];;
		_onitemmouseover = (String)states[11];;
		_onitemmouseup = (String)states[12];;
		_separatorClass = (String)states[13];;
		_style = (String)states[14];;
		_styleClass = (String)states[15];;
	
}

}
