/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.resources;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.BaseResourceRenderer;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceContext;

public class EditorHTMLRenderer
extends BaseResourceRenderer {
    private static final String SPECIFIC_SCRIPT_RESOURCE_NAME = "org/richfaces/renderkit/html/1$1.js";
    private static final String SPECIFIC_XCSS_RESOURCE_NAME = "org/richfaces/renderkit/html/1$1.xcss";
    private static final Pattern REGEXP = Pattern.compile("\\<(script|link|img|iframe)\\s+.*(?:src|href)\\s*=\\s*[\"']([^'\"]+)\\.([^\\'\"]+)[\"'][^>]*\\>", 2);

    protected String[][] getCommonAttrs() {
        return null;
    }

    protected String getHrefAttr() {
        return null;
    }

    protected String getTag() {
        return "span";
    }

    public String getContentType() {
        return "text/html";
    }

    public int send(InternetResource base, ResourceContext context) throws IOException {
        InputStream in = base.getResourceAsStream(context);
        OutputStream out = context.getOutputStream();
        if (null == in) {
            String message = Messages.getMessage((String)"NO_INPUT_STREAM_ERROR", (Object)base.getKey());
            throw new IOException(message);
        }
        int total = this.updateAndSendResource(in, out);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateAndSendResource(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(out));
        String scriptSuffix = this.getSriptMappingSuffix();
        String cssSuffix = this.getCssMappingSuffix();
        Pattern pattern = REGEXP;
        try {
            while (br.ready()) {
                String line = br.readLine();
                Matcher matcher = pattern.matcher(line);
                if (matcher.find()) {
                    String extension;
                    String path;
                    String tagName = matcher.group(1);
                    if (scriptSuffix != null && (tagName.toLowerCase().equals("script") || tagName.toLowerCase().equals("iframe"))) {
                        path = matcher.group(2);
                        extension = matcher.group(3);
                        line = line.replace(path + "." + extension, path + "." + extension + scriptSuffix);
                    }
                    if (scriptSuffix != null && tagName.toLowerCase().equals("img")) {
                        path = matcher.group(2);
                        extension = matcher.group(3);
                        if (path.indexOf("http://") == -1) {
                            line = line.replace(path + "." + extension, path + "." + extension + scriptSuffix);
                        }
                    }
                    if (cssSuffix != null && tagName.toLowerCase().equals("link")) {
                        path = matcher.group(2);
                        extension = matcher.group(3);
                        line = line.replace(path + "." + extension, path + "." + (extension.charAt(0) == 'c' ? "xcss" : "XCSS") + cssSuffix);
                    }
                }
                bw.write(line);
                bw.newLine();
                total += line.getBytes().length;
            }
        }
        finally {
            bw.flush();
            br.close();
            bw.close();
            in.close();
            out.close();
        }
        return total;
    }

    protected String getSriptMappingSuffix() {
        return this.getResourceSuffix(SPECIFIC_SCRIPT_RESOURCE_NAME);
    }

    protected String getCssMappingSuffix() {
        return this.getResourceSuffix(SPECIFIC_XCSS_RESOURCE_NAME);
    }

    private String getResourceSuffix(String resourceName) {
        InternetResourceBuilder builder = InternetResourceBuilder.getInstance();
        InternetResource resource = builder.getResource(resourceName);
        String resourceUri = resource.getUri(FacesContext.getCurrentInstance(), null);
        String suffix = resourceUri.substring(resourceUri.indexOf(resourceName) + resourceName.length());
        if (suffix != null && suffix.length() == 0) {
            suffix = null;
        }
        return suffix;
    }

    public boolean requireFacesContext() {
        return true;
    }
}

