/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.JavaScriptParameter;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.JSBind;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIContextMenu;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.TemplateEncoderRendererBase;
import org.richfaces.renderkit.html.ContextMenuContentHandler;
import org.richfaces.renderkit.html.ContextMenuRendererDelegate;
import org.xml.sax.ContentHandler;

public class ContextMenuRendererBase
extends TemplateEncoderRendererBase {
    private static final String IMMEDIATE = "immediate";
    private static final String ON_AVAILABLE = "onavailable";
    private static final String ON_LOAD = "onload";
    private final ContextMenuRendererDelegate delegate = new ContextMenuRendererDelegate();
    private final InternetResource[] ownScripts = new InternetResource[]{this.getResource("/org/richfaces/renderkit/html/scripts/json/json-dom.js"), this.getResource("/org/richfaces/renderkit/html/scripts/utils.js"), this.getResource("/org/richfaces/renderkit/html/scripts/context-menu.js"), new PrototypeScript(), new AjaxScript(), this.getResource("/org/richfaces/renderkit/html/scripts/available.js"), this.getResource("/org/richfaces/renderkit/html/scripts/jquery/jquery.js")};
    private final InternetResource[] scripts;

    public ContextMenuRendererBase() {
        InternetResource[] delegateScripts = this.delegate.getScripts();
        this.scripts = new InternetResource[delegateScripts.length + this.ownScripts.length];
        System.arraycopy(delegateScripts, 0, this.scripts, 0, delegateScripts.length);
        System.arraycopy(this.ownScripts, 0, this.scripts, delegateScripts.length, this.ownScripts.length);
    }

    protected InternetResource[] getScripts() {
        return this.scripts;
    }

    protected InternetResource[] getStyles() {
        return this.delegate.getStyles();
    }

    protected Class getComponentClass() {
        return this.delegate.getComponentClass();
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.ensureParentPresent(component);
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), "id");
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private void ensureParentPresent(UIComponent component) {
        UIComponent parent = component.getParent();
        UIContextMenu menu = (UIContextMenu)component;
        if (parent != null) {
            if (!HtmlUtil.shouldWriteId((UIComponent)parent) && menu.isAttached() && this.isEmpty(menu.getAttachTo())) {
                throw new FacesException("Context menu cannot be attached to the component with id = " + parent.getId() + ", because a client identifier of the component won't be rendered onto the page. Please, set the identifier.");
            }
        } else {
            throw new FacesException("Parent component is null for ContextMenu " + component.getId());
        }
    }

    protected void checkValidity(String clientId, String name, String attachTiming) {
        if (!(ON_LOAD.equals(attachTiming) || IMMEDIATE.equals(attachTiming) || ON_AVAILABLE.equals(attachTiming))) {
            throw new FacesException("The attachTiming attribute of the contextMenu  (id='" + clientId + "') has an invalid value:'" + attachTiming + "'. It may have only the following values: '" + IMMEDIATE + "', '" + ON_LOAD + "', '" + ON_AVAILABLE + "'");
        }
    }

    public void renderChildren(FacesContext context, UIComponent component) throws IOException {
        this.delegate.encodeChildren(context, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UIContextMenu menu = (UIContextMenu)component;
        ResponseWriter writer = context.getResponseWriter();
        String event = menu.getEvent();
        if (event == null) {
            throw new FacesException("Attribute 'event' is not set for component " + component.getClientId(context));
        }
        writer.startElement("script", component);
        this.getUtils().writeAttribute(writer, "type", (Object)"text/javascript");
        writer.writeText((Object)"var contextMenu = new Richfaces.ContextMenu('", null);
        writer.writeText((Object)component.getClientId(context), null);
        writer.writeText((Object)"', ", null);
        writer.writeText((Object)(menu.getShowDelay() + ", "), null);
        this.writeScriptBody(context, component, true);
        writer.writeText((Object)")", null);
        writer.writeText((Object)";", null);
        writer.writeText((Object)this.getClientAttachmentOptions(context, menu), null);
        if (menu.isDisableDefaultMenu()) {
            writer.writeText((Object)"Richfaces.disableDefaultHandler('", null);
            writer.writeText((Object)event, null);
            writer.writeText((Object)"');", null);
        }
        writer.endElement("script");
    }

    private String getClientAttachmentOptions(FacesContext context, UIContextMenu contextMenu) {
        UIComponent parentComponent;
        String clientId;
        String[] splitAttachTo;
        if (!contextMenu.isAttached()) {
            return "";
        }
        String attachTo = contextMenu.getAttachTo();
        String attachTiming = contextMenu.getAttachTiming();
        boolean isImmediate = attachTiming.equals(IMMEDIATE);
        boolean isOnLoad = attachTiming.equals(ON_LOAD);
        boolean isOnAvailable = attachTiming.equals(ON_AVAILABLE);
        if (!(isImmediate || isOnLoad || isOnAvailable)) {
            return "";
        }
        String pattern = "\\s*,\\s*";
        ArrayList<String> attachToIds = new ArrayList<String>();
        for (String tempId : splitAttachTo = attachTo.split(pattern)) {
            if (tempId.length() <= 0) continue;
            attachToIds.add(tempId);
        }
        String baseJSFucntionName = "contextMenu.attachToElementById";
        if (attachToIds.size() == 0 && (clientId = (parentComponent = contextMenu.getParent()).getClientId(context)) != null) {
            attachToIds.add(clientId);
            baseJSFucntionName = "contextMenu.attachToParent";
        }
        StringBuilder attachContextMenuBuffer = new StringBuilder();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        for (UIComponent kid : contextMenu.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)kid;
            String name = parameter.getName();
            Object value = parameter.getValue();
            if (parameter instanceof JavaScriptParameter && ((JavaScriptParameter)parameter).isNoEscape()) {
                value = new JSReference(String.valueOf(value));
            }
            params.put(name, value);
        }
        for (String attachToId : attachToIds) {
            JSFunction attachContextMenuFunction = new JSFunction(baseJSFucntionName, new Object[0]);
            UIComponent target = RendererUtils.getInstance().findComponentFor(context, (UIComponent)contextMenu, attachToId);
            String clientId2 = target != null ? target.getClientId(context) : attachToId;
            attachContextMenuFunction.addParameter((Object)clientId2);
            attachContextMenuFunction.addParameter((Object)contextMenu.getEvent());
            attachContextMenuFunction.addParameter(params);
            if (isImmediate) {
                attachContextMenuBuffer.append(attachContextMenuFunction.toScript());
            } else if (isOnAvailable) {
                JSFunction availableFunction = new JSFunction("Richfaces.onAvailable", new Object[0]);
                availableFunction.addParameter((Object)clientId2);
                availableFunction.addParameter((Object)new JSBind(attachContextMenuFunction, new String[]{"contextMenu"}));
                attachContextMenuBuffer.append(availableFunction.toScript());
            } else if (isOnLoad) {
                JSFunction onloadFunction = new JSFunction("jQuery(document).ready", new Object[0]);
                onloadFunction.addParameter((Object)new JSBind(attachContextMenuFunction, new String[]{"contextMenu"}));
                attachContextMenuBuffer.append(onloadFunction.toScript());
            }
            attachContextMenuBuffer.append(";");
        }
        return attachContextMenuBuffer.toString();
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("div");
    }

    protected ContentHandler createContentHandler(Writer writer) {
        return new ContextMenuContentHandler(writer, "Richfaces.evalMacro(\"", "\", context)");
    }
}

