/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIExtendedDataTable;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONMap;
import org.richfaces.json.JSONStringer;
import org.richfaces.json.JSONWriter;

class ColumnsSizeState
implements Serializable {
    private static final long serialVersionUID = 8724163192351491340L;
    private static final String DEFAULT_WIDTH = "100";
    private JSONMap value;

    private ColumnsSizeState() {
    }

    static ColumnsSizeState getColumnsSize(UIExtendedDataTable extendedDataTable, JSONMap map) {
        ColumnsSizeState columnsSize = new ColumnsSizeState();
        columnsSize.init(extendedDataTable, map);
        return columnsSize;
    }

    private void init(UIExtendedDataTable extendedDataTable, JSONMap map) {
        this.value = null;
        if (map != null && map.size() > 0) {
            this.value = map;
        }
        if (this.value == null) {
            this.createDefaultColumnsSizeState(extendedDataTable);
        }
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public JSONMap toJSON() {
        return this.value;
    }

    private void createDefaultColumnsSizeState(UIExtendedDataTable extendedDataTable) {
        try {
            JSONWriter writer = new JSONStringer().object();
            Iterator<UIColumn> iter = extendedDataTable.getChildColumns();
            while (iter.hasNext()) {
                UIColumn col = iter.next();
                writer.key(col.getId()).value((Object)this.getDefaultColumnSize((UIComponent)col));
            }
            this.value = new JSONMap(writer.endObject().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private String getDefaultColumnSize(UIComponent column) {
        String widthStr = (String)column.getAttributes().get("width");
        return widthStr == null ? DEFAULT_WIDTH : widthStr;
    }

    public String getColumnSize(UIComponent column) {
        if (this.value == null) {
            return this.getDefaultColumnSize(column);
        }
        String res = (String)this.value.get((Object)column.getId());
        if (res == null) {
            res = this.getDefaultColumnSize(column);
        }
        return res;
    }

    public void changeColumnSize(UIExtendedDataTable extendedDataTable, String newValue) {
        if (this.value == null) {
            return;
        }
        String[] newWidths = newValue.split(";");
        int index = 0;
        Iterator<UIColumn> iter = extendedDataTable.getSortedColumns();
        while (iter.hasNext()) {
            UIComponent col = (UIComponent)iter.next();
            if (!col.isRendered()) continue;
            String colId = col.getId();
            this.value.put((Object)colId, (Object)newWidths[index++]);
        }
    }
}

