package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIVirtualEarth;

public class HtmlVirtualEarth extends UIVirtualEarth{

static public final  String COMPONENT_FAMILY = "org.richfaces.VirtualEarth";

static public final  String COMPONENT_TYPE = "org.richfaces.VirtualEarth";

/*
* Initial map type. The possible values are "Normal", "Small", "Tiny". Default value is "Normal".
*/
private  String _dashboardSize = null;

/*
* Initial latitude coordinate in degrees, as a number between -90 and +90. Default value is "37.9721046".
*/
private  String _lat = null;

/*
* Initial longitude coordinate in degrees, as a number between -180 and +180. Default value is "-122.04248428346".
*/
private  String _lng = null;

/*
* Navigation control size. Possible values are  "Road", "Aerial", "Hybrid", "Birdseye". Default value is Road
*/
private  String _mapStyle = null;

/*
* JavaScript code invoked just after the Virtual Earth object is initiated.
*/
private  String _onLoadMap = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* The JavaScript variable that is used to access the Virtual Earth API. If you have
			 more than one Virtual Earth components on the same page, use individual
			 key for each of them. Default value name is "map".
*/
private  String _var = null;

/*
* Virtual earth version, Default value is "6".
*/
private  String _version = null;

/*
* Initial zoom level as a number between 1 and 18. Default value is "17".
*/
private  String _zoom = null;


public HtmlVirtualEarth(){
setRendererType("org.richfaces.VirtualEarthRenderer");
}

public String getDashboardSize(){
	if (this._dashboardSize != null) {
		return this._dashboardSize;
	}
	ValueExpression ve = getValueExpression("dashboardSize");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "Normal";
	

}

public void setDashboardSize(String _dashboardSize){
this._dashboardSize = _dashboardSize;
}

public String getLat(){
	if (this._lat != null) {
		return this._lat;
	}
	ValueExpression ve = getValueExpression("lat");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "37.9721046";
	

}

public void setLat(String _lat){
this._lat = _lat;
}

public String getLng(){
	if (this._lng != null) {
		return this._lng;
	}
	ValueExpression ve = getValueExpression("lng");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "-122.0424842834";
	

}

public void setLng(String _lng){
this._lng = _lng;
}

public String getMapStyle(){
	if (this._mapStyle != null) {
		return this._mapStyle;
	}
	ValueExpression ve = getValueExpression("mapStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "Road";
	

}

public void setMapStyle(String _mapStyle){
this._mapStyle = _mapStyle;
}

public String getOnLoadMap(){
	if (this._onLoadMap != null) {
		return this._onLoadMap;
	}
	ValueExpression ve = getValueExpression("onLoadMap");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnLoadMap(String _onLoadMap){
this._onLoadMap = _onLoadMap;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getVar(){
	if (this._var != null) {
		return this._var;
	}
	ValueExpression ve = getValueExpression("var");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "map";
	

}

public void setVar(String _var){
this._var = _var;
}

public String getVersion(){
	if (this._version != null) {
		return this._version;
	}
	ValueExpression ve = getValueExpression("version");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "6.1";
	

}

public void setVersion(String _version){
this._version = _version;
}

public String getZoom(){
	if (this._zoom != null) {
		return this._zoom;
	}
	ValueExpression ve = getValueExpression("zoom");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "17";
	

}

public void setZoom(String _zoom){
this._zoom = _zoom;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[21];
state[0] = super.saveState(context);
state[1] = _dashboardSize;
state[2] = _lat;
state[3] = _lng;
state[4] = _mapStyle;
state[5] = _onLoadMap;
state[6] = _onclick;
state[7] = _ondblclick;
state[8] = _onkeydown;
state[9] = _onkeypress;
state[10] = _onkeyup;
state[11] = _onmousedown;
state[12] = _onmousemove;
state[13] = _onmouseout;
state[14] = _onmouseover;
state[15] = _onmouseup;
state[16] = _style;
state[17] = _styleClass;
state[18] = _var;
state[19] = _version;
state[20] = _zoom;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_dashboardSize = (String)states[1];;
		_lat = (String)states[2];;
		_lng = (String)states[3];;
		_mapStyle = (String)states[4];;
		_onLoadMap = (String)states[5];;
		_onclick = (String)states[6];;
		_ondblclick = (String)states[7];;
		_onkeydown = (String)states[8];;
		_onkeypress = (String)states[9];;
		_onkeyup = (String)states[10];;
		_onmousedown = (String)states[11];;
		_onmousemove = (String)states[12];;
		_onmouseout = (String)states[13];;
		_onmouseover = (String)states[14];;
		_onmouseup = (String)states[15];;
		_style = (String)states[16];;
		_styleClass = (String)states[17];;
		_var = (String)states[18];;
		_version = (String)states[19];;
		_zoom = (String)states[20];;
	
}

}
