package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UIDataFltrSlider;

public class HtmlDataFilterSlider extends UIDataFltrSlider{

static public final  String COMPONENT_FAMILY = "org.richfaces.DataFilterSlider";

static public final  String COMPONENT_TYPE = "org.richfaces.DataFilterSlider";

/*
* boolean attribute which provides possibility to limit JSF tree processing(decoding, conversion/validation, value applying) 
to the component which send the request only
*/
private  boolean _ajaxSingle = false;

private  boolean _ajaxSingleSet = false;

/*
* If "true", after process validations phase it skips updates of model beans on a force render response. It can be used for validating components input
*/
private  boolean _bypassUpdates = false;

private  boolean _bypassUpdatesSet = false;

/*
* An error message to use in client side validation events
*/
private  String _clientErrorMessage = null;

/*
* Serialized (on default with JSON) data passed on the client by a developer on AJAX request. It's accessible via "data.foo" syntax
*/
private  Object _data = null;

/*
* A slider end point
*/
private  Integer _endRange = null;

/*
* Name of requests queue to avoid send next request before complete other from same event. Can be used to reduce number of requests of frequently events (key press, mouse move etc.)
*/
private  String _eventsQueue = null;

/*
* The styleClass for input that displays the value : manualInput must
                be "true"
*/
private  String _fieldStyleClass = null;

/*
* A getter of an object member required to compare a slider value to. This is a
                value that is used in results filtering
*/
private  String _filterBy = null;

/*
* id of element to set focus after request completed on client side
*/
private  String _focus = null;

/*
* The component using UIData (datatable id)
*/
private  String _for = null;

/*
* This is a string which is used in a value attribute of the datatable. It is used for resetting
                the datatable back to the original list provided by a backing bean
*/
private  String _forValRef = null;

/*
* The handleStyleClass for a handle
*/
private  String _handleStyleClass = null;

/*
* Current handle value
*/
private  Integer _handleValue = null;

/*
* Attribute allows to ignore an Ajax Response produced by a request if the newest 'similar' request is
in a queue already. ignoreDupResponses="true" does not cancel the request while it is processed on the server,
but just allows to avoid unnecessary updates on the client side if the response isn't actual now
*/
private  boolean _ignoreDupResponses = false;

private  boolean _ignoreDupResponsesSet = false;

/*
* Amount to which a handle on each slide/move should be incremented
*/
private  Integer _increment = null;

/*
* If "true", then of all AJAX-rendered on the page components only those will be updated, 
		which ID's are passed to the "reRender" attribute of the describable component. 
		"false"-the default value-means that all components with ajaxRendered="true" will be updated.
*/
private  boolean _limitToList = false;

private  boolean _limitToListSet = false;

/*
* False value for this attribute makes text field "read-only" and "hidden".
                Hence, the value can be changed only from a handle
*/
private  boolean _manualInput = true;

private  boolean _manualInputSet = false;

/*
* DEPRECATED (use submitOnSlide). If the slider value changes must submit a form. Default value is "true".
*/
private  boolean _onSlideSubmit = true;

private  boolean _onSlideSubmitSet = false;

/*
* JavaScript code for call before DOM has been updated on client side
*/
private  String _onbeforedomupdate = null;

/*
* Event occur on chage
*/
private  String _onchange = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* JavaScript code for call after request completed on client side
*/
private  String _oncomplete = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: a script expression; event fires whenever an
        		JavaScript error occurs
*/
private  String _onerror = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _oninputkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _oninputkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _oninputkeyup = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* Event occur on sliding
*/
private  String _onslide = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, processed at the phases 2-5 in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _process = null;

/*
* The rangeStyleClass for the background div showing a full range
*/
private  String _rangeStyleClass = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, rendered in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _reRender = null;

/*
* Attribute defines the time (in ms.) that the request will be wait in the queue before it is ready to send.
When the delay time is over, the request will be sent to the server or removed if the newest 'similar' request is in a queue already
*/
private  int _requestDelay = Integer.MIN_VALUE;

private  boolean _requestDelaySet = false;

/*
* similarityGroupingId
*/
private  String _similarityGroupingId = null;

/*
* MethodBinding representing an action listener method that will be notified after changing of slider control position
*/
private  MethodBinding _sliderListener = null;

/*
* A slider begin point
*/
private  Integer _startRange = null;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* Specifies if the component will store a UIData object (your table rows) in session
*/
private  boolean _storeResults = false;

private  boolean _storeResultsSet = false;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* The styleClass for the container div surrounding the component
*/
private  String _styleClass = null;

/*
* If the slider value changes must submit a form. Default value is "true".
*/
private  boolean _submitOnSlide = true;

private  boolean _submitOnSlideSet = false;

/*
* Response waiting time on a particular request. If a response is not received during this time, the request is aborted
*/
private  int _timeout = Integer.MIN_VALUE;

private  boolean _timeoutSet = false;

/*
* The trackStyleClass for a background div
*/
private  String _trackStyleClass = null;

/*
* It shows or hides a trailer following a handle
*/
private  boolean _trailer = false;

private  boolean _trailerSet = false;

/*
* The trailerStyleClass for a div following a handle
*/
private  String _trailerStyleClass = null;

/*
* Width of the slider control. Default value is "200px".
*/
private  String _width = null;


public HtmlDataFilterSlider(){
setRendererType("org.richfaces.DataFilterSliderRenderer");
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public boolean isBypassUpdates(){
	if (this._bypassUpdatesSet) {
	    return (this._bypassUpdates);
	}
	ValueExpression ve = getValueExpression("bypassUpdates");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._bypassUpdates);
	    }
	    
	    return value;
	} else {
	    return (this._bypassUpdates);
	}

}

public void setBypassUpdates(boolean _bypassUpdates){
this._bypassUpdates = _bypassUpdates;
this._bypassUpdatesSet = true;
}

public String getClientErrorMessage(){
	if (this._clientErrorMessage != null) {
		return this._clientErrorMessage;
	}
	ValueExpression ve = getValueExpression("clientErrorMessage");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setClientErrorMessage(String _clientErrorMessage){
this._clientErrorMessage = _clientErrorMessage;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public Integer getEndRange(){
	if (this._endRange != null) {
		return this._endRange;
	}
	ValueExpression ve = getValueExpression("endRange");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEndRange(Integer _endRange){
this._endRange = _endRange;
}

public String getEventsQueue(){
	if (this._eventsQueue != null) {
		return this._eventsQueue;
	}
	ValueExpression ve = getValueExpression("eventsQueue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEventsQueue(String _eventsQueue){
this._eventsQueue = _eventsQueue;
}

public String getFieldStyleClass(){
	if (this._fieldStyleClass != null) {
		return this._fieldStyleClass;
	}
	ValueExpression ve = getValueExpression("fieldStyleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFieldStyleClass(String _fieldStyleClass){
this._fieldStyleClass = _fieldStyleClass;
}

public String getFilterBy(){
	if (this._filterBy != null) {
		return this._filterBy;
	}
	ValueExpression ve = getValueExpression("filterBy");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFilterBy(String _filterBy){
this._filterBy = _filterBy;
}

public String getFocus(){
	if (this._focus != null) {
		return this._focus;
	}
	ValueExpression ve = getValueExpression("focus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFocus(String _focus){
this._focus = _focus;
}

public String getFor(){
	if (this._for != null) {
		return this._for;
	}
	ValueExpression ve = getValueExpression("for");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFor(String _for){
this._for = _for;
}

public String getForValRef(){
	if (this._forValRef != null) {
		return this._forValRef;
	}
	ValueExpression ve = getValueExpression("forValRef");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setForValRef(String _forValRef){
this._forValRef = _forValRef;
}

public String getHandleStyleClass(){
	if (this._handleStyleClass != null) {
		return this._handleStyleClass;
	}
	ValueExpression ve = getValueExpression("handleStyleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHandleStyleClass(String _handleStyleClass){
this._handleStyleClass = _handleStyleClass;
}

public Integer getHandleValue(){
	if (this._handleValue != null) {
		return this._handleValue;
	}
	ValueExpression ve = getValueExpression("handleValue");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHandleValue(Integer _handleValue){
this._handleValue = _handleValue;
}

public boolean isIgnoreDupResponses(){
	if (this._ignoreDupResponsesSet) {
	    return (this._ignoreDupResponses);
	}
	ValueExpression ve = getValueExpression("ignoreDupResponses");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ignoreDupResponses);
	    }
	    
	    return value;
	} else {
	    return (this._ignoreDupResponses);
	}

}

public void setIgnoreDupResponses(boolean _ignoreDupResponses){
this._ignoreDupResponses = _ignoreDupResponses;
this._ignoreDupResponsesSet = true;
}

public Integer getIncrement(){
	if (this._increment != null) {
		return this._increment;
	}
	ValueExpression ve = getValueExpression("increment");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIncrement(Integer _increment){
this._increment = _increment;
}

public boolean isLimitToList(){
	if (this._limitToListSet) {
	    return (this._limitToList);
	}
	ValueExpression ve = getValueExpression("limitToList");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._limitToList);
	    }
	    
	    return value;
	} else {
	    return (this._limitToList);
	}

}

public void setLimitToList(boolean _limitToList){
this._limitToList = _limitToList;
this._limitToListSet = true;
}

public boolean isManualInput(){
	if (this._manualInputSet) {
	    return (this._manualInput);
	}
	ValueExpression ve = getValueExpression("manualInput");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._manualInput);
	    }
	    
	    return value;
	} else {
	    return (this._manualInput);
	}

}

public void setManualInput(boolean _manualInput){
this._manualInput = _manualInput;
this._manualInputSet = true;
}

public boolean isOnSlideSubmit(){
	if (this._onSlideSubmitSet) {
	    return (this._onSlideSubmit);
	}
	ValueExpression ve = getValueExpression("onSlideSubmit");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._onSlideSubmit);
	    }
	    
	    return value;
	} else {
	    return (this._onSlideSubmit);
	}

}

public void setOnSlideSubmit(boolean _onSlideSubmit){
this._onSlideSubmit = _onSlideSubmit;
this._onSlideSubmitSet = true;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnerror(){
	if (this._onerror != null) {
		return this._onerror;
	}
	ValueExpression ve = getValueExpression("onerror");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnerror(String _onerror){
this._onerror = _onerror;
}

public String getOninputkeydown(){
	if (this._oninputkeydown != null) {
		return this._oninputkeydown;
	}
	ValueExpression ve = getValueExpression("oninputkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeydown(String _oninputkeydown){
this._oninputkeydown = _oninputkeydown;
}

public String getOninputkeypress(){
	if (this._oninputkeypress != null) {
		return this._oninputkeypress;
	}
	ValueExpression ve = getValueExpression("oninputkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeypress(String _oninputkeypress){
this._oninputkeypress = _oninputkeypress;
}

public String getOninputkeyup(){
	if (this._oninputkeyup != null) {
		return this._oninputkeyup;
	}
	ValueExpression ve = getValueExpression("oninputkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeyup(String _oninputkeyup){
this._oninputkeyup = _oninputkeyup;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnslide(){
	if (this._onslide != null) {
		return this._onslide;
	}
	ValueExpression ve = getValueExpression("onslide");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnslide(String _onslide){
this._onslide = _onslide;
}

public Object getProcess(){
	if (this._process != null) {
		return this._process;
	}
	ValueExpression ve = getValueExpression("process");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProcess(Object _process){
this._process = _process;
}

public String getRangeStyleClass(){
	if (this._rangeStyleClass != null) {
		return this._rangeStyleClass;
	}
	ValueExpression ve = getValueExpression("rangeStyleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRangeStyleClass(String _rangeStyleClass){
this._rangeStyleClass = _rangeStyleClass;
}

public Object getReRender(){
	if (this._reRender != null) {
		return this._reRender;
	}
	ValueExpression ve = getValueExpression("reRender");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setReRender(Object _reRender){
this._reRender = _reRender;
}

public int getRequestDelay(){
	if (this._requestDelaySet) {
	    return (this._requestDelay);
	}
	ValueExpression ve = getValueExpression("requestDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._requestDelay);
	    }
	    
	    return value;
	} else {
	    return (this._requestDelay);
	}

}

public void setRequestDelay(int _requestDelay){
this._requestDelay = _requestDelay;
this._requestDelaySet = true;
}

public String getSimilarityGroupingId(){
	if (this._similarityGroupingId != null) {
		return this._similarityGroupingId;
	}
	ValueExpression ve = getValueExpression("similarityGroupingId");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSimilarityGroupingId(String _similarityGroupingId){
this._similarityGroupingId = _similarityGroupingId;
}

public MethodBinding getSliderListener(){
return _sliderListener;
}

public void setSliderListener(MethodBinding _sliderListener){
this._sliderListener = _sliderListener;
}

public Integer getStartRange(){
	if (this._startRange != null) {
		return this._startRange;
	}
	ValueExpression ve = getValueExpression("startRange");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStartRange(Integer _startRange){
this._startRange = _startRange;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public boolean isStoreResults(){
	if (this._storeResultsSet) {
	    return (this._storeResults);
	}
	ValueExpression ve = getValueExpression("storeResults");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._storeResults);
	    }
	    
	    return value;
	} else {
	    return (this._storeResults);
	}

}

public void setStoreResults(boolean _storeResults){
this._storeResults = _storeResults;
this._storeResultsSet = true;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public boolean isSubmitOnSlide(){
	if (this._submitOnSlideSet) {
	    return (this._submitOnSlide);
	}
	ValueExpression ve = getValueExpression("submitOnSlide");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._submitOnSlide);
	    }
	    
	    return value;
	} else {
	    return (this._submitOnSlide);
	}

}

public void setSubmitOnSlide(boolean _submitOnSlide){
this._submitOnSlide = _submitOnSlide;
this._submitOnSlideSet = true;
}

public int getTimeout(){
	if (this._timeoutSet) {
	    return (this._timeout);
	}
	ValueExpression ve = getValueExpression("timeout");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._timeout);
	    }
	    
	    return value;
	} else {
	    return (this._timeout);
	}

}

public void setTimeout(int _timeout){
this._timeout = _timeout;
this._timeoutSet = true;
}

public String getTrackStyleClass(){
	if (this._trackStyleClass != null) {
		return this._trackStyleClass;
	}
	ValueExpression ve = getValueExpression("trackStyleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTrackStyleClass(String _trackStyleClass){
this._trackStyleClass = _trackStyleClass;
}

public boolean isTrailer(){
	if (this._trailerSet) {
	    return (this._trailer);
	}
	ValueExpression ve = getValueExpression("trailer");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._trailer);
	    }
	    
	    return value;
	} else {
	    return (this._trailer);
	}

}

public void setTrailer(boolean _trailer){
this._trailer = _trailer;
this._trailerSet = true;
}

public String getTrailerStyleClass(){
	if (this._trailerStyleClass != null) {
		return this._trailerStyleClass;
	}
	ValueExpression ve = getValueExpression("trailerStyleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTrailerStyleClass(String _trailerStyleClass){
this._trailerStyleClass = _trailerStyleClass;
}

public String getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "200px";
	

}

public void setWidth(String _width){
this._width = _width;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[65];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_ajaxSingle);
state[2] = Boolean.valueOf(_ajaxSingleSet);
state[3] = Boolean.valueOf(_bypassUpdates);
state[4] = Boolean.valueOf(_bypassUpdatesSet);
state[5] = _clientErrorMessage;
state[6] = saveAttachedState(context, _data);
state[7] = _endRange;
state[8] = _eventsQueue;
state[9] = _fieldStyleClass;
state[10] = _filterBy;
state[11] = _focus;
state[12] = _for;
state[13] = _forValRef;
state[14] = _handleStyleClass;
state[15] = _handleValue;
state[16] = Boolean.valueOf(_ignoreDupResponses);
state[17] = Boolean.valueOf(_ignoreDupResponsesSet);
state[18] = _increment;
state[19] = Boolean.valueOf(_limitToList);
state[20] = Boolean.valueOf(_limitToListSet);
state[21] = Boolean.valueOf(_manualInput);
state[22] = Boolean.valueOf(_manualInputSet);
state[23] = Boolean.valueOf(_onSlideSubmit);
state[24] = Boolean.valueOf(_onSlideSubmitSet);
state[25] = _onbeforedomupdate;
state[26] = _onchange;
state[27] = _onclick;
state[28] = _oncomplete;
state[29] = _ondblclick;
state[30] = _onerror;
state[31] = _oninputkeydown;
state[32] = _oninputkeypress;
state[33] = _oninputkeyup;
state[34] = _onkeydown;
state[35] = _onkeypress;
state[36] = _onkeyup;
state[37] = _onmousedown;
state[38] = _onmousemove;
state[39] = _onmouseout;
state[40] = _onmouseover;
state[41] = _onmouseup;
state[42] = _onslide;
state[43] = saveAttachedState(context, _process);
state[44] = _rangeStyleClass;
state[45] = saveAttachedState(context, _reRender);
state[46] = Integer.valueOf(_requestDelay);
state[47] = Boolean.valueOf(_requestDelaySet);
state[48] = _similarityGroupingId;
state[49] = saveAttachedState(context, _sliderListener);
state[50] = _startRange;
state[51] = _status;
state[52] = Boolean.valueOf(_storeResults);
state[53] = Boolean.valueOf(_storeResultsSet);
state[54] = _style;
state[55] = _styleClass;
state[56] = Boolean.valueOf(_submitOnSlide);
state[57] = Boolean.valueOf(_submitOnSlideSet);
state[58] = Integer.valueOf(_timeout);
state[59] = Boolean.valueOf(_timeoutSet);
state[60] = _trackStyleClass;
state[61] = Boolean.valueOf(_trailer);
state[62] = Boolean.valueOf(_trailerSet);
state[63] = _trailerStyleClass;
state[64] = _width;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_ajaxSingle = ((Boolean)states[1]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[2]).booleanValue();
		_bypassUpdates = ((Boolean)states[3]).booleanValue();
		_bypassUpdatesSet = ((Boolean)states[4]).booleanValue();
		_clientErrorMessage = (String)states[5];;
		_data = (Object)restoreAttachedState(context, states[6]);
		_endRange = (Integer)states[7];;
		_eventsQueue = (String)states[8];;
		_fieldStyleClass = (String)states[9];;
		_filterBy = (String)states[10];;
		_focus = (String)states[11];;
		_for = (String)states[12];;
		_forValRef = (String)states[13];;
		_handleStyleClass = (String)states[14];;
		_handleValue = (Integer)states[15];;
		_ignoreDupResponses = ((Boolean)states[16]).booleanValue();
		_ignoreDupResponsesSet = ((Boolean)states[17]).booleanValue();
		_increment = (Integer)states[18];;
		_limitToList = ((Boolean)states[19]).booleanValue();
		_limitToListSet = ((Boolean)states[20]).booleanValue();
		_manualInput = ((Boolean)states[21]).booleanValue();
		_manualInputSet = ((Boolean)states[22]).booleanValue();
		_onSlideSubmit = ((Boolean)states[23]).booleanValue();
		_onSlideSubmitSet = ((Boolean)states[24]).booleanValue();
		_onbeforedomupdate = (String)states[25];;
		_onchange = (String)states[26];;
		_onclick = (String)states[27];;
		_oncomplete = (String)states[28];;
		_ondblclick = (String)states[29];;
		_onerror = (String)states[30];;
		_oninputkeydown = (String)states[31];;
		_oninputkeypress = (String)states[32];;
		_oninputkeyup = (String)states[33];;
		_onkeydown = (String)states[34];;
		_onkeypress = (String)states[35];;
		_onkeyup = (String)states[36];;
		_onmousedown = (String)states[37];;
		_onmousemove = (String)states[38];;
		_onmouseout = (String)states[39];;
		_onmouseover = (String)states[40];;
		_onmouseup = (String)states[41];;
		_onslide = (String)states[42];;
		_process = (Object)restoreAttachedState(context, states[43]);
		_rangeStyleClass = (String)states[44];;
		_reRender = (Object)restoreAttachedState(context, states[45]);
		_requestDelay = ((Integer)states[46]).intValue();
		_requestDelaySet = ((Boolean)states[47]).booleanValue();
		_similarityGroupingId = (String)states[48];;
		_sliderListener = (MethodBinding)restoreAttachedState(context, states[49]);
		_startRange = (Integer)states[50];;
		_status = (String)states[51];;
		_storeResults = ((Boolean)states[52]).booleanValue();
		_storeResultsSet = ((Boolean)states[53]).booleanValue();
		_style = (String)states[54];;
		_styleClass = (String)states[55];;
		_submitOnSlide = ((Boolean)states[56]).booleanValue();
		_submitOnSlideSet = ((Boolean)states[57]).booleanValue();
		_timeout = ((Integer)states[58]).intValue();
		_timeoutSet = ((Boolean)states[59]).booleanValue();
		_trackStyleClass = (String)states[60];;
		_trailer = ((Boolean)states[61]).booleanValue();
		_trailerSet = ((Boolean)states[62]).booleanValue();
		_trailerStyleClass = (String)states[63];;
		_width = (String)states[64];;
	
}

}
