/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.AjaxScript;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxComponentRendererBase;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIToolTip;
import org.richfaces.skin.Skin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolTipRenderer
extends AjaxComponentRendererBase {
    private final InternetResource[] styles = new InternetResource[]{this.getResource("/org/richfaces/renderkit/html/css/tooltip.xcss")};
    private InternetResource[] stylesAll = null;
    private final InternetResource[] scripts = new InternetResource[]{new PrototypeScript(), new AjaxScript(), this.getResource("/org/richfaces/renderkit/html/scripts/jquery/jquery.js"), this.getResource("/org/richfaces/renderkit/html/scripts/utils.js"), this.getResource("/org/richfaces/renderkit/html/scripts/tooltip.js")};
    private InternetResource[] scriptsAll = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternetResource[] getStyles() {
        ToolTipRenderer toolTipRenderer = this;
        synchronized (toolTipRenderer) {
            if (this.stylesAll == null) {
                boolean ignoreThis;
                InternetResource[] rsrcs = super.getStyles();
                boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
                boolean bl = ignoreThis = this.styles == null || this.styles.length == 0;
                if (ignoreSuper) {
                    this.stylesAll = ignoreThis ? new InternetResource[0] : this.styles;
                } else if (ignoreThis) {
                    this.stylesAll = rsrcs;
                } else {
                    int i;
                    LinkedHashSet<InternetResource> rsrcsSet = new LinkedHashSet<InternetResource>();
                    for (i = 0; i < rsrcs.length; ++i) {
                        rsrcsSet.add(rsrcs[i]);
                    }
                    for (i = 0; i < this.styles.length; ++i) {
                        rsrcsSet.add(this.styles[i]);
                    }
                    this.stylesAll = rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
                }
            }
        }
        return this.stylesAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternetResource[] getScripts() {
        ToolTipRenderer toolTipRenderer = this;
        synchronized (toolTipRenderer) {
            if (this.scriptsAll == null) {
                boolean ignoreThis;
                InternetResource[] rsrcs = super.getScripts();
                boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
                boolean bl = ignoreThis = this.scripts == null || this.scripts.length == 0;
                if (ignoreSuper) {
                    this.scriptsAll = ignoreThis ? new InternetResource[0] : this.scripts;
                } else if (ignoreThis) {
                    this.scriptsAll = rsrcs;
                } else {
                    int i;
                    LinkedHashSet<InternetResource> rsrcsSet = new LinkedHashSet<InternetResource>();
                    for (i = 0; i < rsrcs.length; ++i) {
                        rsrcsSet.add(rsrcs[i]);
                    }
                    for (i = 0; i < this.scripts.length; ++i) {
                        rsrcsSet.add(this.scripts[i]);
                    }
                    this.scriptsAll = rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
                }
            }
        }
        return this.scriptsAll;
    }

    protected Class getComponentClass() {
        return UIToolTip.class;
    }

    public String getBgColor(FacesContext context, UIComponent component) {
        Skin skin = this.getSkin(context);
        String color = (String)skin.getParameter(context, "headerBackgroundColor");
        return color;
    }

    public String getColor(FacesContext context, UIComponent component) {
        Skin skin = this.getSkin(context);
        String color = (String)skin.getParameter(context, "headerTextColor");
        return color;
    }

    public Map<String, Object> buildEventOptions(FacesContext context, UIComponent component, String targetId) {
        JSFunctionDefinition beforeUpdate;
        JSFunctionDefinition onComplete;
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
        String jsVarName = "_toolTip";
        String clientId = component.getClientId(context);
        String oncompleteTooltip = ";{var " + jsVarName + " = $('" + clientId + "').component;" + jsVarName + ".toolTipContent = $('" + clientId + "content');" + jsVarName + ".displayDiv();" + "}";
        String fireBeforeUpdateDOM = ";{ var " + jsVarName + " = $('" + clientId + "').component;" + jsVarName + ".toolTip.style.display = 'none'; }";
        eventOptions.put("control", JSReference.THIS);
        if (eventOptions.containsKey("oncomplete")) {
            onComplete = (JSFunctionDefinition)eventOptions.get("oncomplete");
            onComplete.addToBody((Object)oncompleteTooltip);
            eventOptions.put("oncomplete", onComplete);
        } else {
            onComplete = new JSFunctionDefinition(new Object[0]);
            onComplete.addParameter((Object)"request");
            onComplete.addParameter((Object)"showEvent");
            onComplete.addParameter((Object)"data");
            onComplete.addToBody((Object)oncompleteTooltip);
            eventOptions.put("oncomplete", onComplete);
        }
        if (eventOptions.containsKey("onbeforedomupdate")) {
            beforeUpdate = (JSFunctionDefinition)eventOptions.get("onbeforedomupdate");
            beforeUpdate.addToBody((Object)fireBeforeUpdateDOM);
            eventOptions.put("onbeforedomupdate", beforeUpdate);
        } else {
            beforeUpdate = new JSFunctionDefinition(new Object[0]);
            beforeUpdate.addParameter((Object)"request");
            beforeUpdate.addParameter((Object)"showEvent");
            beforeUpdate.addParameter((Object)"data");
            beforeUpdate.addToBody((Object)fireBeforeUpdateDOM);
            eventOptions.put("onbeforedomupdate", beforeUpdate);
        }
        return eventOptions;
    }

    public void insertScript(FacesContext context, UIComponent component) throws IOException {
        UIToolTip toolTip = (UIToolTip)component;
        StringBuffer ret = new StringBuffer();
        ret.append("<script ");
        ret.append("type=\"text/javascript\" ");
        ret.append("id =\"script" + component.getClientId(context) + "\">\n");
        StringBuffer script = new StringBuffer();
        String jsVar = this.constructJSVariable(context, component);
        script.append(jsVar).append(";\n");
        ret.append(script.toString());
        ret.append("\n</script>");
        ResponseWriter writer = context.getResponseWriter();
        writer.write(ret.toString());
    }

    public Map<String, Object> getParamsMap(FacesContext context, UIToolTip toolTip) {
        List children = toolTip.getChildren();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        for (UIComponent child : children) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            paramsMap.put(param.getName(), param.getValue());
        }
        return paramsMap;
    }

    private String getTargetId(FacesContext context, UIComponent component) {
        UIToolTip toolTip = (UIToolTip)component;
        String forValue = toolTip.getFor();
        if (forValue != null && forValue.length() != 0) {
            UIComponent targetComponent = this.getUtils().findComponentFor(component, forValue);
            if (targetComponent != null) {
                return targetComponent.getClientId(context);
            }
            return forValue;
        }
        return component.getParent().getClientId(context);
    }

    public String constructJSVariable(FacesContext context, UIComponent component) {
        String eventHide;
        UIToolTip toolTip = (UIToolTip)component;
        String targetClientId = this.getTargetId(context, component);
        StringBuffer ret = new StringBuffer();
        String comma = ",";
        String quot = "\"";
        String eventShow = toolTip.isAttached() ? toolTip.getShowEvent() : "";
        String string = eventHide = toolTip.isAttached() ? toolTip.getHideEvent() : "";
        if (eventShow.startsWith("on")) {
            eventShow = eventShow.substring(2);
        }
        if (eventHide.startsWith("on")) {
            eventHide = eventHide.substring(2);
        }
        HashMap<JSReference, Object> eventsMap = new HashMap<JSReference, Object>();
        eventsMap.put(new JSReference("showEvent"), eventShow);
        eventsMap.put(new JSReference("hideEvent"), eventHide);
        eventsMap.put(new JSReference("delay"), new Integer(toolTip.getShowDelay()));
        eventsMap.put(new JSReference("hideDelay"), new Integer(toolTip.getHideDelay()));
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context);
        JSReference ref = new JSReference("ajaxOptions");
        function.addParameter((Object)ref);
        String ajaxFunc = function.toScript();
        Map<String, Object> ajaxOptions = this.buildEventOptions(context, (UIComponent)toolTip, targetClientId);
        ajaxOptions.putAll(this.getParamsMap(context, toolTip));
        JSFunctionDefinition completeFunc = this.getUtils().getAsEventHandler(context, component, "oncomplete", "; return true;");
        JSFunctionDefinition hideFunc = this.getUtils().getAsEventHandler(context, component, "onhide", "; return true;");
        JSFunctionDefinition showFunc = this.getUtils().getAsEventHandler(context, component, "onshow", "; return true;");
        HashMap<JSReference, JSFunctionDefinition> funcMap = new HashMap<JSReference, JSFunctionDefinition>();
        funcMap.put(new JSReference("oncomplete"), completeFunc);
        funcMap.put(new JSReference("onhide"), hideFunc);
        funcMap.put(new JSReference("onshow"), showFunc);
        ret.append("new ToolTip(" + ScriptUtils.toScript(eventsMap)).append(comma).append(ScriptUtils.toScript(funcMap)).append(comma).append(quot).append(toolTip.getClientId(context)).append(quot).append(comma).append(quot).append(targetClientId).append(quot).append(comma).append(quot).append(toolTip.getMode()).append(quot).append(comma).append(toolTip.isDisabled()).append(comma).append(quot).append(toolTip.getDirection()).append(quot).append(comma).append(toolTip.isFollowMouse()).append(comma).append(toolTip.getHorizontalOffset()).append(comma).append(toolTip.getVerticalOffset()).append(comma).append("\"").append(ajaxFunc).append("\"").append(comma).append(ScriptUtils.toScript(ajaxOptions)).append(");");
        return ret.toString();
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        UIToolTip tooltip = (UIToolTip)component;
        String clientId = tooltip.getClientId(context);
        if (context.getExternalContext().getRequestParameterMap().containsKey(clientId) && "ajax".equals(tooltip.getMode())) {
            new AjaxEvent(component).queue();
            new ActionEvent(component).queue();
        }
    }

    public void encodeTooltipText(FacesContext context, UIToolTip component) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.startElement(component.getUsedElementType(), (UIComponent)component);
        responseWriter.writeAttribute("id", (Object)(component.getClientId(context) + "content"), null);
        if ("ajax".equals(component.getMode())) {
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance();
            if (ajaxContext != null && ajaxContext.getAjaxAreasToRender().contains(component.getClientId(context) + "content")) {
                responseWriter.write(component.getValue() != null ? component.getValue().toString() : "");
                super.renderChildren(context, (UIComponent)component);
            }
        } else {
            responseWriter.write(component.getValue() != null ? component.getValue().toString() : "");
            super.renderChildren(context, (UIComponent)component);
        }
        responseWriter.endElement(component.getUsedElementType());
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIToolTip toolTip = (UIToolTip)component;
        Class<?> rendererClass = null;
        try {
            if ("block".equals(toolTip.getLayout())) {
                rendererClass = Class.forName("org.richfaces.renderkit.html.HtmlToolTipRendererBlock");
            } else if ("inline".equals(toolTip.getLayout())) {
                rendererClass = Class.forName("org.richfaces.renderkit.html.HtmlToolTipRenderer");
            } else {
                throw new FacesException("Only \"block\" or \"inline\" values can be established to attribute \"layout\".");
            }
            ToolTipRenderer renderer = (ToolTipRenderer)((Object)rendererClass.newInstance());
            renderer.doEncodeBegin(writer, context, component);
        }
        catch (Exception e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIToolTip toolTip = (UIToolTip)component;
        Class<?> rendererClass = null;
        try {
            rendererClass = "block".equals(toolTip.getLayout()) ? Class.forName("org.richfaces.renderkit.html.HtmlToolTipRendererBlock") : Class.forName("org.richfaces.renderkit.html.HtmlToolTipRenderer");
            ToolTipRenderer renderer = null;
            renderer = (ToolTipRenderer)((Object)rendererClass.newInstance());
            renderer.doEncodeChildren(writer, context, component);
        }
        catch (Exception e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIToolTip toolTip = (UIToolTip)component;
        Class<?> rendererClass = null;
        try {
            rendererClass = "block".equals(toolTip.getLayout()) ? Class.forName("org.richfaces.renderkit.html.HtmlToolTipRendererBlock") : Class.forName("org.richfaces.renderkit.html.HtmlToolTipRenderer");
            ToolTipRenderer renderer = (ToolTipRenderer)((Object)rendererClass.newInstance());
            renderer.doEncodeEnd(writer, context, component);
        }
        catch (Exception e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

