/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.model.DataVisitor;
import org.richfaces.component.UIExtendedDataTable;
import org.richfaces.model.selection.ClientSelection;
import org.richfaces.model.selection.Selection;
import org.richfaces.model.selection.SimpleSelection;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;
import org.richfaces.renderkit.TableHolder;
import org.richfaces.renderkit.html.HTMLEncodingContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSelectionRendererContributor
implements RendererContributor,
HTMLEncodingContributor {
    public static final String CLIENT_SELECTION = "clientSelection";

    public static final String getSelectionInputName(FacesContext context, UIExtendedDataTable table) {
        String id = table.getBaseClientId(context) + ":s";
        return id;
    }

    public static final String getGridId(FacesContext context, UIExtendedDataTable table) {
        return table.getBaseClientId(context);
    }

    public void decode(FacesContext context, UIComponent component, CompositeRenderer compositeRenderer) {
        final UIExtendedDataTable table = (UIExtendedDataTable)component;
        ExternalContext externalContext = context.getExternalContext();
        Map requestParamMap = externalContext.getRequestParameterMap();
        Application application = context.getApplication();
        String id = TableSelectionRendererContributor.getSelectionInputName(context, table);
        String value = (String)requestParamMap.get(id);
        if (value != null) {
            SimpleSelection simpleSelection;
            Converter converter = application.createConverter(ClientSelection.class);
            ClientSelection _oldClientSelection = (ClientSelection)table.getAttributes().get(CLIENT_SELECTION);
            final ClientSelection oldClientSelection = _oldClientSelection == null ? new ClientSelection() : _oldClientSelection;
            final ClientSelection clientSelection = (ClientSelection)converter.getAsObject(context, (UIComponent)table, value);
            final TableHolder holder = new TableHolder((UIDataAdaptor)table);
            SimpleSelection simpleSelection2 = simpleSelection = table.getSelection() == null ? new SimpleSelection() : (SimpleSelection)table.getSelection();
            if (clientSelection.isReset() || clientSelection.isSelectAll()) {
                simpleSelection.clear();
            }
            try {
                table.walk(context, new DataVisitor(){

                    public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
                        int i = holder.getRowCounter();
                        if (TableSelectionRendererContributor.this.shouldAddToSelection(i, oldClientSelection, clientSelection)) {
                            simpleSelection.addKey(rowKey);
                        } else if (TableSelectionRendererContributor.this.shouldRemoveFromSelection(i, oldClientSelection, clientSelection)) {
                            simpleSelection.removeKey(rowKey);
                        }
                        if (i == clientSelection.getActiveRowIndex()) {
                            table.setActiveRowKey(rowKey);
                        }
                        holder.nextRow();
                    }
                }, holder);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            table.setSelection((Selection)simpleSelection);
            ValueExpression selectionBinding = table.getValueExpression("selection");
            if (selectionBinding != null) {
                selectionBinding.setValue(context.getELContext(), (Object)simpleSelection);
            }
        }
    }

    public Class<?> getAcceptableClass() {
        return UIExtendedDataTable.class;
    }

    public String getScriptContribution(FacesContext context, UIComponent component) {
        return null;
    }

    public String[] getScriptDependencies() {
        return null;
    }

    public String[] getStyleDependencies() {
        return null;
    }

    public ScriptOptions buildOptions(FacesContext context, UIComponent component) {
        ScriptOptions scriptOptions = new ScriptOptions(component);
        scriptOptions.addOption("selectionInput", (Object)TableSelectionRendererContributor.getSelectionInputName(context, (UIExtendedDataTable)component));
        scriptOptions.addOption("gridId", (Object)TableSelectionRendererContributor.getGridId(context, (UIExtendedDataTable)component));
        Map attributes = component.getAttributes();
        Object attribut = attributes.get("selectedClass");
        if (attribut == null) {
            attribut = "";
        }
        scriptOptions.addOption("selectedClass", attribut);
        attribut = attributes.get("activeClass");
        if (attribut == null) {
            attribut = "";
        }
        scriptOptions.addOption("activeClass", attribut);
        attribut = attributes.get("selectionMode");
        if (attribut == null) {
            attribut = "";
        }
        scriptOptions.addOption("selectionMode", attribut);
        attribut = attributes.get("onselectionchange");
        if (attribut == null) {
            attribut = "";
        }
        JSFunctionDefinition function = new JSFunctionDefinition(new Object[0]);
        function.addToBody(attribut);
        scriptOptions.addEventHandler("onselectionchange", function);
        return scriptOptions;
    }

    @Override
    public void encode(FacesContext context, UIComponent component) throws IOException {
        UIExtendedDataTable grid = (UIExtendedDataTable)component;
        this.encodeSelection(context, grid);
        this.writeSelection(context, grid);
    }

    public boolean shouldAddToSelection(int i, ClientSelection oldSelection, ClientSelection newSelection) {
        return newSelection.isSelectAll() || newSelection.isSelected(i) && (!oldSelection.isSelected(i) || newSelection.isReset());
    }

    public boolean shouldRemoveFromSelection(int i, ClientSelection oldSelection, ClientSelection newSelection) {
        return !newSelection.isReset() && !newSelection.isSelectAll() && !newSelection.isSelected(i) && oldSelection.isSelected(i);
    }

    private void encodeSelection(FacesContext context, UIExtendedDataTable table) throws IOException {
        TableHolder holder = new TableHolder((UIDataAdaptor)table);
        SimpleSelection gridSelection = table.getSelection() == null ? new SimpleSelection() : table.getSelection();
        ClientSelection clientSelection = new ClientSelection();
        table.walk(context, new DataVisitor((Selection)gridSelection, holder, clientSelection, table){
            final /* synthetic */ Selection val$gridSelection;
            final /* synthetic */ TableHolder val$holder;
            final /* synthetic */ ClientSelection val$clientSelection;
            final /* synthetic */ UIExtendedDataTable val$table;
            {
                this.val$gridSelection = selection;
                this.val$holder = tableHolder;
                this.val$clientSelection = clientSelection;
                this.val$table = uIExtendedDataTable;
            }

            public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
                if (this.val$gridSelection.isSelected(rowKey)) {
                    int i = this.val$holder.getRowCounter();
                    this.val$clientSelection.addIndex(i);
                }
                if (rowKey.equals(this.val$table.getActiveRowKey())) {
                    this.val$clientSelection.setActiveRowIndex(this.val$holder.getRowCounter());
                }
                this.val$holder.nextRow();
            }
        }, holder);
        table.getAttributes().put(CLIENT_SELECTION, clientSelection);
    }

    public void writeSelection(FacesContext context, UIExtendedDataTable table) throws IOException {
        ClientSelection selection;
        Application application = context.getApplication();
        Converter converter = application.createConverter(ClientSelection.class);
        String string = converter.getAsString(context, (UIComponent)table, (Object)(selection = (ClientSelection)table.getAttributes().get(CLIENT_SELECTION)));
        if (string == null) {
            string = "";
        }
        string = string + selection.getActiveRowIndex();
        String id = TableSelectionRendererContributor.getSelectionInputName(context, table);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)table);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("value", (Object)string, null);
        writer.endElement("input");
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (ajaxContext.isAjaxRequest()) {
            ajaxContext.addRenderedArea(id);
        }
    }
}

