/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.model.DataModel;
import org.ajax4jsf.Messages;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.SequenceDataModel;
import org.richfaces.component.UIOrderingBaseComponent;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.model.OrderingListDataModel;

public abstract class UIOrderingList
extends UIOrderingBaseComponent {
    private ValueHolder valueHolder;
    private transient SubmittedValue submittedValueHolder = null;
    protected final UIOrderingBaseComponent.UpdateModelCommand updateActiveItemCommand = new UIOrderingBaseComponent.UpdateModelCommand(){

        public void execute(FacesContext context) {
            ValueBinding vb;
            if (UIOrderingList.this.valueHolder.activeItemSet && (vb = UIOrderingList.this.getValueBinding("activeItem")) != null) {
                vb.setValue(context, UIOrderingList.this.valueHolder.activeItem);
                UIOrderingList.this.valueHolder.activeItem = null;
                UIOrderingList.this.valueHolder.activeItemSet = false;
            }
        }
    };
    protected final UIOrderingBaseComponent.UpdateModelCommand updateSelectionCommand = new UIOrderingBaseComponent.UpdateModelCommand(){

        public void execute(FacesContext context) {
            ValueBinding vb;
            if (UIOrderingList.this.valueHolder.selectionSet && (vb = UIOrderingList.this.getValueBinding("selection")) != null) {
                vb.setValue(context, (Object)UIOrderingList.this.valueHolder.selection);
                UIOrderingList.this.valueHolder.selection = null;
                UIOrderingList.this.valueHolder.selectionSet = false;
            }
        }
    };
    protected final UIOrderingBaseComponent.UpdateModelCommand updateValueCommand = new UIOrderingBaseComponent.UpdateModelCommand(){

        public void execute(FacesContext context) {
            ValueBinding vb;
            if (UIOrderingList.this.isLocalValueSet() && UIOrderingList.this.valueHolder != null && (vb = UIOrderingList.this.getValueBinding("value")) != null) {
                vb.setValue(context, UIOrderingList.this.valueHolder.value);
                UIOrderingList.this.setValue(null);
                UIOrderingList.this.setLocalValueSet(false);
            }
        }
    };

    protected void processDecodes(FacesContext faces, Object argument) {
        if (!this.isRendered()) {
            return;
        }
        this.decode(faces);
        SubmittedValue submittedValue = this.submittedValueHolder;
        if (submittedValue != null) {
            Object modelValue = this.getValue();
            for (Map.Entry entry : submittedValue.dataMap.entrySet()) {
                Object value = entry.getValue();
                if (this.isSuitableValue(modelValue, value)) continue;
                String messageText = Messages.getMessage((String)"INVALID_VALUE", (Object)MessageUtil.getLabel((FacesContext)faces, (UIComponent)this), value);
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, messageText, null);
                faces.addMessage(this.getClientId(faces), message);
                this.setValid(false);
                break;
            }
        }
        this.iterate(faces, this.decodeVisitor, argument);
        if (this.isImmediate()) {
            this.executeValidate(faces);
        }
        if (!this.isValid()) {
            faces.renderResponse();
        }
    }

    protected ExtendedDataModel createDataModel() {
        Map modelMap = null;
        if (this.submittedValueHolder != null) {
            modelMap = this.submittedValueHolder.dataMap;
        }
        if (modelMap != null) {
            OrderingListDataModel dataModel = new OrderingListDataModel();
            dataModel.setWrappedData((Object)modelMap);
            return dataModel;
        }
        DataModel dataModel = this.createDataModel(this.getValue());
        return new SequenceDataModel(dataModel);
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public abstract MethodBinding getValueChangeListener();

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    public abstract boolean isImmediate();

    public abstract boolean isRequired();

    public abstract boolean isValid();

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void setSubmittedString(Map submittedString, Set selection, Object activeItem) {
        this.submittedValueHolder = new SubmittedValue(submittedString, selection, activeItem);
    }

    public Object getSubmittedValue() {
        return this.submittedValueHolder;
    }

    public void setSubmittedValue(Object object) {
        this.submittedValueHolder = (SubmittedValue)object;
    }

    protected Object saveIterationState() {
        return this.valueHolder;
    }

    protected void restoreIterationState(Object object) {
        this.valueHolder = (ValueHolder)object;
    }

    public abstract void setImmediate(boolean var1);

    public abstract void setRequired(boolean var1);

    public abstract void setValid(boolean var1);

    public abstract void setValueChangeListener(MethodBinding var1);

    public abstract Converter getConverter();

    public abstract void setConverter(Converter var1);

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodBinding method;
        super.broadcast(event);
        if (event instanceof ValueChangeEvent && (method = this.getValueChangeListener()) != null) {
            FacesContext context = this.getFacesContext();
            method.invoke(context, new Object[]{event});
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid()) {
            return;
        }
        if (this.valueHolder != null) {
            this.updateModel(context, this.updateValueCommand);
            this.updateModel(context, this.updateSelectionCommand);
            this.updateModel(context, this.updateActiveItemCommand);
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object previousValue = this.getValue();
        Object newValue = null;
        try {
            if (previousValue == null) {
                previousValue = Collections.EMPTY_LIST;
            }
            try {
                final ArrayList list = new ArrayList(this.getRowCount());
                Object key = this.getRowKey();
                this.captureOrigValue(context);
                this.walk(context, new DataVisitor(){

                    public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
                        UIOrderingList.this.setRowKey(context, rowKey);
                        list.add(UIOrderingList.this.getRowData());
                    }
                }, null);
                this.setRowKey(key);
                this.restoreOrigValue(context);
                newValue = this.createContainer(list, previousValue);
            }
            catch (IOException e) {
                throw new ConverterException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (ConverterException ce) {
            SubmittedValue submittedValue = this.submittedValueHolder;
            this.addConversionErrorMessage(context, ce, submittedValue);
            this.setValid(false);
        }
        this.validateValue(context, newValue);
        if (this.isValid()) {
            this.setSelection(this.submittedValueHolder.selection);
            this.setActiveItem(this.submittedValueHolder.activeItem);
            this.setValue(newValue);
            if (this.compareValues(previousValue, newValue)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previousValue, newValue));
            }
            this.submittedValueHolder.setNull();
        }
    }

    protected void resetDataModel() {
        super.resetDataModel();
        if (this.submittedValueHolder != null) {
            this.submittedValueHolder.resetDataModel();
        }
    }

    public UIOrderingBaseComponent.ItemState getItemState() {
        if (this.submittedValueHolder != null && !this.submittedValueHolder.isNull()) {
            return new ModelItemState(this.submittedValueHolder.selection, this.submittedValueHolder.activeItem);
        }
        return new ModelItemState(this.getSelection(), this.getActiveItem());
    }

    public abstract String getControlsType();

    public abstract void setControlsType(String var1);

    public Set getSelection() {
        if (this.valueHolder != null && this.valueHolder.selection != null) {
            return this.valueHolder.selection;
        }
        ValueBinding vb = this.getValueBinding("selection");
        if (vb != null) {
            return (Set)vb.getValue(FacesContext.getCurrentInstance());
        }
        return null;
    }

    public void setSelection(Set selection) {
        this.createValueHolder();
        this.valueHolder.selection = selection;
        this.valueHolder.selectionSet = true;
    }

    public Object getActiveItem() {
        if (this.valueHolder != null && this.valueHolder.activeItem != null) {
            return this.valueHolder.activeItem;
        }
        ValueBinding vb = this.getValueBinding("activeItem");
        if (vb != null) {
            return vb.getValue(FacesContext.getCurrentInstance());
        }
        return null;
    }

    public void setActiveItem(Object activeItem) {
        this.createValueHolder();
        this.valueHolder.activeItem = activeItem;
        this.valueHolder.activeItemSet = true;
    }

    private void createValueHolder() {
        if (this.valueHolder == null) {
            this.valueHolder = new ValueHolder();
        }
    }

    public void setValue(Object value) {
        if (value instanceof ValueHolder) {
            this.valueHolder = (ValueHolder)value;
        } else {
            this.createValueHolder();
            this.valueHolder.value = value;
            this.setLocalValueSet(true);
        }
    }

    public Object getLocalValue() {
        return this.valueHolder;
    }

    public Object getValue() {
        if (this.valueHolder != null && this.valueHolder.value != null) {
            return this.valueHolder.value;
        }
        ValueBinding ve = this.getValueBinding("value");
        if (ve != null) {
            return ve.getValue(this.getFacesContext());
        }
        return null;
    }

    public Object saveState(FacesContext faces) {
        Object[] state = new Object[2];
        state[0] = super.saveState(faces);
        if (this.valueHolder != null) {
            state[1] = this.valueHolder.saveState(faces, this);
        }
        return state;
    }

    public void restoreState(FacesContext faces, Object object) {
        Object[] state = (Object[])object;
        super.restoreState(faces, state[0]);
        if (state[1] != null) {
            this.valueHolder = new ValueHolder();
            this.valueHolder.restoreState(faces, this, state[1]);
        }
    }

    public static final class ValueHolder
    implements Serializable {
        private static final long serialVersionUID = -4216115242421460529L;
        private Object value;
        private Set selection;
        private boolean selectionSet;
        private Object activeItem;
        private boolean activeItemSet;

        public boolean isTransient() {
            return this.value == null && (this.selection == null || this.selection.isEmpty()) && !this.selectionSet && this.activeItem == null && !this.activeItemSet;
        }

        public void restoreState(FacesContext context, UIOrderingList list, Object _state) {
            Object[] state = (Object[])_state;
            this.value = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[0]);
            this.selection = (Set)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[1]);
            this.selectionSet = Boolean.TRUE.equals(state[2]);
            this.activeItem = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[3]);
            this.activeItemSet = Boolean.TRUE.equals(state[4]);
        }

        public Object saveState(FacesContext context, UIOrderingList list) {
            Object[] state = new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.value), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.selection), this.selectionSet ? Boolean.TRUE : Boolean.FALSE, UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.activeItem), this.activeItemSet ? Boolean.TRUE : Boolean.FALSE};
            return state;
        }

        public void setTransient(boolean newTransientValue) {
            if (newTransientValue) {
                throw new IllegalArgumentException();
            }
        }
    }

    private final class ModelItemState
    implements UIOrderingBaseComponent.ItemState {
        private Collection selectedItems;
        private Object activeItem;

        public ModelItemState(Collection selectedItems, Object activeItem) {
            this.selectedItems = selectedItems;
            this.activeItem = activeItem;
        }

        public boolean isSelected() {
            return this.selectedItems != null && this.selectedItems.contains(UIOrderingList.this.getRowData());
        }

        public boolean isActive() {
            return this.activeItem != null && this.activeItem.equals(UIOrderingList.this.getRowData());
        }
    }

    protected static final class SubmittedValue
    implements Serializable {
        private static final long serialVersionUID = 5860506816451180551L;
        private Map dataMap;
        private Set selection;
        private Object activeItem;
        private boolean _null = false;

        public SubmittedValue(Map dataMap, Set selection, Object activeItem) {
            this.dataMap = dataMap;
            this.selection = selection;
            this.activeItem = activeItem;
        }

        public void setNull() {
            this._null = true;
        }

        public boolean isNull() {
            return this._null;
        }

        public void resetDataModel() {
            if (this._null) {
                this.dataMap = null;
            }
        }
    }
}

