/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIExtendedDataTable;
import org.richfaces.model.Ordering;

class ColumnGroupingState
implements Serializable {
    private static final long serialVersionUID = -3923409650272094713L;
    private static final String SEP = ";";
    private static final Boolean DEF = Boolean.TRUE;
    private String columnId;
    private List<Boolean> groupExpanded;
    private Ordering ordering;

    private ColumnGroupingState() {
    }

    static ColumnGroupingState getColumnGropingState(UIExtendedDataTable extendedDataTable, String val) {
        ColumnGroupingState groupingState = new ColumnGroupingState();
        groupingState.init(extendedDataTable, val);
        return groupingState;
    }

    private void init(UIExtendedDataTable extendedDataTable, String val) {
        this.columnId = null;
        this.ordering = Ordering.UNSORTED;
        this.groupExpanded = new ArrayList<Boolean>();
        if (val == null || val.length() == 0) {
            return;
        }
        List<String> tmp = Arrays.asList(val.split(SEP));
        if (!tmp.isEmpty()) {
            this.columnId = tmp.get(0);
            this.ordering = Ordering.valueOf((String)tmp.get(1));
            if (this.ordering == null) {
                this.ordering = Ordering.UNSORTED;
            }
        }
        Iterator<UIColumn> columns = extendedDataTable.getChildColumns();
        while (columns.hasNext()) {
            UIColumn child = columns.next();
            if (!this.columnId.equalsIgnoreCase(child.getId())) continue;
            child.setSortOrder(this.ordering);
            break;
        }
    }

    public String toString() {
        if (this.columnId == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.columnId).append(SEP);
        builder.append(this.ordering).append(SEP);
        return builder.toString();
    }

    String getGroupingColumnId() {
        return this.columnId;
    }

    boolean isGroupingOn() {
        return this.columnId != null;
    }

    void groupBy(String colId, Ordering ordering) {
        this.columnId = colId;
        this.ordering = ordering;
        this.resetGroupVisibilityState();
    }

    void resetGroupVisibilityState() {
        this.groupExpanded.clear();
    }

    void disableGrouping() {
        this.columnId = null;
        this.ordering = Ordering.UNSORTED;
        this.resetGroupVisibilityState();
    }

    void toggleGroup(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index value :" + index);
        }
        if (index >= this.groupExpanded.size()) {
            int count = index - this.groupExpanded.size() + 1;
            for (int i = 0; i < count; ++i) {
                this.groupExpanded.add(DEF);
            }
        }
        this.groupExpanded.add(index, this.groupExpanded.remove(index) == false);
    }

    boolean groupIsExpanded(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index value :" + index);
        }
        if (index >= this.groupExpanded.size()) {
            return DEF;
        }
        return this.groupExpanded.get(index);
    }
}

