/**
 * 
 */
package org.richfaces.taglib;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.servlet.jsp.JspException;

import org.richfaces.validator.BeanValidator;
import org.richfaces.validator.FacesBeanValidator;

public class BeanValidatorTag extends javax.faces.webapp.ValidatorELTag {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5230299574915210593L;
	// Fields

	/*
	 * summary Summary message for a validation errors.
	 */
	private ValueExpression _summary;

    /**
     * <p>The {@link javax.el.ValueExpression} that evaluates to an object that
     * implements {@link BeanValidator}.</p>
     */
    private ValueExpression binding = null;

    /**
	 * Summary message for a validation errors. Setter for summary
	 * 
	 * @param summary
	 *            - new value
	 */
	public void setSummary(ValueExpression __summary) {
		this._summary = __summary;
	}

	/**
     * <p>Set the expression that will be used to create a
     * {@link javax.el.ValueExpression} that references a backing bean property
     * of the {@link BeanValidator} instance to be created.</p>
     *
     * @param binding The new expression
	 */
	public void setBinding(ValueExpression binding) {
		this.binding = binding;
	}
	
	protected Validator createValidator() throws JspException {
		ValueExpression ve = this.binding;
		
		FacesContext facesContext = FacesContext.getCurrentInstance();
		
		FacesBeanValidator validator = null;
		
		try {
			ELContext elContext = facesContext.getELContext();
			if (ve != null) {
				validator = (FacesBeanValidator) ve.getValue(elContext);
			}

			if (validator == null) {
				validator = (FacesBeanValidator) FacesContext
					.getCurrentInstance().getApplication().createValidator(
					"org.richfaces.BeanValidator");

				if (ve != null && validator != null) {
					ve.setValue(elContext, validator);
				}
			}
		} catch (Exception e) {
			throw new FacesException(e);
		}
		
		_setProperties(validator);
		
		return validator;
	}

	// Support method to wire in properties
	private void _setProperties(FacesBeanValidator validator)
			throws JspException {
		if (_summary != null) {
			if (_summary instanceof ValueExpression) {
				validator.setSummary(_summary);
			}
		}
	}
}
