package org.richfaces.renderkit;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.richfaces.component.UIJQuery;
import org.richfaces.component.util.HtmlUtil;


public class JQueryRendererBase extends HeaderResourcesRendererBase {

		protected Class getComponentClass() {
			return UIJQuery.class;
		}


	
	protected void checkValidity(String clientId, String name, String timing, String query) {
		
		if (  	! "onJScall".equals(timing) &&
				! "onload".equals(timing) &&
				! "immediate".equals(timing) ) {
			throw new FacesException(
			"The timing attribute of the jQuery component (id='"+clientId+"') has an invalid value:'"+ timing +
			"'. It may have only the following values: 'immediate', 'onload', 'onJScall'");
		}
		
		if ( name == null ) {
			throw new FacesException(
					"The name attribute of the jQuery component (id='"+clientId+"') might not be null" );
				
		}

		if ( "".equals(name.trim()) && "onJScall".equals(timing) ) {
			throw new FacesException(
					"The name attribute of the jQuery component (id='"+clientId+"') must be specified when timing attribute equals to 'onJScall'" );
		}

		if ( "".equals(query.trim()) || query==null ) {
			throw new FacesException(
					"The query attribute of the jQuery component (id='"+clientId+"') must be specified" );
		}
		
	}
	protected String replaceClientIds(FacesContext context, UIComponent component, String selector) {
		return HtmlUtil.expandIdSelector(selector, component, context);
	}
	
}
