package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIRecursiveTreeNodesAdaptor;

public class HtmlRecursiveTreeNodesAdaptor extends UIRecursiveTreeNodesAdaptor{

public final static  String COMPONENT_FAMILY = "org.richfaces.RecursiveTreeNodesAdaptor";

public final static  String COMPONENT_TYPE = "org.richfaces.RecursiveTreeNodesAdaptor";

/*
* This boolean expression is used to define which elements of both collections are processed. Default value is "true".
*/
private  boolean _included = true;

private  boolean _includedSet = false;

/*
* This boolean expression is used to define which elements are processed. Default value is "true".
*/
private  boolean _includedNode = true;

private  boolean _includedNodeSet = false;

/*
* This boolean expression is used to define which elements are processed applying to "roots" collection. Default value is "true".
*/
private  boolean _includedRoot = true;

private  boolean _includedRootSet = false;

/*
* Defines collection to use at the other (non-top) levels of iteration
*/
private  Object _nodes = null;

/*
* Defines collection to use at the top of iteration
*/
private  Object _roots = null;

/*
* A request-scope attribute via which the data object for the current collection element will be used when iterating
*/
private  String _var = null;


public HtmlRecursiveTreeNodesAdaptor(){

}

public boolean isIncluded(){
	if (this._includedSet) {
	    return (this._included);
	}
	ValueExpression ve = getValueExpression("included");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._included);
	    }
	    
	    return value;
	} else {
	    return (this._included);
	}

}

public void setIncluded(boolean _included){
this._included = _included;
this._includedSet = true;
}

public boolean isIncludedNode(){
	if (this._includedNodeSet) {
	    return (this._includedNode);
	}
	ValueExpression ve = getValueExpression("includedNode");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._includedNode);
	    }
	    
	    return value;
	} else {
	    return (this._includedNode);
	}

}

public void setIncludedNode(boolean _includedNode){
this._includedNode = _includedNode;
this._includedNodeSet = true;
}

public boolean isIncludedRoot(){
	if (this._includedRootSet) {
	    return (this._includedRoot);
	}
	ValueExpression ve = getValueExpression("includedRoot");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._includedRoot);
	    }
	    
	    return value;
	} else {
	    return (this._includedRoot);
	}

}

public void setIncludedRoot(boolean _includedRoot){
this._includedRoot = _includedRoot;
this._includedRootSet = true;
}

public Object getNodes(){
	if (this._nodes != null) {
		return this._nodes;
	}
	ValueExpression ve = getValueExpression("nodes");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setNodes(Object _nodes){
this._nodes = _nodes;
}

public Object getRoots(){
	if (this._roots != null) {
		return this._roots;
	}
	ValueExpression ve = getValueExpression("roots");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRoots(Object _roots){
this._roots = _roots;
}

public String getVar(){
	if (this._var != null) {
		return this._var;
	}
	ValueExpression ve = getValueExpression("var");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setVar(String _var){
this._var = _var;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[10];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_included);
state[2] = Boolean.valueOf(_includedSet);
state[3] = Boolean.valueOf(_includedNode);
state[4] = Boolean.valueOf(_includedNodeSet);
state[5] = Boolean.valueOf(_includedRoot);
state[6] = Boolean.valueOf(_includedRootSet);
state[7] = saveAttachedState(context, _nodes);
state[8] = saveAttachedState(context, _roots);
state[9] = _var;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_included = ((Boolean)states[1]).booleanValue();
		_includedSet = ((Boolean)states[2]).booleanValue();
		_includedNode = ((Boolean)states[3]).booleanValue();
		_includedNodeSet = ((Boolean)states[4]).booleanValue();
		_includedRoot = ((Boolean)states[5]).booleanValue();
		_includedRootSet = ((Boolean)states[6]).booleanValue();
		_nodes = (Object)restoreAttachedState(context, states[7]);
		_roots = (Object)restoreAttachedState(context, states[8]);
		_var = (String)states[9];;
	
}

}
