package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIPanelMenu;

public class HtmlPanelMenu extends UIPanelMenu{

public final static  String COMPONENT_FAMILY = "org.richfaces.PanelMenu";

public final static  String COMPONENT_TYPE = "org.richfaces.PanelMenu";

/*
* If true sets state of the item to disabled state. Default value is "false".
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* Space-separated list of CSS style class(es) that are be applied to disabled group of this component
*/
private  String _disabledGroupClass = null;

/*
* CSS style(s) is/are to be applied to disabled group when this component is rendered
*/
private  String _disabledGroupStyle = null;

/*
* Space-separated list of CSS style class(es) that are be applied to disabled item of this component
*/
private  String _disabledItemClass = null;

/*
* CSS style(s) is/are to be applied to disabled item when this component is rendered.
*/
private  String _disabledItemStyle = null;

/*
* Defines the event on the representation element that triggers the
				submenu's expand/collapse. Default value is "onclick".
*/
private  String _event = null;

/*
* Set the submission mode for all panel menu groups after expand/collapse
				except ones where this attribute redefined. Possible values are "ajax", "server", "none". 
				Default value is "none".
*/
private  String _expandMode = null;

/*
* Whether only one panel menu node on top level can be opened at a time. If
				the value of this attribute is true, the previously opened node on the top level is
				closed. If the value is false, the node is left opened. Default value is "false".
*/
private  boolean _expandSingle = false;

private  boolean _expandSingleSet = false;

/*
* null
*/
private  boolean _firstExpandedEncoded = false;

private  boolean _firstExpandedEncodedSet = false;

/*
* Space-separated list of CSS style class(es) that are be applied to group of this component
*/
private  String _groupClass = null;

/*
* CSS style(s) is/are to be applied to group when this component is rendered
*/
private  String _groupStyle = null;

/*
* Space-separated list of CSS style class(es) that are be applied to hovered group of this component
*/
private  String _hoveredGroupClass = null;

/*
* CSS style(s) is/are to be applied to hovered group when this component is rendered
*/
private  String _hoveredGroupStyle = null;

/*
* Space-separated list of CSS style class(es) that are be applied to hovered item of this component
*/
private  String _hoveredItemClass = null;

/*
* CSS style(s) is/are to be applied to hovered item when this component is rendered
*/
private  String _hoveredItemStyle = null;

/*
* Path to the icon to be displayed for the collapsed Group state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconCollapsedGroup = null;

/*
* Path to the icon to be displayed for the collapsed top group state.\
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconCollapsedTopGroup = null;

/*
* Path to the icon to be displayed for the disabled group state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconDisabledGroup = null;

/*
* Path to the icon to be displayed for the disabled item state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconDisabledItem = null;

/*
* Path to the icon to be displayed for the expanded Group state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconExpandedGroup = null;

/*
* Path to the icon to be displayed for the expanded top group state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconExpandedTopGroup = null;

/*
* Position of the icon for the group icon. Possible values are "left","right","none". Default value is "left".
*/
private  String _iconGroupPosition = null;

/*
* Position of the icon for the top group icon. Possible values are "left","right","none". Default value is "left".
*/
private  String _iconGroupTopPosition = null;

/*
* Path to the icon to be displayed for the enabled item state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconItem = null;

/*
* Position of the icon for the item icon. Possible values are "left","right","none". Default value is "left".
*/
private  String _iconItemPosition = null;

/*
* Position of the icon for the top item icon.
				Possible values are "left","right","none". Default value is "left".
*/
private  String _iconItemTopPosition = null;

/*
* Path to the icon to be displayed for the disabled top Group state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconTopDisableGroup = null;

/*
* Path to the icon to be displayed for the disabled top item state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconTopDisabledItem = null;

/*
* Path to the icon to be displayed for the enabled top item state.
				You can also use predefined icons, setting the attribute to one of these possible values: "triangle", "triangleUp", "triangleDown", "disc", "chevron", "chevronUp", "chevronDown", "grid".
				Default value is "grid".
*/
private  String _iconTopItem = null;

/*
* Space-separated list of CSS style class(es) that are be applied to item of this component
*/
private  String _itemClass = null;

/*
* CSS style(s) is/are to be applied to item when this component is rendered.
*/
private  String _itemStyle = null;

/*
* A localized user presentable name for this component.
*/
private  String _label = null;

/*
* Set the submission mode for all panel menu items on the panel menu except
				ones where this attribute redefined. Possible values are "ajax", "server", "none". Default value is "server".
*/
private  String _mode = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: script expression; some group was closed
*/
private  String _ongroupcollapse = null;

/*
* HTML: script expression; some group was activated
*/
private  String _ongroupexpand = null;

/*
* HTML: script expression; some item was hovered
*/
private  String _onitemhover = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: script expression; a pointer was moved within.
*/
private  String _onmousemove = null;

/*
* HTML: script expression; a pointer was moved away.
*/
private  String _onmouseout = null;

/*
* HTML: script expression; a pointer was moved onto.
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* contain the name or the clientId of any of the item or group, the child
				defined in this attribute should be highlighted on PanelMenu rendering
*/
private  String _selectedChild = null;

/*
* The CSS style for the panel menu.
*/
private  String _style = null;

/*
* The CSS class for the panel menu.
*/
private  String _styleClass = null;

/*
* Space-separated list of CSS style class(es) that are be applied to top group of this component
*/
private  String _topGroupClass = null;

/*
* CSS style(s) is/are to be applied to top group when this component is rendered
*/
private  String _topGroupStyle = null;

/*
* Space-separated list of CSS style class(es) that are be applied to top item of this component
*/
private  String _topItemClass = null;

/*
* CSS style(s) is/are to be applied to top item when this component is rendered
*/
private  String _topItemStyle = null;

/*
* Set minimal width for the menu. Default value is "100%".
*/
private  String _width = null;


public HtmlPanelMenu(){
setRendererType("org.richfaces.PanelMenuRenderer");
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public String getDisabledGroupClass(){
	if (this._disabledGroupClass != null) {
		return this._disabledGroupClass;
	}
	ValueExpression ve = getValueExpression("disabledGroupClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "dr-pmenu-disabled-element rich-pmenu-disabled-element";
	

}

public void setDisabledGroupClass(String _disabledGroupClass){
this._disabledGroupClass = _disabledGroupClass;
}

public String getDisabledGroupStyle(){
	if (this._disabledGroupStyle != null) {
		return this._disabledGroupStyle;
	}
	ValueExpression ve = getValueExpression("disabledGroupStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDisabledGroupStyle(String _disabledGroupStyle){
this._disabledGroupStyle = _disabledGroupStyle;
}

public String getDisabledItemClass(){
	if (this._disabledItemClass != null) {
		return this._disabledItemClass;
	}
	ValueExpression ve = getValueExpression("disabledItemClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "dr-pmenu-disabled-element rich-pmenu-disabled-element";
	

}

public void setDisabledItemClass(String _disabledItemClass){
this._disabledItemClass = _disabledItemClass;
}

public String getDisabledItemStyle(){
	if (this._disabledItemStyle != null) {
		return this._disabledItemStyle;
	}
	ValueExpression ve = getValueExpression("disabledItemStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDisabledItemStyle(String _disabledItemStyle){
this._disabledItemStyle = _disabledItemStyle;
}

public String getEvent(){
	if (this._event != null) {
		return this._event;
	}
	ValueExpression ve = getValueExpression("event");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "onclick";
	

}

public void setEvent(String _event){
this._event = _event;
}

public String getExpandMode(){
	if (this._expandMode != null) {
		return this._expandMode;
	}
	ValueExpression ve = getValueExpression("expandMode");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "none";
	

}

public void setExpandMode(String _expandMode){
this._expandMode = _expandMode;
}

public boolean isExpandSingle(){
	if (this._expandSingleSet) {
	    return (this._expandSingle);
	}
	ValueExpression ve = getValueExpression("expandSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._expandSingle);
	    }
	    
	    return value;
	} else {
	    return (this._expandSingle);
	}

}

public void setExpandSingle(boolean _expandSingle){
this._expandSingle = _expandSingle;
this._expandSingleSet = true;
}

public boolean isFirstExpandedEncoded(){
	if (this._firstExpandedEncodedSet) {
	    return (this._firstExpandedEncoded);
	}
	ValueExpression ve = getValueExpression("firstExpandedEncoded");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._firstExpandedEncoded);
	    }
	    
	    return value;
	} else {
	    return (this._firstExpandedEncoded);
	}

}

public void setFirstExpandedEncoded(boolean _firstExpandedEncoded){
this._firstExpandedEncoded = _firstExpandedEncoded;
this._firstExpandedEncodedSet = true;
}

public String getGroupClass(){
	if (this._groupClass != null) {
		return this._groupClass;
	}
	ValueExpression ve = getValueExpression("groupClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setGroupClass(String _groupClass){
this._groupClass = _groupClass;
}

public String getGroupStyle(){
	if (this._groupStyle != null) {
		return this._groupStyle;
	}
	ValueExpression ve = getValueExpression("groupStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setGroupStyle(String _groupStyle){
this._groupStyle = _groupStyle;
}

public String getHoveredGroupClass(){
	if (this._hoveredGroupClass != null) {
		return this._hoveredGroupClass;
	}
	ValueExpression ve = getValueExpression("hoveredGroupClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "dr-pmenu-hovered-element rich-pmenu-hovered-element";
	

}

public void setHoveredGroupClass(String _hoveredGroupClass){
this._hoveredGroupClass = _hoveredGroupClass;
}

public String getHoveredGroupStyle(){
	if (this._hoveredGroupStyle != null) {
		return this._hoveredGroupStyle;
	}
	ValueExpression ve = getValueExpression("hoveredGroupStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setHoveredGroupStyle(String _hoveredGroupStyle){
this._hoveredGroupStyle = _hoveredGroupStyle;
}

public String getHoveredItemClass(){
	if (this._hoveredItemClass != null) {
		return this._hoveredItemClass;
	}
	ValueExpression ve = getValueExpression("hoveredItemClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "dr-pmenu-hovered-element rich-pmenu-hovered-element";
	

}

public void setHoveredItemClass(String _hoveredItemClass){
this._hoveredItemClass = _hoveredItemClass;
}

public String getHoveredItemStyle(){
	if (this._hoveredItemStyle != null) {
		return this._hoveredItemStyle;
	}
	ValueExpression ve = getValueExpression("hoveredItemStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setHoveredItemStyle(String _hoveredItemStyle){
this._hoveredItemStyle = _hoveredItemStyle;
}

public String getIconCollapsedGroup(){
	if (this._iconCollapsedGroup != null) {
		return this._iconCollapsedGroup;
	}
	ValueExpression ve = getValueExpression("iconCollapsedGroup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconCollapsedGroup(String _iconCollapsedGroup){
this._iconCollapsedGroup = _iconCollapsedGroup;
}

public String getIconCollapsedTopGroup(){
	if (this._iconCollapsedTopGroup != null) {
		return this._iconCollapsedTopGroup;
	}
	ValueExpression ve = getValueExpression("iconCollapsedTopGroup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconCollapsedTopGroup(String _iconCollapsedTopGroup){
this._iconCollapsedTopGroup = _iconCollapsedTopGroup;
}

public String getIconDisabledGroup(){
	if (this._iconDisabledGroup != null) {
		return this._iconDisabledGroup;
	}
	ValueExpression ve = getValueExpression("iconDisabledGroup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconDisabledGroup(String _iconDisabledGroup){
this._iconDisabledGroup = _iconDisabledGroup;
}

public String getIconDisabledItem(){
	if (this._iconDisabledItem != null) {
		return this._iconDisabledItem;
	}
	ValueExpression ve = getValueExpression("iconDisabledItem");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "grid";
	

}

public void setIconDisabledItem(String _iconDisabledItem){
this._iconDisabledItem = _iconDisabledItem;
}

public String getIconExpandedGroup(){
	if (this._iconExpandedGroup != null) {
		return this._iconExpandedGroup;
	}
	ValueExpression ve = getValueExpression("iconExpandedGroup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconExpandedGroup(String _iconExpandedGroup){
this._iconExpandedGroup = _iconExpandedGroup;
}

public String getIconExpandedTopGroup(){
	if (this._iconExpandedTopGroup != null) {
		return this._iconExpandedTopGroup;
	}
	ValueExpression ve = getValueExpression("iconExpandedTopGroup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconExpandedTopGroup(String _iconExpandedTopGroup){
this._iconExpandedTopGroup = _iconExpandedTopGroup;
}

public String getIconGroupPosition(){
	if (this._iconGroupPosition != null) {
		return this._iconGroupPosition;
	}
	ValueExpression ve = getValueExpression("iconGroupPosition");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "left";
	

}

public void setIconGroupPosition(String _iconGroupPosition){
this._iconGroupPosition = _iconGroupPosition;
}

public String getIconGroupTopPosition(){
	if (this._iconGroupTopPosition != null) {
		return this._iconGroupTopPosition;
	}
	ValueExpression ve = getValueExpression("iconGroupTopPosition");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "left";
	

}

public void setIconGroupTopPosition(String _iconGroupTopPosition){
this._iconGroupTopPosition = _iconGroupTopPosition;
}

public String getIconItem(){
	if (this._iconItem != null) {
		return this._iconItem;
	}
	ValueExpression ve = getValueExpression("iconItem");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "grid";
	

}

public void setIconItem(String _iconItem){
this._iconItem = _iconItem;
}

public String getIconItemPosition(){
	if (this._iconItemPosition != null) {
		return this._iconItemPosition;
	}
	ValueExpression ve = getValueExpression("iconItemPosition");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "left";
	

}

public void setIconItemPosition(String _iconItemPosition){
this._iconItemPosition = _iconItemPosition;
}

public String getIconItemTopPosition(){
	if (this._iconItemTopPosition != null) {
		return this._iconItemTopPosition;
	}
	ValueExpression ve = getValueExpression("iconItemTopPosition");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "left";
	

}

public void setIconItemTopPosition(String _iconItemTopPosition){
this._iconItemTopPosition = _iconItemTopPosition;
}

public String getIconTopDisableGroup(){
	if (this._iconTopDisableGroup != null) {
		return this._iconTopDisableGroup;
	}
	ValueExpression ve = getValueExpression("iconTopDisableGroup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconTopDisableGroup(String _iconTopDisableGroup){
this._iconTopDisableGroup = _iconTopDisableGroup;
}

public String getIconTopDisabledItem(){
	if (this._iconTopDisabledItem != null) {
		return this._iconTopDisabledItem;
	}
	ValueExpression ve = getValueExpression("iconTopDisabledItem");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setIconTopDisabledItem(String _iconTopDisabledItem){
this._iconTopDisabledItem = _iconTopDisabledItem;
}

public String getIconTopItem(){
	if (this._iconTopItem != null) {
		return this._iconTopItem;
	}
	ValueExpression ve = getValueExpression("iconTopItem");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "grid";
	

}

public void setIconTopItem(String _iconTopItem){
this._iconTopItem = _iconTopItem;
}

public String getItemClass(){
	if (this._itemClass != null) {
		return this._itemClass;
	}
	ValueExpression ve = getValueExpression("itemClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setItemClass(String _itemClass){
this._itemClass = _itemClass;
}

public String getItemStyle(){
	if (this._itemStyle != null) {
		return this._itemStyle;
	}
	ValueExpression ve = getValueExpression("itemStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setItemStyle(String _itemStyle){
this._itemStyle = _itemStyle;
}

public String getLabel(){
	if (this._label != null) {
		return this._label;
	}
	ValueExpression ve = getValueExpression("label");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLabel(String _label){
this._label = _label;
}

public String getMode(){
	if (this._mode != null) {
		return this._mode;
	}
	ValueExpression ve = getValueExpression("mode");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "server";
	

}

public void setMode(String _mode){
this._mode = _mode;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOngroupcollapse(){
	if (this._ongroupcollapse != null) {
		return this._ongroupcollapse;
	}
	ValueExpression ve = getValueExpression("ongroupcollapse");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOngroupcollapse(String _ongroupcollapse){
this._ongroupcollapse = _ongroupcollapse;
}

public String getOngroupexpand(){
	if (this._ongroupexpand != null) {
		return this._ongroupexpand;
	}
	ValueExpression ve = getValueExpression("ongroupexpand");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOngroupexpand(String _ongroupexpand){
this._ongroupexpand = _ongroupexpand;
}

public String getOnitemhover(){
	if (this._onitemhover != null) {
		return this._onitemhover;
	}
	ValueExpression ve = getValueExpression("onitemhover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnitemhover(String _onitemhover){
this._onitemhover = _onitemhover;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getSelectedChild(){
	if (this._selectedChild != null) {
		return this._selectedChild;
	}
	ValueExpression ve = getValueExpression("selectedChild");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setSelectedChild(String _selectedChild){
this._selectedChild = _selectedChild;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTopGroupClass(){
	if (this._topGroupClass != null) {
		return this._topGroupClass;
	}
	ValueExpression ve = getValueExpression("topGroupClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setTopGroupClass(String _topGroupClass){
this._topGroupClass = _topGroupClass;
}

public String getTopGroupStyle(){
	if (this._topGroupStyle != null) {
		return this._topGroupStyle;
	}
	ValueExpression ve = getValueExpression("topGroupStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setTopGroupStyle(String _topGroupStyle){
this._topGroupStyle = _topGroupStyle;
}

public String getTopItemClass(){
	if (this._topItemClass != null) {
		return this._topItemClass;
	}
	ValueExpression ve = getValueExpression("topItemClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setTopItemClass(String _topItemClass){
this._topItemClass = _topItemClass;
}

public String getTopItemStyle(){
	if (this._topItemStyle != null) {
		return this._topItemStyle;
	}
	ValueExpression ve = getValueExpression("topItemStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setTopItemStyle(String _topItemStyle){
this._topItemStyle = _topItemStyle;
}

public String getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "100%";
	

}

public void setWidth(String _width){
this._width = _width;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[58];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_disabled);
state[2] = Boolean.valueOf(_disabledSet);
state[3] = _disabledGroupClass;
state[4] = _disabledGroupStyle;
state[5] = _disabledItemClass;
state[6] = _disabledItemStyle;
state[7] = _event;
state[8] = _expandMode;
state[9] = Boolean.valueOf(_expandSingle);
state[10] = Boolean.valueOf(_expandSingleSet);
state[11] = Boolean.valueOf(_firstExpandedEncoded);
state[12] = Boolean.valueOf(_firstExpandedEncodedSet);
state[13] = _groupClass;
state[14] = _groupStyle;
state[15] = _hoveredGroupClass;
state[16] = _hoveredGroupStyle;
state[17] = _hoveredItemClass;
state[18] = _hoveredItemStyle;
state[19] = _iconCollapsedGroup;
state[20] = _iconCollapsedTopGroup;
state[21] = _iconDisabledGroup;
state[22] = _iconDisabledItem;
state[23] = _iconExpandedGroup;
state[24] = _iconExpandedTopGroup;
state[25] = _iconGroupPosition;
state[26] = _iconGroupTopPosition;
state[27] = _iconItem;
state[28] = _iconItemPosition;
state[29] = _iconItemTopPosition;
state[30] = _iconTopDisableGroup;
state[31] = _iconTopDisabledItem;
state[32] = _iconTopItem;
state[33] = _itemClass;
state[34] = _itemStyle;
state[35] = _label;
state[36] = _mode;
state[37] = _onclick;
state[38] = _ondblclick;
state[39] = _ongroupcollapse;
state[40] = _ongroupexpand;
state[41] = _onitemhover;
state[42] = _onkeydown;
state[43] = _onkeypress;
state[44] = _onkeyup;
state[45] = _onmousedown;
state[46] = _onmousemove;
state[47] = _onmouseout;
state[48] = _onmouseover;
state[49] = _onmouseup;
state[50] = _selectedChild;
state[51] = _style;
state[52] = _styleClass;
state[53] = _topGroupClass;
state[54] = _topGroupStyle;
state[55] = _topItemClass;
state[56] = _topItemStyle;
state[57] = _width;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_disabled = ((Boolean)states[1]).booleanValue();
		_disabledSet = ((Boolean)states[2]).booleanValue();
		_disabledGroupClass = (String)states[3];;
		_disabledGroupStyle = (String)states[4];;
		_disabledItemClass = (String)states[5];;
		_disabledItemStyle = (String)states[6];;
		_event = (String)states[7];;
		_expandMode = (String)states[8];;
		_expandSingle = ((Boolean)states[9]).booleanValue();
		_expandSingleSet = ((Boolean)states[10]).booleanValue();
		_firstExpandedEncoded = ((Boolean)states[11]).booleanValue();
		_firstExpandedEncodedSet = ((Boolean)states[12]).booleanValue();
		_groupClass = (String)states[13];;
		_groupStyle = (String)states[14];;
		_hoveredGroupClass = (String)states[15];;
		_hoveredGroupStyle = (String)states[16];;
		_hoveredItemClass = (String)states[17];;
		_hoveredItemStyle = (String)states[18];;
		_iconCollapsedGroup = (String)states[19];;
		_iconCollapsedTopGroup = (String)states[20];;
		_iconDisabledGroup = (String)states[21];;
		_iconDisabledItem = (String)states[22];;
		_iconExpandedGroup = (String)states[23];;
		_iconExpandedTopGroup = (String)states[24];;
		_iconGroupPosition = (String)states[25];;
		_iconGroupTopPosition = (String)states[26];;
		_iconItem = (String)states[27];;
		_iconItemPosition = (String)states[28];;
		_iconItemTopPosition = (String)states[29];;
		_iconTopDisableGroup = (String)states[30];;
		_iconTopDisabledItem = (String)states[31];;
		_iconTopItem = (String)states[32];;
		_itemClass = (String)states[33];;
		_itemStyle = (String)states[34];;
		_label = (String)states[35];;
		_mode = (String)states[36];;
		_onclick = (String)states[37];;
		_ondblclick = (String)states[38];;
		_ongroupcollapse = (String)states[39];;
		_ongroupexpand = (String)states[40];;
		_onitemhover = (String)states[41];;
		_onkeydown = (String)states[42];;
		_onkeypress = (String)states[43];;
		_onkeyup = (String)states[44];;
		_onmousedown = (String)states[45];;
		_onmousemove = (String)states[46];;
		_onmouseout = (String)states[47];;
		_onmouseover = (String)states[48];;
		_onmouseup = (String)states[49];;
		_selectedChild = (String)states[50];;
		_style = (String)states[51];;
		_styleClass = (String)states[52];;
		_topGroupClass = (String)states[53];;
		_topGroupStyle = (String)states[54];;
		_topItemClass = (String)states[55];;
		_topItemStyle = (String)states[56];;
		_width = (String)states[57];;
	
}

}
