/**
 * 
 */
package org.richfaces.component;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;

import org.ajax4jsf.component.AjaxOutput;

/**
 * @author Anton Belevich
 *
 */
public abstract class UIRichMessages extends UIMessages implements AjaxOutput{

	private String forVal = null;
	private boolean isPassed = true;
		
	 /**
     * <p>Return the client identifier of the component for which
     * this component represents associated message(s) (if any).</p>
     */
    public String getFor() {

	if (this.forVal != null) {
	    return (this.forVal);
	}
	ValueExpression ve = getValueExpression("for");
	if (ve != null) {
	    try {
		return ((String) ve.getValue(getFacesContext().getELContext()));
	    }
	    catch (ELException e) {
		throw new FacesException(e);
	    }
	} else {
	    return (null);
	}

    }


    /**
     * <p>Set the client identifier of the component for which this
     * component represents associated message(s) (if any).  This
     * property must be set before the message is displayed.</p>
     *
     * @param newFor The new client id
     */
    public void setFor(String newFor) {

	forVal = newFor;

    }
    
	public boolean isPassed(){
		return isPassed;
	}
	
	public boolean isAjaxRendered() {
		return true;
	}

	public void setAjaxRendered(boolean ajaxRendered){
		if(!ajaxRendered){
			new IllegalArgumentException();
		}	
	}
	
	public void decode(FacesContext context){
//		isPassed = true;
		super.decode(context);
	}

	public abstract String getLevel();

	public abstract void setLevel(String level);

	private Object[] values;

	public Object saveState(FacesContext context) {

		if (values == null) {
			values = new Object[2];
		}

		values[0] = super.saveState(context);
		values[1] = this.forVal;
		return (values);

	}

	public void restoreState(FacesContext context, Object state) {

		values = (Object[]) state;
		super.restoreState(context, values[0]);
		forVal = (String) values[1];
	}

}
