package org.richfaces.taglib;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.ajax4jsf.webapp.taglib.HtmlComponentTagBase;
import org.richfaces.component.UIPanelMenuGroup;

/**
 * @author Anton Belevich
 *
 */
public abstract class PanelMenuGroupTagBase extends HtmlComponentTagBase{
	
	private boolean _setExpandedSet = false;
	private ValueExpression _value = null;
	
	private void logValueDeprecation(ValueExpression value) {
		FacesContext facesContext = getFacesContext();
		facesContext.getExternalContext().log("expanded attribute has been already set for component with id: " + this.getId() + 
				"[" + value.getExpressionString() + "]. value attribute is deprecated and thus has been dropped!");
	}
	
	
	public void setExpanded(ValueExpression value){
		
		if (!_setExpandedSet && _value != null) {
			logValueDeprecation(value);
		}
		_value = value;
		_setExpandedSet = true;
	}
	
	public void setValue(ValueExpression value) {
		if (!_setExpandedSet) {
			_value = value;
		} else {
			logValueDeprecation(value);	
		}
	}
	
	
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		
		UIPanelMenuGroup panelMenu = (UIPanelMenuGroup) component;
		
		if (_value != null) {
			if (_value.isLiteralText()) {
				try {
					panelMenu.setExpanded(Boolean.parseBoolean(_value.getExpressionString()));
				} catch (ELException e) {
					throw new FacesException(e);
				}
			} else {
				component.setValueExpression("value", _value);
			}
		}else{
			panelMenu.setExpanded(false);	
		}	
	}
	
	
	public void release() {
		super.release();
		_setExpandedSet = false;
		_value = null;
	}
}
