/**
 * 
 */
package org.richfaces.component;

import java.util.Iterator;

import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;

import org.ajax4jsf.component.AjaxSupport;

class DataIterator extends ColumnsIterator {

	protected Iterator<UIComponent> facetsIterator;

	public DataIterator(UIComponent dataTable) {
		super(dataTable);
		facetsIterator = dataTable.getFacets().values().iterator();
	}

	@Override
	protected UIComponent nextColumn() {
		UIComponent nextColumn = null;
		while (null == nextColumn && childrenIterator.hasNext()) {
			UIComponent child = childrenIterator.next();
			if (child.isRendered()) {
				if (child instanceof UIColumn || child instanceof Column) {
					nextColumn = child;
				} else if (checkAjaxComponent(child)) {
					nextColumn = child;
				}
			}
		}
		while (null == nextColumn && facetsIterator.hasNext()) {
			UIComponent child = facetsIterator.next();
			if (checkAjaxComponent(child)) {
				nextColumn = child;
				break;
			}
		}
		return nextColumn;
	}

	/**
	 * @param child
	 * @return
	 */
	protected Iterator<UIComponent> getColumnChildrenIterator(UIComponent child) {
		return child.getChildren().iterator();
	}

	/**
	 * @param child
	 * @return
	 */
	protected boolean checkAjaxComponent(UIComponent child) {
		return child instanceof AjaxSupport || child instanceof Dropzone;
	}

}