package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UIPaint2D;

public class HtmlPaint2D extends UIPaint2D{

final static public  String COMPONENT_FAMILY = "javax.faces.Output";

final static public  String COMPONENT_TYPE = "org.richfaces.Paint2D";

/*
* Deprecated. This attribute specifies the position of an IMG, OBJECT, or APPLET with respect to its context.           
           The possible values are "bottom", "middle", "top", "left" and "right". The default value is "middle".
*/
private  String _align = null;

/*
* Background color of painted image. Default value is 'transparent' which means no background fill. 
			Hex colors can be used, as well as common color names. 
			Invalid values are treated as transparent.
			Note, that JPEG format doesn't support transparency, and transparent background is painted black.
			Also note, that several browsers (e.g. IE6) do not support PNG transparency
*/
private  String _bgcolor = null;

/*
* Deprecated. This attribute specifies the width of an IMG or OBJECT border, in pixels. The default value for this attribute depends on the user agent
*/
private  String _border = null;

/*
* Supported (or not) client/server caching for generated images.
			Caching on client supported by properly sending and processing of HTTP headers (Last-Modified, Expires, If-Modified-Since, etc.)
			Server-side caching is supported by application-scope object cache.
			For build of cache key use "value" attribute, serialized to URI
*/
private  boolean _cacheable = false;

private  boolean _cacheableSet = false;

/*
* 
*/
private  Converter _converter = null;

/*
* Value calculated at render time and stored in Image URI (as part of cache Key), 
			at paint time passed to a paint method. It can be used for updating cache at change of image generating
			conditions, and for creating paint beans as "Lightweight" pattern components (request scope).
			IMPORTANT: Since serialized data stored in URI, avoid using big objects
*/
private  Object _data = null;

/*
* Direction indication for text that does not inherit
						directionality. Valid values are "LTR" (left-to-right)
						and "RTL" (right-to-left)
*/
private  String _dir = null;

/*
* format Name of format for sending a generated image. It currently supports "jpeg" (24 bit, default), "gif" (8 bit with transparency), "png" (32 bit with transparency)
*/
private  String _format = null;

/*
* Height in pixels of image (for paint canvas and HTML attribute). Default value is "10".
*/
private  int _height = 10;

private  boolean _heightSet = false;

/*
* Deprecated. This attribute specifies the amount of white space to be inserted to the left and right of an IMG, APPLET, or OBJECT. The default value is not specified, but is generally a small, non-zero length
*/
private  String _hspace = null;

/*
* Code describing the language used in the generated markup for this component
*/
private  String _lang = null;

/*
* The method calls expression to paint Image on prepared Buffered image. It must have two parameters with a type of java.awt.Graphics2D (graphics to paint) and Object (restored from URI "data" property).
			For painting used 32-bit RGBA color model (for 8-bit images used Diffusion filtration before sending)
*/
private  MethodBinding _paint = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;

/*
* The current value of this component
*/
private  Object _value = null;

/*
* Deprecated. This attribute specifies the amount of white space to be inserted above and below an IMG, APPLET, or OBJECT. The default value is not specified, but is generally a small, non-zero length
*/
private  String _vspace = null;

/*
* Width in pixels of image (for paint canvas and HTML attribute). Default value is "10".
*/
private  int _width = 10;

private  boolean _widthSet = false;


public HtmlPaint2D(){
setRendererType("org.richfaces.Paint2DRenderer");
}

public String getAlign(){
	if (this._align != null) {
		return this._align;
	}
	ValueExpression ve = getValueExpression("align");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlign(String _align){
this._align = _align;
}

public String getBgcolor(){
	if (this._bgcolor != null) {
		return this._bgcolor;
	}
	ValueExpression ve = getValueExpression("bgcolor");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "transparent";
	

}

public void setBgcolor(String _bgcolor){
this._bgcolor = _bgcolor;
}

public String getBorder(){
	if (this._border != null) {
		return this._border;
	}
	ValueExpression ve = getValueExpression("border");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setBorder(String _border){
this._border = _border;
}

public boolean isCacheable(){
	if (this._cacheableSet) {
	    return (this._cacheable);
	}
	ValueExpression ve = getValueExpression("cacheable");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._cacheable);
	    }
	    
	    return value;
	} else {
	    return (this._cacheable);
	}

}

public void setCacheable(boolean _cacheable){
this._cacheable = _cacheable;
this._cacheableSet = true;
}

public Converter getConverter(){
	if (this._converter != null) {
		return this._converter;
	}
	ValueExpression ve = getValueExpression("converter");
	if (ve != null) {
	    Converter value = null;
	    
	    try {
			value = (Converter) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setConverter(Converter _converter){
this._converter = _converter;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public String getDir(){
	if (this._dir != null) {
		return this._dir;
	}
	ValueExpression ve = getValueExpression("dir");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDir(String _dir){
this._dir = _dir;
}

public String getFormat(){
	if (this._format != null) {
		return this._format;
	}
	ValueExpression ve = getValueExpression("format");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFormat(String _format){
this._format = _format;
}

public int getHeight(){
	if (this._heightSet) {
	    return (this._height);
	}
	ValueExpression ve = getValueExpression("height");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._height);
	    }
	    
	    return value;
	} else {
	    return (this._height);
	}

}

public void setHeight(int _height){
this._height = _height;
this._heightSet = true;
}

public String getHspace(){
	if (this._hspace != null) {
		return this._hspace;
	}
	ValueExpression ve = getValueExpression("hspace");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHspace(String _hspace){
this._hspace = _hspace;
}

public String getLang(){
	if (this._lang != null) {
		return this._lang;
	}
	ValueExpression ve = getValueExpression("lang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLang(String _lang){
this._lang = _lang;
}

public MethodBinding getPaint(){
return _paint;
}

public void setPaint(MethodBinding _paint){
this._paint = _paint;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public Object getValue(){
	if (this._value != null) {
		return this._value;
	}
	ValueExpression ve = getValueExpression("value");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setValue(Object _value){
this._value = _value;
}

public String getVspace(){
	if (this._vspace != null) {
		return this._vspace;
	}
	ValueExpression ve = getValueExpression("vspace");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setVspace(String _vspace){
this._vspace = _vspace;
}

public int getWidth(){
	if (this._widthSet) {
	    return (this._width);
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._width);
	    }
	    
	    return value;
	} else {
	    return (this._width);
	}

}

public void setWidth(int _width){
this._width = _width;
this._widthSet = true;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[22];
state[0] = super.saveState(context);
state[1] = _align;
state[2] = _bgcolor;
state[3] = _border;
state[4] = Boolean.valueOf(_cacheable);
state[5] = Boolean.valueOf(_cacheableSet);
state[6] = saveAttachedState(context, _converter);
state[7] = saveAttachedState(context, _data);
state[8] = _dir;
state[9] = _format;
state[10] = Integer.valueOf(_height);
state[11] = Boolean.valueOf(_heightSet);
state[12] = _hspace;
state[13] = _lang;
state[14] = saveAttachedState(context, _paint);
state[15] = _style;
state[16] = _styleClass;
state[17] = _title;
state[18] = saveAttachedState(context, _value);
state[19] = _vspace;
state[20] = Integer.valueOf(_width);
state[21] = Boolean.valueOf(_widthSet);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_align = (String)states[1];;
		_bgcolor = (String)states[2];;
		_border = (String)states[3];;
		_cacheable = ((Boolean)states[4]).booleanValue();
		_cacheableSet = ((Boolean)states[5]).booleanValue();
		_converter = (Converter)restoreAttachedState(context, states[6]);
		_data = (Object)restoreAttachedState(context, states[7]);
		_dir = (String)states[8];;
		_format = (String)states[9];;
		_height = ((Integer)states[10]).intValue();
		_heightSet = ((Boolean)states[11]).booleanValue();
		_hspace = (String)states[12];;
		_lang = (String)states[13];;
		_paint = (MethodBinding)restoreAttachedState(context, states[14]);
		_style = (String)states[15];;
		_styleClass = (String)states[16];;
		_title = (String)states[17];;
		_value = (Object)restoreAttachedState(context, states[18]);
		_vspace = (String)states[19];;
		_width = ((Integer)states[20]).intValue();
		_widthSet = ((Boolean)states[21]).booleanValue();
	
}

}
