/**
 *
 */

package org.richfaces.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.component.UIMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.validator.Validator;

import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.component.AjaxContainer;
import org.ajax4jsf.component.AjaxSupport;
import org.ajax4jsf.component.EventValueExpression;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.event.AjaxListener;
import org.ajax4jsf.renderkit.AjaxContainerRenderer;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.event.ValidationEvent;
import org.richfaces.validator.BeanValidator;
import org.richfaces.validator.FacesBeanValidator;

import com.sun.facelets.FaceletException;

/**
 * JSF component class
 * 
 */
public abstract class UIGraphValidator extends UIComponentBase {

	public static final String COMPONENT_TYPE = "org.richfaces.GraphValidator";

	public static final String COMPONENT_FAMILY = "org.richfaces.GraphValidator";

	/**
	 * Get object for validation
	 * 
	 * @return
	 */
	public abstract Object getValue();

	/**
	 * Set object for validation
	 * 
	 * @param newvalue
	 */
	public abstract void setValue(Object newvalue);
	
	/**
	 * Get object for validation
	 * 
	 * @return
	 */
	public abstract String getSummary();

	/**
	 * Set object for validation
	 * 
	 * @param newvalue
	 */
	public abstract void setSummary(String newvalue);

	/**
	 * Get set of profiles for validation
	 * 
	 * @return
	 */
	public abstract Set<String> getProfile();

	/**
	 * Set set of profiles for validation
	 * 
	 * @param newvalue
	 */
	public abstract void setProfile(Set<String> newvalue);

	@Override
	public void processUpdates(FacesContext context) {
		super.processUpdates(context);
		Object value = getValue();
		if (null != value) {
			BeanValidator beanValidator = BeanValidator.getInstance(context);
			String[] messages = beanValidator.validateGraph(context, value,getProfile());
			if (null != messages) {
				context.renderResponse();
				// send all validation messages.
				for (String msg : messages) {
					// TODO - create Summary message ?
					String summary = null != getSummary() ? getSummary() + msg : msg;
					context.addMessage(null, new FacesMessage(
							FacesMessage.SEVERITY_ERROR, summary, msg));
				}
			}

		}
	}
	
	@Override
	public void encodeBegin(FacesContext context) throws IOException {
		super.encodeBegin(context);
		FacesBeanValidator validator = (FacesBeanValidator)context.getApplication().createValidator(FacesBeanValidator.BEAN_VALIDATOR_TYPE);
		validator.setSummary(getSummary());
		setupValidators(this,validator);
	}
	
	@Override
	public void encodeChildren(FacesContext context) throws IOException {
		if(isRendered()){
			for (UIComponent child : getChildren()) {
				if(child.isRendered()){
					child.encodeAll(context);
				}
			}
		}
	}
	
	private void setupValidators(UIComponent component,
			Validator validator) {
		Iterator<UIComponent> facetsAndChildren = component.getFacetsAndChildren();
		while (facetsAndChildren.hasNext()) {
			UIComponent child = facetsAndChildren.next();
			if (child instanceof EditableValueHolder) {
				EditableValueHolder input = (EditableValueHolder) child;
				setupValidator(input,validator);
			}
			setupValidators(child, validator);
		}
	}

	/**
	 * @param input
	 */
	private void setupValidator(EditableValueHolder input,Validator validator) {
		Validator[] validators = input.getValidators();
		for (int i = 0; i < validators.length; i++) {
			if(validators[i] instanceof FacesBeanValidator){
				return;
			}
		}
		input.addValidator(validator);
	}

	@Override
	public boolean getRendersChildren() {
		return true;
	}

}
