/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIExtendedDataTable;

class ColumnsVisibility
implements Serializable {
    private static final long serialVersionUID = -3923409650272094713L;
    private static final String SEP = ";";
    private String value;

    private ColumnsVisibility() {
    }

    static ColumnsVisibility getColumnsVisibility(UIExtendedDataTable extendedDataTable, String val) {
        ColumnsVisibility columnsVisibility = new ColumnsVisibility();
        columnsVisibility.init(extendedDataTable, val);
        return columnsVisibility;
    }

    private void init(UIExtendedDataTable extendedDataTable, String val) {
        this.value = val;
        if (this.value == null || this.value.length() == 0) {
            this.createDefaultColumnsVisibility(extendedDataTable);
        }
        Iterator<UIColumn> iter = extendedDataTable.getChildColumns();
        while (iter.hasNext()) {
            UIColumn child = iter.next();
            if (!(child instanceof UIColumn)) continue;
            UIColumn dataColumn = child;
            dataColumn.setVisible(this.isVisible(dataColumn.getId()));
        }
    }

    public String toString() {
        return this.value;
    }

    private void createDefaultColumnsVisibility(UIExtendedDataTable extendedDataTable) {
        StringBuilder builder = new StringBuilder();
        Iterator<UIColumn> iter = extendedDataTable.getChildColumns();
        while (iter.hasNext()) {
            UIColumn kid = iter.next();
            builder.append(kid.getId().toUpperCase()).append(SEP);
        }
        this.value = builder.toString();
    }

    boolean isVisible(String columnId) {
        if (this.value == null) {
            return true;
        }
        HashSet<String> visibleIds = new HashSet<String>(Arrays.asList(this.value.toUpperCase().split(SEP)));
        return visibleIds.contains(columnId.toUpperCase());
    }

    void toggleVisibility(UIExtendedDataTable extendedDataTable, String columnId) {
        if (this.value == null) {
            return;
        }
        UIColumn column = null;
        Iterator<UIColumn> iter = extendedDataTable.getChildColumns();
        while (iter.hasNext()) {
            UIColumn col = iter.next();
            if (!col.getId().equalsIgnoreCase(columnId)) continue;
            if (!(col instanceof UIColumn)) break;
            column = col;
            break;
        }
        if (column == null) {
            return;
        }
        boolean visible = column.isVisible();
        visible = !visible;
        column.setVisible(visible);
        HashSet<String> visibleIds = new HashSet<String>(Arrays.asList(this.value.toUpperCase().split(SEP)));
        if (visible) {
            visibleIds.add(columnId.toUpperCase());
        } else {
            visibleIds.remove(columnId.toUpperCase());
        }
        StringBuilder builder = new StringBuilder();
        for (String str : visibleIds) {
            builder.append(str).append(SEP);
        }
        this.value = builder.toString();
    }
}

