/**
 * 
 */
package org.richfaces.ui.application;

import java.util.Map;

import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;

import org.richfaces.ui.model.States;

/**
 * @author asmirnov
 *
 */
public class StateNavigationHandler extends NavigationHandler {
	
	private NavigationHandler parent;

	/**
	 * @param parent
	 */
	public StateNavigationHandler(NavigationHandler parent) {
		super();
		this.parent = parent;
	}

	/**
	 * @param context
	 * @param fromAction
	 * @param outcome
	 * @see javax.faces.application.NavigationHandler#handleNavigation(javax.faces.context.FacesContext, java.lang.String, java.lang.String)
	 */
	public void handleNavigation(FacesContext context, String fromAction,
			String outcome) {
		if(null != outcome){
			Map<String, Object> requestMap = context.getExternalContext().getRequestMap();
			for (Object bean : requestMap.values()) {
				if (bean instanceof States) {
					States state = (States) bean;
					String navigation = state.getNavigation(outcome);
					if(null != navigation){
						state.setCurrentState(navigation);
					}
				}
			}
		}
		parent.handleNavigation(context, fromAction, outcome);
	}

}
