/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.richfaces.component.UIToolBar;
import org.richfaces.component.UIToolBarGroup;
import org.richfaces.component.util.ViewUtil;
import org.richfaces.renderkit.html.images.DotSeparatorImage;
import org.richfaces.renderkit.html.images.GridSeparatorImage;
import org.richfaces.renderkit.html.images.LineSeparatorImage;
import org.richfaces.renderkit.html.images.SquareSeparatorImage;

public class ToolBarRendererBase
extends HeaderResourcesRendererBase {
    private static final String[] ON_ITEM_EVENTS = new String[]{"onitemkeydown", "onitemkeypress", "onitemkeyup", "onitemclick", "onitemdblclick", "onitemmousedown", "onitemmousemove", "onitemmouseover", "onitemmouseout", "onitemmouseup"};

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        UIToolBar toolBar = (UIToolBar)component;
        List children = toolBar.getChildren();
        String contentClass = (String)toolBar.getAttributes().get("contentClass");
        String contentStyle = (String)toolBar.getAttributes().get("contentStyle");
        if (null == contentClass) {
            contentClass = "";
        }
        if (null == contentStyle) {
            contentStyle = "";
        }
        if (children != null) {
            UIComponent child;
            LinkedList<UIComponent> childrenToTheLeft = new LinkedList<UIComponent>();
            LinkedList<UIComponent> childrenToTheRight = new LinkedList<UIComponent>();
            for (UIComponent child2 : children) {
                if (!child2.isRendered()) continue;
                if (child2 instanceof UIToolBarGroup) {
                    UIToolBarGroup group = (UIToolBarGroup)child2;
                    String location = group.getLocation();
                    if (location != null && location.equals("right")) {
                        childrenToTheRight.add(child2);
                        continue;
                    }
                    childrenToTheLeft.add(child2);
                    continue;
                }
                childrenToTheLeft.add(child2);
            }
            ResponseWriter writer = facesContext.getResponseWriter();
            Iterator it = childrenToTheLeft.iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                if (!(child instanceof UIToolBarGroup)) {
                    writer.startElement("td", component);
                    writer.writeAttribute("class", (Object)("dr-toolbar-int rich-toolbar-item " + contentClass), null);
                    this.getUtils().writeAttribute(writer, "style", (Object)contentStyle);
                    this.encodeEventsAttributes(facesContext, (UIComponent)toolBar, writer);
                }
                this.renderChild(facesContext, child);
                if (!(child instanceof UIToolBarGroup)) {
                    writer.endElement("td");
                }
                if (!it.hasNext()) continue;
                this.insertSeparatorIfNeed(facesContext, (UIComponent)toolBar, writer);
            }
            writer.startElement("td", component);
            writer.writeAttribute("width", (Object)"100%", null);
            writer.endElement("td");
            it = childrenToTheRight.iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                this.renderChild(facesContext, child);
                if (!it.hasNext()) continue;
                this.insertSeparatorIfNeed(facesContext, (UIComponent)toolBar, writer);
            }
        }
    }

    protected void insertSeparatorIfNeed(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        boolean isSeparatorFacetRendered;
        UIComponent separatorFacet = component.getFacet("itemSeparator");
        boolean bl = isSeparatorFacetRendered = separatorFacet != null ? separatorFacet.isRendered() : false;
        if (isSeparatorFacetRendered) {
            writer.startElement("td", component);
            writer.writeAttribute("class", (Object)"rich-toolbar-separator", null);
            this.renderChild(context, separatorFacet);
            writer.endElement("td");
        } else {
            this.insertDefaultSeparatorIfNeed(context, component, writer);
        }
    }

    protected void insertDefaultSeparatorIfNeed(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String itemSeparator = (String)component.getAttributes().get("itemSeparator");
        if (itemSeparator != null && itemSeparator.length() != 0 && !itemSeparator.equalsIgnoreCase("none")) {
            String uri = null;
            uri = itemSeparator.equalsIgnoreCase("square") ? this.getResource(SquareSeparatorImage.class.getName()).getUri(context, (Object)component) : (itemSeparator.equalsIgnoreCase("disc") ? this.getResource(DotSeparatorImage.class.getName()).getUri(context, (Object)component) : (itemSeparator.equalsIgnoreCase("grid") ? this.getResource(GridSeparatorImage.class.getName()).getUri(context, (Object)component) : (itemSeparator.equalsIgnoreCase("line") ? this.getResource(LineSeparatorImage.class.getName()).getUri(context, (Object)component) : ViewUtil.getResourceURL((String)itemSeparator))));
            writer.startElement("td", component);
            writer.writeAttribute("align", (Object)"center", null);
            this.getUtils().writeAttribute(writer, "class", component.getAttributes().get("separatorClass"));
            writer.startElement("img", component);
            this.getUtils().writeAttribute(writer, "src", (Object)uri);
            this.getUtils().writeAttribute(writer, "alt", (Object)"");
            writer.endElement("img");
            writer.endElement("td");
        }
    }

    protected Class getComponentClass() {
        return UIToolBar.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeEventsAttributes(FacesContext facesContext, UIComponent component, ResponseWriter writer) throws IOException {
        UIToolBar toolbar = this.getParentToolBar(component);
        Map attributes = toolbar.getAttributes();
        Map groupAttributes = component.getAttributes();
        for (int i = 0; i < ON_ITEM_EVENTS.length; ++i) {
            String eventName = ON_ITEM_EVENTS[i].replace("item", "");
            Object value = attributes.get(ON_ITEM_EVENTS[i]);
            Object groupValue = groupAttributes.get(eventName);
            String attrvalue = "";
            if (null != value && !"".equals(value)) {
                attrvalue = attrvalue + value;
            }
            if (null != groupValue && !"".equals(groupValue)) {
                attrvalue = attrvalue + ";" + groupValue;
            }
            this.getUtils().writeAttribute(writer, eventName, (Object)attrvalue);
        }
    }

    public UIToolBar getParentToolBar(UIComponent component) {
        if (component instanceof UIToolBar) {
            return (UIToolBar)component;
        }
        if (component instanceof UIToolBarGroup) {
            return ((UIToolBarGroup)component).getToolBar();
        }
        UIComponent parent = component.getParent();
        if (!(parent instanceof UIToolBar)) {
            return null;
        }
        return (UIToolBar)parent;
    }
}

