/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.state;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataComponentState;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.richfaces.component.UITree;
import org.richfaces.component.state.events.TreeStateCommandsListener;
import org.richfaces.model.ListRowKey;
import org.richfaces.model.TreeRange;
import org.richfaces.model.TreeRowKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeState
implements DataComponentState,
TreeStateCommandsListener,
StateHolder,
Serializable {
    private static final long serialVersionUID = 9083705369340888171L;
    private static final TreeRange RANGE_UNCONSTRAINED = new TreeRange(){

        public boolean processChildren(TreeRowKey rowKey) {
            return true;
        }

        public boolean processNode(TreeRowKey rowKey) {
            return true;
        }
    };
    private boolean stopInCollapsed = false;
    private TreeRowKey selectedNode = null;
    private Set expandedNodes = new HashSet();
    private Set queuedExpandedNodes = new HashSet();
    private Set queuedCollapsedNodes = new HashSet();
    private boolean _transient;
    private transient TreeRange treeRange = null;

    public TreeState() {
    }

    public TreeState(boolean stopInCollapsed) {
        this.stopInCollapsed = stopInCollapsed;
    }

    public boolean isExpanded(TreeRowKey rowKey) {
        if (rowKey == null) {
            return true;
        }
        return this.expandedNodes.contains(rowKey) || this.queuedExpandedNodes.contains(rowKey);
    }

    public boolean isSelected(TreeRowKey rowKey) {
        return rowKey == null && this.selectedNode == null || this.selectedNode != null && this.selectedNode.equals(rowKey);
    }

    public TreeRowKey getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelected(TreeRowKey rowKey) {
        this.selectedNode = rowKey;
    }

    public Range getRange() {
        if (this.treeRange != null) {
            return this.treeRange;
        }
        if (this.stopInCollapsed) {
            return new TreeRange(){

                public boolean processChildren(TreeRowKey rowKey) {
                    if (rowKey == null) {
                        return true;
                    }
                    return TreeState.this.expandedNodes.contains(rowKey);
                }

                public boolean processNode(TreeRowKey rowKey) {
                    return true;
                }
            };
        }
        return RANGE_UNCONSTRAINED;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] _state = (Object[])state;
        this.expandedNodes = (Set)_state[0];
        this._transient = (Boolean)_state[1];
        this.stopInCollapsed = (Boolean)_state[2];
        this.selectedNode = (TreeRowKey)_state[3];
        this.queuedExpandedNodes = (Set)_state[4];
        this.queuedCollapsedNodes = (Set)_state[5];
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.expandedNodes, new Boolean(this._transient), new Boolean(this.stopInCollapsed), this.selectedNode, this.queuedExpandedNodes, this.queuedCollapsedNodes};
        return state;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    public boolean isStopInCollapsed() {
        return this.stopInCollapsed;
    }

    public void setStopInCollapsed(boolean stopInCollapsed) {
        this.stopInCollapsed = stopInCollapsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitNodes(UITree tree, TreeRange treeRange, TreeRowKey rootKey) throws IOException {
        try {
            this.treeRange = treeRange;
            Object oldKey = tree.getRowKey();
            tree.walkModel(FacesContext.getCurrentInstance(), new Visitor(rootKey, tree), (Range)treeRange, rootKey, null);
            tree.setRowKey(oldKey);
        }
        finally {
            this.treeRange = null;
        }
    }

    @Override
    public void expandAll(UITree tree) throws IOException {
        this.queuedCollapsedNodes.clear();
        this.visitNodes(tree, RANGE_UNCONSTRAINED, null);
    }

    @Override
    public void collapseAll(UITree tree) throws IOException {
        this.expandedNodes.clear();
        this.queuedExpandedNodes.clear();
    }

    @Override
    public void collapseNode(UITree tree, TreeRowKey rowKey) throws IOException {
        this.expandedNodes.remove(rowKey);
        this.queuedExpandedNodes.remove(rowKey);
        this.queuedCollapsedNodes.add(rowKey);
    }

    @Override
    public void expandNode(UITree tree, final TreeRowKey rowKey) throws IOException {
        TreeRange range = new TreeRange(){

            public boolean processChildren(TreeRowKey nextKey) {
                return true;
            }

            public boolean processNode(TreeRowKey nextKey) {
                return rowKey == null && nextKey == null || nextKey.equals(rowKey) || nextKey.isSubKey(rowKey);
            }
        };
        this.visitNodes(tree, range, rowKey);
    }

    public void transferQueuedNodes() {
        this.expandedNodes.addAll(this.queuedExpandedNodes);
        this.queuedExpandedNodes.clear();
        this.expandedNodes.removeAll(this.queuedCollapsedNodes);
        this.queuedCollapsedNodes.clear();
    }

    private List<TreeRowKey> getAllSubKeys(Set nodes, TreeRowKey parent) {
        ArrayList<TreeRowKey> keys = new ArrayList<TreeRowKey>();
        Iterator iter = nodes.iterator();
        while (iter != null && iter.hasNext()) {
            TreeRowKey key = (TreeRowKey)iter.next();
            if (key == null || !parent.isSubKey(key) && !parent.equals(key)) continue;
            keys.add(key);
        }
        return keys;
    }

    public TreeState getSubState(TreeRowKey rowKey) {
        Iterator<TreeRowKey> iter;
        TreeState subTreeState = new TreeState(this.stopInCollapsed);
        if (this.getSelectedNode() != null && rowKey.equals(this.getSelectedNode())) {
            subTreeState.setSelected(rowKey);
        }
        subTreeState._transient = this._transient;
        List<TreeRowKey> nodes = this.getAllSubKeys(this.expandedNodes, rowKey);
        Iterator<TreeRowKey> iterator = iter = nodes != null ? nodes.iterator() : null;
        while (iter != null && iter.hasNext()) {
            subTreeState.expandedNodes.add(iter.next().getSubKey(rowKey.depth() - 1));
        }
        nodes = this.getAllSubKeys(this.queuedExpandedNodes, rowKey);
        Iterator<TreeRowKey> iterator2 = iter = nodes != null ? nodes.iterator() : null;
        while (iter != null && iter.hasNext()) {
            subTreeState.queuedExpandedNodes.add(iter.next().getSubKey(rowKey.depth() - 1));
        }
        nodes = this.getAllSubKeys(this.queuedCollapsedNodes, rowKey);
        Iterator<TreeRowKey> iterator3 = iter = nodes != null ? nodes.iterator() : null;
        while (iter != null && iter.hasNext()) {
            subTreeState.queuedCollapsedNodes.add(iter.next().getSubKey(rowKey.depth() - 1));
        }
        return subTreeState;
    }

    public void clearSubState(TreeRowKey rowKey) {
        if (rowKey.equals(this.getSelectedNode())) {
            this.setSelected(null);
        }
        if (rowKey.getPath().equals("null")) {
            this.expandedNodes.clear();
            this.queuedCollapsedNodes.clear();
            this.queuedExpandedNodes.clear();
        } else {
            Iterator<TreeRowKey> iter;
            List<TreeRowKey> nodes = this.getAllSubKeys(this.expandedNodes, rowKey);
            Iterator<TreeRowKey> iterator = iter = nodes != null ? nodes.iterator() : null;
            while (iter != null && iter.hasNext()) {
                this.expandedNodes.remove(iter.next());
            }
            nodes = this.getAllSubKeys(this.queuedExpandedNodes, rowKey);
            Iterator<TreeRowKey> iterator2 = iter = nodes != null ? nodes.iterator() : null;
            while (iter != null && iter.hasNext()) {
                this.queuedExpandedNodes.remove(iter.next());
            }
            nodes = this.getAllSubKeys(this.queuedCollapsedNodes, rowKey);
            Iterator<TreeRowKey> iterator3 = iter = nodes != null ? nodes.iterator() : null;
            while (iter != null && iter.hasNext()) {
                this.queuedCollapsedNodes.remove(iter.next());
            }
        }
    }

    public void mergeSubState(TreeRowKey rowKey, TreeState subState) {
        TreeRowKey key;
        Iterator iter = subState.expandedNodes.iterator();
        while (iter != null && iter.hasNext()) {
            key = ((TreeRowKey)iter.next()).getSubKey(1);
            if (key.depth() > 0) {
                this.expandedNodes.add(new ListRowKey((ListRowKey)rowKey, (ListRowKey)key));
                continue;
            }
            if (this.expandedNodes.contains(rowKey)) continue;
            this.expandedNodes.add(rowKey);
        }
        iter = subState.queuedExpandedNodes.iterator();
        while (iter != null && iter.hasNext()) {
            key = ((TreeRowKey)iter.next()).getSubKey(1);
            if (key.depth() > 0) {
                this.queuedExpandedNodes.add(new ListRowKey((ListRowKey)rowKey, (ListRowKey)key));
                continue;
            }
            if (this.queuedExpandedNodes.contains(rowKey)) continue;
            this.queuedExpandedNodes.add(rowKey);
        }
        iter = subState.queuedCollapsedNodes.iterator();
        while (iter != null && iter.hasNext()) {
            key = ((TreeRowKey)iter.next()).getSubKey(1);
            if (key.depth() > 0) {
                this.queuedCollapsedNodes.add(new ListRowKey((ListRowKey)rowKey, (ListRowKey)key));
                continue;
            }
            if (this.queuedCollapsedNodes.contains(rowKey)) continue;
            this.queuedCollapsedNodes.add(rowKey);
        }
    }

    private final class Visitor
    implements DataVisitor {
        private TreeRowKey key;
        private UITree tree;

        public Visitor(TreeRowKey key, UITree tree) {
            this.key = key;
            this.tree = tree;
        }

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            this.tree.setRowKey(context, rowKey);
            if (this.tree.isRowAvailable()) {
                TreeRowKey nextKey = (TreeRowKey)rowKey;
                if (!this.tree.isLeaf() && nextKey != null && (this.key == null || nextKey.isSubKey(this.key) || nextKey.equals(this.key))) {
                    if (this.tree.isImmediate()) {
                        TreeState.this.queuedExpandedNodes.add(nextKey);
                    } else {
                        TreeState.this.expandedNodes.add(nextKey);
                    }
                    TreeState.this.queuedCollapsedNodes.remove(nextKey);
                }
            } else {
                FacesMessage message = new FacesMessage("Row key: " + rowKey + " isn't available!");
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.tree.getBaseClientId(context), message);
            }
        }
    }
}

