/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.richfaces.component.util.HtmlUtil;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.ajax4jsf.renderkit.AjaxComponentRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.HotKeyRenderer
 */
public class HotKeyRenderer extends AjaxComponentRendererBase {

	public HotKeyRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] scripts = {
						getResource("/org/richfaces/renderkit/html/scripts/jquery/jquery.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/jquery.hotkeys.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/hotKey.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIHotKey.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIHotKey component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
java.util.Map attributes  = component.getAttributes() ;
java.lang.StringBuilder options ;

		
			options = new StringBuilder("{");

			String timing = (String) attributes.get("timing");
			
			if (!"onload".equals(timing) && !"immediate".equals(timing) && 
					!"onregistercall".equals(timing)) {
			
				throw new IllegalArgumentException("The timing attribute of the hotKey component (id='"+clientId+"') has an invalid value:'"+ timing +
					"'. It may have only the following values: 'immediate', 'onload', 'onregistercall'");
			}
			
			options.append("timing:'");
			options.append(timing.toString());
			options.append("'");
			
			String type = (String) attributes.get("type");
			if (type != null && type.length() != 0) {
				options.append(",type:'");
				
				if (type.startsWith("on")) {
					// 2 is "on".length()
					type = type.substring(2);
				} 

				options.append(type);
				options.append("'");
			}
			
			Boolean propagate = (Boolean) attributes.get("propagate");
			if (propagate != null) {
				options.append(",propagate:");
				options.append(propagate);
			}
			
			Boolean disableInInput = (Boolean) attributes.get("disableInInput");
			if (disableInInput != null) {
				options.append(",disableInInput:");
				options.append(disableInInput);
			}
			
			Boolean checkParent = (Boolean) attributes.get("checkParent");
			if (checkParent != null) {
				options.append(",checkParent:");
				options.append(checkParent);
			}
			  
			options.append("}");
		 
	
java.lang.String selector  = "" ;

		
		selector = (String) attributes.get("selector");         
		if (selector != null && selector.length() != 0) {
			selector = getUtils().escapeJavaScript(
					HtmlUtil.expandIdSelector(selector, component, context));
		}
		
	
java.lang.Object key  = attributes.get("key") ;

		
		key = getUtils().escapeJavaScript(key);
		
	
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", "display:none" );
			
writer.startElement("script", component);

writer.writeText(convertToString("new Richfaces.hotKey('" + convertToString(clientId) + "','" + convertToString(key) + "','" + convertToString(selector) + "', " + convertToString(options) + ", function(event) { " + convertToString(attributes.get("handler")) + " });"),null);

writer.endElement("script");
writer.endElement("span");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIHotKey)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
