package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIInputNumberSlider;

public class HtmlInputNumberSlider extends UIInputNumberSlider{

static final public  String COMPONENT_FAMILY = "org.richfaces.inputNumberSlider";

static final public  String COMPONENT_TYPE = "org.richfaces.inputNumberSlider";

/*
* This attribute assigns an access key to an element. An access key is a single character from the document character set. Note: Authors should consider the input method of the expected reader when specifying an accesskey
*/
private  String _accesskey = null;

/*
* null
*/
private  String _align = null;

/*
* For user agents that cannot display images, forms, or applets, this attribute specifies an alternate text. Language of an alternate text is specified by the lang attribute
*/
private  String _alt = null;

/*
* A name of CSS class  for the bar element
*/
private  String _barClass = null;

/*
* Style for a slider control line
*/
private  String _barStyle = null;

/*
* an error message to use in client side validation events
*/
private  String _clientErrorMessage = null;

/*
* When set for a form control, this boolean attribute disables the control for your input
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* If set to "false" this attribute makes the text field "read-only", so the value can be
	    	changed only from a handle. Default value is "true".
*/
private  boolean _enableManualInput = true;

private  boolean _enableManualInputSet = false;

/*
* A name of CSS class for a control handle element
*/
private  String _handleClass = null;

/*
* A name of CSS class for a selected control handle element
*/
private  String _handleSelectedClass = null;

/*
* The height of a slider control
*/
private  String _height = null;

/*
* Style Class attribute for a text field
*/
private  String _inputClass = null;

/*
* If "right" the InputText Box would be rendered on the right side of the ruler
*/
private  String _inputPosition = null;

/*
* Similar to the "Size" attribute of h:inputText. Default value is "3".
*/
private  int _inputSize = 3;

private  boolean _inputSizeSet = false;

/*
* Style attribute for text field
*/
private  String _inputStyle = null;

/*
* A localized user presentable name for this component.
*/
private  String _label = null;

/*
* Attribute to set an "end" value. Default value is "100"
*/
private  String _maxValue = null;

/*
* When the type attribute has the value "text" or "password", this attribute specifies the maximum number of characters you may enter. This number may exceed the specified size, in which case the user agent should offer a scrolling mechanism. The default value for this attribute is an unlimited number
*/
private  int _maxlength = Integer.MIN_VALUE;

private  boolean _maxlengthSet = false;

/*
* Attribute to set the "start" value. Default value is "0".
*/
private  String _minValue = null;

/*
* HTML: script expression; the element lost the focus
*/
private  String _onblur = null;

/*
* HTML: script expression; the element value was changed
*/
private  String _onchange = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* This error is called when a non-number value or a number value that is out of the range is input
*/
private  String _onerror = null;

/*
* HTML: script expression; the element got the focus
*/
private  String _onfocus = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _oninputclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _oninputdblclick = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _oninputkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _oninputkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _oninputkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _oninputmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _oninputmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _oninputmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _oninputmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _oninputmouseup = null;

/*
* null
*/
private  String _onkeydown = null;

/*
* null
*/
private  String _onkeypress = null;

/*
* null
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* HTML: script expression; The onselect event occurs when you select some text in a text field. This attribute may be used with the INPUT and TEXTAREA elements
*/
private  String _onselect = null;

/*
* Event occur on slide
*/
private  String _onslide = null;

/*
* If the min/max values are shown on the right/left borders of a control. . Default value is "true".
*/
private  boolean _showBoundaryValues = true;

private  boolean _showBoundaryValuesSet = false;

/*
* False value for this attribute makes text a field invisible. Default value is "true".
*/
private  boolean _showInput = true;

private  boolean _showInputSet = false;

/*
* If "true"the current value is shown in the tooltip when a handle control is in a
	    		"dragged" state. Default value is "true".
*/
private  boolean _showToolTip = true;

private  boolean _showToolTipSet = false;

/*
* null
*/
private  int _size = Integer.MIN_VALUE;

private  boolean _sizeSet = false;

/*
* Parameter that determines a step between the nearest values while using a handle. Default value is "1".
*/
private  String _step = null;

/*
* Styles for main div element of the slider control
*/
private  String _style = null;

/*
* Name of a CSS class
*/
private  String _styleClass = null;

/*
* This attribute specifies the position of the current element in the tabbing order for the current document. This value must be a number between 0 and 32767. User agents should ignore leading zeros
*/
private  String _tabindex = null;

/*
* A name of CSS class for the tool tip element
*/
private  String _tipClass = null;

/*
* A style for the tool tip element
*/
private  String _tipStyle = null;

/*
* The width of a slider control. Default value is "200px"
*/
private  String _width = null;


public HtmlInputNumberSlider(){
setRendererType("org.richfaces.InputNumberSliderRenderer");
}

public String getAccesskey(){
	if (this._accesskey != null) {
		return this._accesskey;
	}
	ValueExpression ve = getValueExpression("accesskey");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAccesskey(String _accesskey){
this._accesskey = _accesskey;
}

public String getAlign(){
	if (this._align != null) {
		return this._align;
	}
	ValueExpression ve = getValueExpression("align");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlign(String _align){
this._align = _align;
}

public String getAlt(){
	if (this._alt != null) {
		return this._alt;
	}
	ValueExpression ve = getValueExpression("alt");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlt(String _alt){
this._alt = _alt;
}

public String getBarClass(){
	if (this._barClass != null) {
		return this._barClass;
	}
	ValueExpression ve = getValueExpression("barClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setBarClass(String _barClass){
this._barClass = _barClass;
}

public String getBarStyle(){
	if (this._barStyle != null) {
		return this._barStyle;
	}
	ValueExpression ve = getValueExpression("barStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setBarStyle(String _barStyle){
this._barStyle = _barStyle;
}

public String getClientErrorMessage(){
	if (this._clientErrorMessage != null) {
		return this._clientErrorMessage;
	}
	ValueExpression ve = getValueExpression("clientErrorMessage");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setClientErrorMessage(String _clientErrorMessage){
this._clientErrorMessage = _clientErrorMessage;
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public boolean isEnableManualInput(){
	if (this._enableManualInputSet) {
	    return (this._enableManualInput);
	}
	ValueExpression ve = getValueExpression("enableManualInput");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._enableManualInput);
	    }
	    
	    return value;
	} else {
	    return (this._enableManualInput);
	}

}

public void setEnableManualInput(boolean _enableManualInput){
this._enableManualInput = _enableManualInput;
this._enableManualInputSet = true;
}

public String getHandleClass(){
	if (this._handleClass != null) {
		return this._handleClass;
	}
	ValueExpression ve = getValueExpression("handleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setHandleClass(String _handleClass){
this._handleClass = _handleClass;
}

public String getHandleSelectedClass(){
	if (this._handleSelectedClass != null) {
		return this._handleSelectedClass;
	}
	ValueExpression ve = getValueExpression("handleSelectedClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setHandleSelectedClass(String _handleSelectedClass){
this._handleSelectedClass = _handleSelectedClass;
}

public String getHeight(){
	if (this._height != null) {
		return this._height;
	}
	ValueExpression ve = getValueExpression("height");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHeight(String _height){
this._height = _height;
}

public String getInputClass(){
	if (this._inputClass != null) {
		return this._inputClass;
	}
	ValueExpression ve = getValueExpression("inputClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setInputClass(String _inputClass){
this._inputClass = _inputClass;
}

public String getInputPosition(){
	if (this._inputPosition != null) {
		return this._inputPosition;
	}
	ValueExpression ve = getValueExpression("inputPosition");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "right";
	

}

public void setInputPosition(String _inputPosition){
this._inputPosition = _inputPosition;
}

public int getInputSize(){
	if (this._inputSizeSet) {
	    return (this._inputSize);
	}
	ValueExpression ve = getValueExpression("inputSize");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._inputSize);
	    }
	    
	    return value;
	} else {
	    return (this._inputSize);
	}

}

public void setInputSize(int _inputSize){
this._inputSize = _inputSize;
this._inputSizeSet = true;
}

public String getInputStyle(){
	if (this._inputStyle != null) {
		return this._inputStyle;
	}
	ValueExpression ve = getValueExpression("inputStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setInputStyle(String _inputStyle){
this._inputStyle = _inputStyle;
}

public String getLabel(){
	if (this._label != null) {
		return this._label;
	}
	ValueExpression ve = getValueExpression("label");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLabel(String _label){
this._label = _label;
}

public String getMaxValue(){
	if (this._maxValue != null) {
		return this._maxValue;
	}
	ValueExpression ve = getValueExpression("maxValue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "100";
	

}

public void setMaxValue(String _maxValue){
this._maxValue = _maxValue;
}

public int getMaxlength(){
	if (this._maxlengthSet) {
	    return (this._maxlength);
	}
	ValueExpression ve = getValueExpression("maxlength");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._maxlength);
	    }
	    
	    return value;
	} else {
	    return (this._maxlength);
	}

}

public void setMaxlength(int _maxlength){
this._maxlength = _maxlength;
this._maxlengthSet = true;
}

public String getMinValue(){
	if (this._minValue != null) {
		return this._minValue;
	}
	ValueExpression ve = getValueExpression("minValue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "0";
	

}

public void setMinValue(String _minValue){
this._minValue = _minValue;
}

public String getOnblur(){
	if (this._onblur != null) {
		return this._onblur;
	}
	ValueExpression ve = getValueExpression("onblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnblur(String _onblur){
this._onblur = _onblur;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnerror(){
	if (this._onerror != null) {
		return this._onerror;
	}
	ValueExpression ve = getValueExpression("onerror");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnerror(String _onerror){
this._onerror = _onerror;
}

public String getOnfocus(){
	if (this._onfocus != null) {
		return this._onfocus;
	}
	ValueExpression ve = getValueExpression("onfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfocus(String _onfocus){
this._onfocus = _onfocus;
}

public String getOninputclick(){
	if (this._oninputclick != null) {
		return this._oninputclick;
	}
	ValueExpression ve = getValueExpression("oninputclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputclick(String _oninputclick){
this._oninputclick = _oninputclick;
}

public String getOninputdblclick(){
	if (this._oninputdblclick != null) {
		return this._oninputdblclick;
	}
	ValueExpression ve = getValueExpression("oninputdblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputdblclick(String _oninputdblclick){
this._oninputdblclick = _oninputdblclick;
}

public String getOninputkeydown(){
	if (this._oninputkeydown != null) {
		return this._oninputkeydown;
	}
	ValueExpression ve = getValueExpression("oninputkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeydown(String _oninputkeydown){
this._oninputkeydown = _oninputkeydown;
}

public String getOninputkeypress(){
	if (this._oninputkeypress != null) {
		return this._oninputkeypress;
	}
	ValueExpression ve = getValueExpression("oninputkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeypress(String _oninputkeypress){
this._oninputkeypress = _oninputkeypress;
}

public String getOninputkeyup(){
	if (this._oninputkeyup != null) {
		return this._oninputkeyup;
	}
	ValueExpression ve = getValueExpression("oninputkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputkeyup(String _oninputkeyup){
this._oninputkeyup = _oninputkeyup;
}

public String getOninputmousedown(){
	if (this._oninputmousedown != null) {
		return this._oninputmousedown;
	}
	ValueExpression ve = getValueExpression("oninputmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmousedown(String _oninputmousedown){
this._oninputmousedown = _oninputmousedown;
}

public String getOninputmousemove(){
	if (this._oninputmousemove != null) {
		return this._oninputmousemove;
	}
	ValueExpression ve = getValueExpression("oninputmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmousemove(String _oninputmousemove){
this._oninputmousemove = _oninputmousemove;
}

public String getOninputmouseout(){
	if (this._oninputmouseout != null) {
		return this._oninputmouseout;
	}
	ValueExpression ve = getValueExpression("oninputmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmouseout(String _oninputmouseout){
this._oninputmouseout = _oninputmouseout;
}

public String getOninputmouseover(){
	if (this._oninputmouseover != null) {
		return this._oninputmouseover;
	}
	ValueExpression ve = getValueExpression("oninputmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmouseover(String _oninputmouseover){
this._oninputmouseover = _oninputmouseover;
}

public String getOninputmouseup(){
	if (this._oninputmouseup != null) {
		return this._oninputmouseup;
	}
	ValueExpression ve = getValueExpression("oninputmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOninputmouseup(String _oninputmouseup){
this._oninputmouseup = _oninputmouseup;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselect(){
	if (this._onselect != null) {
		return this._onselect;
	}
	ValueExpression ve = getValueExpression("onselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselect(String _onselect){
this._onselect = _onselect;
}

public String getOnslide(){
	if (this._onslide != null) {
		return this._onslide;
	}
	ValueExpression ve = getValueExpression("onslide");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnslide(String _onslide){
this._onslide = _onslide;
}

public boolean isShowBoundaryValues(){
	if (this._showBoundaryValuesSet) {
	    return (this._showBoundaryValues);
	}
	ValueExpression ve = getValueExpression("showBoundaryValues");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._showBoundaryValues);
	    }
	    
	    return value;
	} else {
	    return (this._showBoundaryValues);
	}

}

public void setShowBoundaryValues(boolean _showBoundaryValues){
this._showBoundaryValues = _showBoundaryValues;
this._showBoundaryValuesSet = true;
}

public boolean isShowInput(){
	if (this._showInputSet) {
	    return (this._showInput);
	}
	ValueExpression ve = getValueExpression("showInput");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._showInput);
	    }
	    
	    return value;
	} else {
	    return (this._showInput);
	}

}

public void setShowInput(boolean _showInput){
this._showInput = _showInput;
this._showInputSet = true;
}

public boolean isShowToolTip(){
	if (this._showToolTipSet) {
	    return (this._showToolTip);
	}
	ValueExpression ve = getValueExpression("showToolTip");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._showToolTip);
	    }
	    
	    return value;
	} else {
	    return (this._showToolTip);
	}

}

public void setShowToolTip(boolean _showToolTip){
this._showToolTip = _showToolTip;
this._showToolTipSet = true;
}

public int getSize(){
	if (this._sizeSet) {
	    return (this._size);
	}
	ValueExpression ve = getValueExpression("size");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._size);
	    }
	    
	    return value;
	} else {
	    return (this._size);
	}

}

public void setSize(int _size){
this._size = _size;
this._sizeSet = true;
}

public String getStep(){
	if (this._step != null) {
		return this._step;
	}
	ValueExpression ve = getValueExpression("step");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "1";
	

}

public void setStep(String _step){
this._step = _step;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTabindex(){
	if (this._tabindex != null) {
		return this._tabindex;
	}
	ValueExpression ve = getValueExpression("tabindex");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTabindex(String _tabindex){
this._tabindex = _tabindex;
}

public String getTipClass(){
	if (this._tipClass != null) {
		return this._tipClass;
	}
	ValueExpression ve = getValueExpression("tipClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setTipClass(String _tipClass){
this._tipClass = _tipClass;
}

public String getTipStyle(){
	if (this._tipStyle != null) {
		return this._tipStyle;
	}
	ValueExpression ve = getValueExpression("tipStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setTipStyle(String _tipStyle){
this._tipStyle = _tipStyle;
}

public String getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "200px";
	

}

public void setWidth(String _width){
this._width = _width;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[65];
state[0] = super.saveState(context);
state[1] = _accesskey;
state[2] = _align;
state[3] = _alt;
state[4] = _barClass;
state[5] = _barStyle;
state[6] = _clientErrorMessage;
state[7] = Boolean.valueOf(_disabled);
state[8] = Boolean.valueOf(_disabledSet);
state[9] = Boolean.valueOf(_enableManualInput);
state[10] = Boolean.valueOf(_enableManualInputSet);
state[11] = _handleClass;
state[12] = _handleSelectedClass;
state[13] = _height;
state[14] = _inputClass;
state[15] = _inputPosition;
state[16] = Integer.valueOf(_inputSize);
state[17] = Boolean.valueOf(_inputSizeSet);
state[18] = _inputStyle;
state[19] = _label;
state[20] = _maxValue;
state[21] = Integer.valueOf(_maxlength);
state[22] = Boolean.valueOf(_maxlengthSet);
state[23] = _minValue;
state[24] = _onblur;
state[25] = _onchange;
state[26] = _onclick;
state[27] = _ondblclick;
state[28] = _onerror;
state[29] = _onfocus;
state[30] = _oninputclick;
state[31] = _oninputdblclick;
state[32] = _oninputkeydown;
state[33] = _oninputkeypress;
state[34] = _oninputkeyup;
state[35] = _oninputmousedown;
state[36] = _oninputmousemove;
state[37] = _oninputmouseout;
state[38] = _oninputmouseover;
state[39] = _oninputmouseup;
state[40] = _onkeydown;
state[41] = _onkeypress;
state[42] = _onkeyup;
state[43] = _onmousedown;
state[44] = _onmousemove;
state[45] = _onmouseout;
state[46] = _onmouseover;
state[47] = _onmouseup;
state[48] = _onselect;
state[49] = _onslide;
state[50] = Boolean.valueOf(_showBoundaryValues);
state[51] = Boolean.valueOf(_showBoundaryValuesSet);
state[52] = Boolean.valueOf(_showInput);
state[53] = Boolean.valueOf(_showInputSet);
state[54] = Boolean.valueOf(_showToolTip);
state[55] = Boolean.valueOf(_showToolTipSet);
state[56] = Integer.valueOf(_size);
state[57] = Boolean.valueOf(_sizeSet);
state[58] = _step;
state[59] = _style;
state[60] = _styleClass;
state[61] = _tabindex;
state[62] = _tipClass;
state[63] = _tipStyle;
state[64] = _width;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_accesskey = (String)states[1];;
		_align = (String)states[2];;
		_alt = (String)states[3];;
		_barClass = (String)states[4];;
		_barStyle = (String)states[5];;
		_clientErrorMessage = (String)states[6];;
		_disabled = ((Boolean)states[7]).booleanValue();
		_disabledSet = ((Boolean)states[8]).booleanValue();
		_enableManualInput = ((Boolean)states[9]).booleanValue();
		_enableManualInputSet = ((Boolean)states[10]).booleanValue();
		_handleClass = (String)states[11];;
		_handleSelectedClass = (String)states[12];;
		_height = (String)states[13];;
		_inputClass = (String)states[14];;
		_inputPosition = (String)states[15];;
		_inputSize = ((Integer)states[16]).intValue();
		_inputSizeSet = ((Boolean)states[17]).booleanValue();
		_inputStyle = (String)states[18];;
		_label = (String)states[19];;
		_maxValue = (String)states[20];;
		_maxlength = ((Integer)states[21]).intValue();
		_maxlengthSet = ((Boolean)states[22]).booleanValue();
		_minValue = (String)states[23];;
		_onblur = (String)states[24];;
		_onchange = (String)states[25];;
		_onclick = (String)states[26];;
		_ondblclick = (String)states[27];;
		_onerror = (String)states[28];;
		_onfocus = (String)states[29];;
		_oninputclick = (String)states[30];;
		_oninputdblclick = (String)states[31];;
		_oninputkeydown = (String)states[32];;
		_oninputkeypress = (String)states[33];;
		_oninputkeyup = (String)states[34];;
		_oninputmousedown = (String)states[35];;
		_oninputmousemove = (String)states[36];;
		_oninputmouseout = (String)states[37];;
		_oninputmouseover = (String)states[38];;
		_oninputmouseup = (String)states[39];;
		_onkeydown = (String)states[40];;
		_onkeypress = (String)states[41];;
		_onkeyup = (String)states[42];;
		_onmousedown = (String)states[43];;
		_onmousemove = (String)states[44];;
		_onmouseout = (String)states[45];;
		_onmouseover = (String)states[46];;
		_onmouseup = (String)states[47];;
		_onselect = (String)states[48];;
		_onslide = (String)states[49];;
		_showBoundaryValues = ((Boolean)states[50]).booleanValue();
		_showBoundaryValuesSet = ((Boolean)states[51]).booleanValue();
		_showInput = ((Boolean)states[52]).booleanValue();
		_showInputSet = ((Boolean)states[53]).booleanValue();
		_showToolTip = ((Boolean)states[54]).booleanValue();
		_showToolTipSet = ((Boolean)states[55]).booleanValue();
		_size = ((Integer)states[56]).intValue();
		_sizeSet = ((Boolean)states[57]).booleanValue();
		_step = (String)states[58];;
		_style = (String)states[59];;
		_styleClass = (String)states[60];;
		_tabindex = (String)states[61];;
		_tipClass = (String)states[62];;
		_tipStyle = (String)states[63];;
		_width = (String)states[64];;
	
}

}
