package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIDataGrid;

public class HtmlDataGrid extends UIDataGrid{

public final static  String COMPONENT_FAMILY = "org.richfaces.DataGrid";

public final static  String COMPONENT_TYPE = "org.richfaces.DataGrid";

/*
* Deprecated. This attribute specifies the position of the table with respect to the document. 
            The possible values are "left", "center" and "right".
*/
private  String _align = null;

/*
* Deprecated. This attribute sets the background color for the document body or table cells.
            
            This attribute sets the background color of the canvas for the document body (the BODY element) or for tables (the TABLE, TR, TH, and TD elements). Additional attributes for specifying text color can be used with the BODY element.
            
            This attribute has been deprecated in favor of style sheets for specifying background color information
*/
private  String _bgcolor = null;

/*
* This attributes specifies the width of the frame around a component. Default value is "0".
*/
private  String _border = null;

/*
* Space-separated list of CSS style class(es) that are be applied to caption for this component
*/
private  String _captionClass = null;

/*
* CSS style(s) is/are to be applied to caption when this component is rendered
*/
private  String _captionStyle = null;

/*
* This attribute specifies the amount of space between the border of the cell and its contents. Default value is "0".
*/
private  String _cellpadding = null;

/*
* This attribute specifies the amount of space between the border of the cell and its contents.  
				The attribute also specifies the amount of space to leave between cells. Default value is "0".
*/
private  String _cellspacing = null;

/*
* Comma-delimited list of CSS style classes that are be applied to the columns of this table. A space separated list of classes may also be specified for any individual column. If the number of elements in this list is less than the number of columns specified in the "columns" attribute, no "class" attribute is output for each column greater than the number of elements in the list. If the number of elements in the list is greater than the number of columns specified in the "columns" attribute, the elements at the position in the list after the value of the "columns" attribute are ignored
*/
private  String _columnClasses = null;

/*
* Number of columns
*/
private  int _columns = Integer.MIN_VALUE;

private  boolean _columnsSet = false;

/*
* Direction indication for text that does not inherit
			directionality. Valid values are "LTR" (left-to-right)
			and "RTL" (right-to-left)
*/
private  String _dir = null;

/*
* Space-separated list of CSS style class(es) that are be applied to footer for this component
*/
private  String _footerClass = null;

/*
* This attribute specifies which sides of the frame surrounding a table will be visible. Possible values:  "void", "above", "below", "hsides", "lhs", "rhs", "vsides", "box" and "border".
        The default value is "void".
*/
private  String _frame = null;

/*
* Space-separated list of CSS style class(es) that are be applied to header for this component
*/
private  String _headerClass = null;

/*
* Code describing the language used in the generated markup for this component
*/
private  String _lang = null;

/*
* HTML: a script expression; a pointer button is clicked on row
*/
private  String _onRowClick = null;

/*
* HTML: a script expression; a pointer button is double-clicked on row
*/
private  String _onRowDblClick = null;

/*
* HTML: script expression; a pointer button is pressed down on row
*/
private  String _onRowMouseDown = null;

/*
* HTML: a script expression; a pointer is moved within of row
*/
private  String _onRowMouseMove = null;

/*
* HTML: a script expression; a pointer is moved away of row
*/
private  String _onRowMouseOut = null;

/*
* HTML: a script expression; a pointer is moved onto of row
*/
private  String _onRowMouseOver = null;

/*
* HTML: script expression; a pointer button is released on row
*/
private  String _onRowMouseUp = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* A comma-delimited list of CSS style classes that is applied to popup table rows. A space separated list of classes may also be specified for any individual row. The styles are applied, in turn, to each row in the table. For example, if the list has two elements, the first style class in the list is applied to the first row, the second to the second row, the first to the third row, the second to the fourth row, etc. In other words, we keep iterating through the list until we reach the end, and then we start at the beginning again
*/
private  String _rowClasses = null;

/*
* This attribute specifies which rules will appear between cells within a table. The rendering of rules is user agent dependent. Possible values:
            
            * none: No rules. This is the default value.
            * groups: Rules will appear between row groups (see THEAD, TFOOT, and TBODY) and column groups (see COLGROUP and COL) only.
            * rows: Rules will appear between rows only.
            * cols: Rules will appear between columns only.
            * all: Rules will appear between all rows and columns
*/
private  String _rules = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* This attribute provides a summary of the table's purpose and structure for user agents rendering to non-visual media such as speech and Braille
*/
private  String _summary = null;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;

/*
* This attribute specifies the desired width of the entire table and is intended for visual user agents. When the value is percentage value, the value is relative to the user agent's available horizontal space. In the absence of any width specification, table width is determined by the user agent
*/
private  String _width = null;


public HtmlDataGrid(){
setRendererType("org.richfaces.DataGridRenderer");
}

public String getAlign(){
	if (this._align != null) {
		return this._align;
	}
	ValueExpression ve = getValueExpression("align");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlign(String _align){
this._align = _align;
}

public String getBgcolor(){
	if (this._bgcolor != null) {
		return this._bgcolor;
	}
	ValueExpression ve = getValueExpression("bgcolor");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setBgcolor(String _bgcolor){
this._bgcolor = _bgcolor;
}

public String getBorder(){
	if (this._border != null) {
		return this._border;
	}
	ValueExpression ve = getValueExpression("border");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "0";
	

}

public void setBorder(String _border){
this._border = _border;
}

public String getCaptionClass(){
	if (this._captionClass != null) {
		return this._captionClass;
	}
	ValueExpression ve = getValueExpression("captionClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setCaptionClass(String _captionClass){
this._captionClass = _captionClass;
}

public String getCaptionStyle(){
	if (this._captionStyle != null) {
		return this._captionStyle;
	}
	ValueExpression ve = getValueExpression("captionStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCaptionStyle(String _captionStyle){
this._captionStyle = _captionStyle;
}

public String getCellpadding(){
	if (this._cellpadding != null) {
		return this._cellpadding;
	}
	ValueExpression ve = getValueExpression("cellpadding");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "0";
	

}

public void setCellpadding(String _cellpadding){
this._cellpadding = _cellpadding;
}

public String getCellspacing(){
	if (this._cellspacing != null) {
		return this._cellspacing;
	}
	ValueExpression ve = getValueExpression("cellspacing");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "0";
	

}

public void setCellspacing(String _cellspacing){
this._cellspacing = _cellspacing;
}

public String getColumnClasses(){
	if (this._columnClasses != null) {
		return this._columnClasses;
	}
	ValueExpression ve = getValueExpression("columnClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setColumnClasses(String _columnClasses){
this._columnClasses = _columnClasses;
}

public int getColumns(){
	if (this._columnsSet) {
	    return (this._columns);
	}
	ValueExpression ve = getValueExpression("columns");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._columns);
	    }
	    
	    return value;
	} else {
	    return (this._columns);
	}

}

public void setColumns(int _columns){
this._columns = _columns;
this._columnsSet = true;
}

public String getDir(){
	if (this._dir != null) {
		return this._dir;
	}
	ValueExpression ve = getValueExpression("dir");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDir(String _dir){
this._dir = _dir;
}

public String getFooterClass(){
	if (this._footerClass != null) {
		return this._footerClass;
	}
	ValueExpression ve = getValueExpression("footerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setFooterClass(String _footerClass){
this._footerClass = _footerClass;
}

public String getFrame(){
	if (this._frame != null) {
		return this._frame;
	}
	ValueExpression ve = getValueExpression("frame");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFrame(String _frame){
this._frame = _frame;
}

public String getHeaderClass(){
	if (this._headerClass != null) {
		return this._headerClass;
	}
	ValueExpression ve = getValueExpression("headerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setHeaderClass(String _headerClass){
this._headerClass = _headerClass;
}

public String getLang(){
	if (this._lang != null) {
		return this._lang;
	}
	ValueExpression ve = getValueExpression("lang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLang(String _lang){
this._lang = _lang;
}

public String getOnRowClick(){
	if (this._onRowClick != null) {
		return this._onRowClick;
	}
	ValueExpression ve = getValueExpression("onRowClick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowClick(String _onRowClick){
this._onRowClick = _onRowClick;
}

public String getOnRowDblClick(){
	if (this._onRowDblClick != null) {
		return this._onRowDblClick;
	}
	ValueExpression ve = getValueExpression("onRowDblClick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowDblClick(String _onRowDblClick){
this._onRowDblClick = _onRowDblClick;
}

public String getOnRowMouseDown(){
	if (this._onRowMouseDown != null) {
		return this._onRowMouseDown;
	}
	ValueExpression ve = getValueExpression("onRowMouseDown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowMouseDown(String _onRowMouseDown){
this._onRowMouseDown = _onRowMouseDown;
}

public String getOnRowMouseMove(){
	if (this._onRowMouseMove != null) {
		return this._onRowMouseMove;
	}
	ValueExpression ve = getValueExpression("onRowMouseMove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowMouseMove(String _onRowMouseMove){
this._onRowMouseMove = _onRowMouseMove;
}

public String getOnRowMouseOut(){
	if (this._onRowMouseOut != null) {
		return this._onRowMouseOut;
	}
	ValueExpression ve = getValueExpression("onRowMouseOut");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowMouseOut(String _onRowMouseOut){
this._onRowMouseOut = _onRowMouseOut;
}

public String getOnRowMouseOver(){
	if (this._onRowMouseOver != null) {
		return this._onRowMouseOver;
	}
	ValueExpression ve = getValueExpression("onRowMouseOver");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowMouseOver(String _onRowMouseOver){
this._onRowMouseOver = _onRowMouseOver;
}

public String getOnRowMouseUp(){
	if (this._onRowMouseUp != null) {
		return this._onRowMouseUp;
	}
	ValueExpression ve = getValueExpression("onRowMouseUp");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowMouseUp(String _onRowMouseUp){
this._onRowMouseUp = _onRowMouseUp;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getRowClasses(){
	if (this._rowClasses != null) {
		return this._rowClasses;
	}
	ValueExpression ve = getValueExpression("rowClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRowClasses(String _rowClasses){
this._rowClasses = _rowClasses;
}

public String getRules(){
	if (this._rules != null) {
		return this._rules;
	}
	ValueExpression ve = getValueExpression("rules");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRules(String _rules){
this._rules = _rules;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getSummary(){
	if (this._summary != null) {
		return this._summary;
	}
	ValueExpression ve = getValueExpression("summary");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSummary(String _summary){
this._summary = _summary;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public String getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setWidth(String _width){
this._width = _width;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[40];
state[0] = super.saveState(context);
state[1] = _align;
state[2] = _bgcolor;
state[3] = _border;
state[4] = _captionClass;
state[5] = _captionStyle;
state[6] = _cellpadding;
state[7] = _cellspacing;
state[8] = _columnClasses;
state[9] = Integer.valueOf(_columns);
state[10] = Boolean.valueOf(_columnsSet);
state[11] = _dir;
state[12] = _footerClass;
state[13] = _frame;
state[14] = _headerClass;
state[15] = _lang;
state[16] = _onRowClick;
state[17] = _onRowDblClick;
state[18] = _onRowMouseDown;
state[19] = _onRowMouseMove;
state[20] = _onRowMouseOut;
state[21] = _onRowMouseOver;
state[22] = _onRowMouseUp;
state[23] = _onclick;
state[24] = _ondblclick;
state[25] = _onkeydown;
state[26] = _onkeypress;
state[27] = _onkeyup;
state[28] = _onmousedown;
state[29] = _onmousemove;
state[30] = _onmouseout;
state[31] = _onmouseover;
state[32] = _onmouseup;
state[33] = _rowClasses;
state[34] = _rules;
state[35] = _style;
state[36] = _styleClass;
state[37] = _summary;
state[38] = _title;
state[39] = _width;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_align = (String)states[1];;
		_bgcolor = (String)states[2];;
		_border = (String)states[3];;
		_captionClass = (String)states[4];;
		_captionStyle = (String)states[5];;
		_cellpadding = (String)states[6];;
		_cellspacing = (String)states[7];;
		_columnClasses = (String)states[8];;
		_columns = ((Integer)states[9]).intValue();
		_columnsSet = ((Boolean)states[10]).booleanValue();
		_dir = (String)states[11];;
		_footerClass = (String)states[12];;
		_frame = (String)states[13];;
		_headerClass = (String)states[14];;
		_lang = (String)states[15];;
		_onRowClick = (String)states[16];;
		_onRowDblClick = (String)states[17];;
		_onRowMouseDown = (String)states[18];;
		_onRowMouseMove = (String)states[19];;
		_onRowMouseOut = (String)states[20];;
		_onRowMouseOver = (String)states[21];;
		_onRowMouseUp = (String)states[22];;
		_onclick = (String)states[23];;
		_ondblclick = (String)states[24];;
		_onkeydown = (String)states[25];;
		_onkeypress = (String)states[26];;
		_onkeyup = (String)states[27];;
		_onmousedown = (String)states[28];;
		_onmousemove = (String)states[29];;
		_onmouseout = (String)states[30];;
		_onmouseover = (String)states[31];;
		_onmouseup = (String)states[32];;
		_rowClasses = (String)states[33];;
		_rules = (String)states[34];;
		_style = (String)states[35];;
		_styleClass = (String)states[36];;
		_summary = (String)states[37];;
		_title = (String)states[38];;
		_width = (String)states[39];;
	
}

}
