/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Map;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxActionComponent;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.event.DataScrollerListener;
import org.richfaces.event.DataScrollerSource;

public abstract class UIDatascroller
extends AjaxActionComponent
implements DataScrollerSource,
ActionSource {
    private static final Log log = LogFactory.getLog(UIDatascroller.class);
    private Integer page;
    public static final String COMPONENT_TYPE = "org.richfaces.Datascroller";
    public static final String COMPONENT_FAMILY = "org.richfaces.Datascroller";
    public static final String FIRST_FACET_NAME = "first";
    public static final String LAST_FACET_NAME = "last";
    public static final String NEXT_FACET_NAME = "next";
    public static final String PREVIOUS_FACET_NAME = "previous";
    public static final String FAST_FORWARD_FACET_NAME = "fastforward";
    public static final String FAST_REWIND_FACET_NAME = "fastrewind";
    public static final String FIRST_DISABLED_FACET_NAME = "first_disabled";
    public static final String LAST_DISABLED_FACET_NAME = "last_disabled";
    public static final String NEXT_DISABLED_FACET_NAME = "next_disabled";
    public static final String PREVIOUS_DISABLED_FACET_NAME = "previous_disabled";
    public static final String FAST_FORWARD_DISABLED_FACET_NAME = "fastforward_disabled";
    public static final String FAST_REWIND_DISABLED_FACET_NAME = "fastrewind_disabled";
    public static final String SCROLLER_STATE_ATTRIBUTE = "org.richfaces.Datascroller:page";

    public void addScrollerListener(DataScrollerListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public DataScrollerListener[] getScrollerListeners() {
        return (DataScrollerListener[])this.getFacesListeners(DataScrollerListener.class);
    }

    public void removeScrollerListener(DataScrollerListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof DataScrollerEvent) {
            DataScrollerEvent dataScrollerEvent = (DataScrollerEvent)event;
            this.updateModel(dataScrollerEvent.getPage());
            FacesContext context = FacesContext.getCurrentInstance();
            AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)this, (String)this.getId());
            AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)this, (String)this.getFor());
            this.setupReRender(context);
            MethodExpression scrollerListener = this.getScrollerListener();
            if (scrollerListener != null) {
                scrollerListener.invoke(context.getELContext(), new Object[]{event});
            }
        }
    }

    public abstract MethodExpression getScrollerListener();

    public abstract void setScrollerListener(MethodExpression var1);

    public abstract void setFor(String var1);

    public abstract String getFor();

    public abstract int getFastStep();

    public abstract void setFastStep(int var1);

    public abstract boolean isRenderIfSinglePage();

    public abstract void setRenderIfSinglePage(boolean var1);

    public abstract int getMaxPages();

    public abstract void setMaxPages(int var1);

    public abstract String getSelectedStyleClass();

    public abstract void setSelectedStyleClass(String var1);

    public abstract String getSelectedStyle();

    public abstract void setSelectedStyle(String var1);

    public abstract String getEventsQueue();

    public abstract void setEventsQueue(String var1);

    public abstract boolean isAjaxSingle();

    public abstract void setAjaxSingle(boolean var1);

    public abstract int getRequestDelay();

    public abstract void setRequestDelay(int var1);

    public abstract String getTableStyleClass();

    public abstract void setTableStyleClass(String var1);

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String var1);

    public abstract void setStyle(String var1);

    public abstract String getAlign();

    public abstract void setAlign(String var1);

    public abstract String getBoundaryControls();

    public abstract void setBoundaryControls(String var1);

    public abstract String getFastControls();

    public abstract void setFastControls(String var1);

    public abstract String getStepControls();

    public abstract void setStepControls(String var1);

    public abstract String getInactiveStyleClass();

    public abstract String getInactiveStyle();

    public abstract void setInactiveStyleClass(String var1);

    public abstract void setInactiveStyle(String var1);

    public UIData getDataTable() {
        String forAttribute = this.getFor();
        if (forAttribute == null) {
            UIDatascroller forComp = this;
            while ((forComp = forComp.getParent()) != null) {
                if (!(forComp instanceof UIData)) continue;
                this.setFor(forComp.getId());
                return (UIData)forComp;
            }
            throw new FacesException("could not find dataTable for  datascroller " + this.getId());
        }
        UIComponent forComp = RendererUtils.getInstance().findComponentFor((UIComponent)this, forAttribute);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find dataTable with id '" + forAttribute + "'");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("component with id '" + forAttribute + "' must be of type " + UIData.class.getName() + ", not type " + forComp.getClass().getName());
        }
        return (UIData)forComp;
    }

    private int getFastStepOrDefault() {
        int step = this.getFastStep();
        if (step <= 0) {
            return 1;
        }
        return step;
    }

    public int getPageIndex(UIData data) {
        return this.getPageIndex();
    }

    public int getPageIndex() {
        return this.getPageIndex();
    }

    public int getPageForFacet(String facetName) {
        if (facetName == null) {
            throw new NullPointerException();
        }
        int newPage = 1;
        int pageCount = this.getPageCount();
        if (FIRST_FACET_NAME.equals(facetName)) {
            newPage = 1;
        } else if (PREVIOUS_FACET_NAME.equals(facetName)) {
            newPage = this.getPage() - 1;
        } else if (NEXT_FACET_NAME.equals(facetName)) {
            newPage = this.getPage() + 1;
        } else if (LAST_FACET_NAME.equals(facetName)) {
            newPage = pageCount > 0 ? pageCount : 1;
        } else if (FAST_FORWARD_FACET_NAME.equals(facetName)) {
            newPage = this.getPage() + this.getFastStepOrDefault();
        } else if (FAST_REWIND_FACET_NAME.equals(facetName)) {
            newPage = this.getPage() - this.getFastStepOrDefault();
        } else {
            try {
                newPage = Integer.parseInt(facetName.toString());
            }
            catch (NumberFormatException e) {
                throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (newPage >= 1 && newPage <= pageCount) {
            return newPage;
        }
        return 0;
    }

    public void setPage(String facetName) {
        int newPage = this.getPageForFacet(facetName);
        if (newPage != 0) {
            this.setPage(newPage);
        }
    }

    public int getPageCount(UIData data) {
        int pageCount;
        int rowCount = this.getRowCount(data);
        int rows = this.getRows(data);
        if (rows > 0) {
            int n = pageCount = rows <= 0 ? 1 : rowCount / rows;
            if (rowCount % rows > 0) {
                ++pageCount;
            }
            if (pageCount == 0) {
                pageCount = 1;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    public int getPageCount() {
        return this.getPageCount(this.getDataTable());
    }

    public int getRowCount(UIData data) {
        int rowCount = data.getRowCount();
        if (rowCount >= 0) {
            return rowCount;
        }
        return BinarySearch.search(data);
    }

    public int getRowCount() {
        return this.getRowCount(this.getDataTable());
    }

    public int getRows(UIData data) {
        int row = 0;
        row = data.getRows();
        if (row == 0) {
            row = this.getRowCount(data);
        }
        return row;
    }

    public int getFirstRow(UIData data) {
        return data.getFirst();
    }

    public void setFirstRow(int rows) {
        this.getDataTable().setFirst(rows);
    }

    public UIComponent getFirst() {
        return this.getFacet(FIRST_FACET_NAME);
    }

    public UIComponent getLast() {
        return this.getFacet(LAST_FACET_NAME);
    }

    public UIComponent getNext() {
        return this.getFacet(NEXT_FACET_NAME);
    }

    public UIComponent getFastForward() {
        return this.getFacet(FAST_FORWARD_FACET_NAME);
    }

    public UIComponent getFastRewind() {
        return this.getFacet(FAST_REWIND_FACET_NAME);
    }

    public UIComponent getPrevious() {
        return this.getFacet(PREVIOUS_FACET_NAME);
    }

    private static boolean isRendered(UIComponent component) {
        for (UIComponent c = component; c != null; c = c.getParent()) {
            if (c.isRendered()) continue;
            return false;
        }
        return true;
    }

    public void setupFirstRowValue() {
        UIData dataTable = this.getDataTable();
        if (this.isRendered()) {
            Integer pageCount = this.getPageCount(dataTable);
            int page = this.getPage();
            int newPage = -1;
            if (page < 1) {
                newPage = 1;
            } else if (page > pageCount) {
                int n = newPage = pageCount != 0 ? pageCount : 1;
            }
            if (newPage != -1) {
                FacesContext context = this.getFacesContext();
                Object label = MessageUtil.getLabel((FacesContext)context, (UIComponent)this);
                String formattedMessage = Messages.getMessage((String)"DATASCROLLER_PAGE_MISSING", (Object[])new Object[]{label, page, pageCount, newPage});
                log.warn((Object)formattedMessage);
                page = newPage;
                dataTable.getAttributes().put(SCROLLER_STATE_ATTRIBUTE, page);
            }
            if (UIDatascroller.isRendered((UIComponent)dataTable)) {
                dataTable.setFirst((page - 1) * this.getRows(dataTable));
            }
        }
    }

    public void setPage(int newPage) {
        this.page = newPage;
    }

    public int getPage() {
        Map attributes = this.getDataTable().getAttributes();
        Integer state = (Integer)attributes.get(SCROLLER_STATE_ATTRIBUTE);
        if (state != null) {
            return state;
        }
        if (this.page != null) {
            return this.page;
        }
        ValueExpression ve = this.getValueExpression("page");
        if (ve != null) {
            try {
                Integer pageObject = (Integer)ve.getValue(this.getFacesContext().getELContext());
                if (pageObject != null) {
                    return pageObject;
                }
                return 1;
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return 1;
    }

    private void updateModel(int newPage) {
        UIData dataTable = this.getDataTable();
        if (UIDatascroller.isRendered((UIComponent)dataTable)) {
            dataTable.setFirst((newPage - 1) * this.getRows(dataTable));
        }
        Map attributes = dataTable.getAttributes();
        attributes.put(SCROLLER_STATE_ATTRIBUTE, newPage);
        FacesContext context = this.getFacesContext();
        ValueExpression ve = this.getValueExpression("page");
        if (ve != null) {
            try {
                ve.setValue(context.getELContext(), (Object)newPage);
                attributes.remove(SCROLLER_STATE_ATTRIBUTE);
            }
            catch (ELException e) {
                Throwable result;
                String messageStr = e.getMessage();
                for (result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                    messageStr = result.getMessage();
                }
                FacesMessage message = null == messageStr ? MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                context.getExternalContext().log(message.getSummary(), result);
                context.addMessage(this.getClientId(context), message);
                context.renderResponse();
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)});
                context.getExternalContext().log(message.getSummary(), (Throwable)e);
                context.addMessage(this.getClientId(context), message);
                context.renderResponse();
            }
            catch (Exception e) {
                FacesMessage message = MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)});
                context.getExternalContext().log(message.getSummary(), (Throwable)e);
                context.addMessage(this.getClientId(context), message);
                context.renderResponse();
            }
        }
    }

    public String getFamily() {
        return "org.richfaces.Datascroller";
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.page};
    }

    public void restoreState(FacesContext context, Object object) {
        Object[] state = (Object[])object;
        super.restoreState(context, state[0]);
        this.page = (Integer)state[1];
    }

    public boolean isLocalPageSet() {
        return this.page != null;
    }

    public void resetLocalPage() {
        this.page = null;
    }

    static class BinarySearch {
        BinarySearch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int search(UIData data) {
            int rowIndex = data.getRowIndex();
            try {
                int n;
                int n2 = 1;
                int k = 2;
                while (true) {
                    data.setRowIndex(k - 1);
                    if (!data.isRowAvailable()) break;
                    n2 = k;
                    k *= 2;
                }
                while (n2 < k) {
                    int kk = Math.round((n2 + k) / 2) + 1;
                    data.setRowIndex(kk - 1);
                    if (data.isRowAvailable()) {
                        n2 = kk;
                        continue;
                    }
                    k = kk - 1;
                }
                data.setRowIndex(k - 1);
                if (data.isRowAvailable()) {
                    n = k;
                    return n;
                }
                n = 0;
                return n;
            }
            finally {
                data.setRowIndex(rowIndex);
            }
        }
    }
}

