/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.el.Expression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.ajax4jsf.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIDatascroller;
import org.richfaces.component.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataScrollerViewPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -3614288642745891577L;
    private static final Log log = LogFactory.getLog(DataScrollerViewPhaseListener.class);

    public void afterPhase(PhaseEvent event) {
    }

    private static boolean isRendered(List<UIComponent> components) {
        for (UIComponent component : components) {
            boolean rendered;
            block3: {
                rendered = false;
                try {
                    rendered = component.isRendered();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (rendered) continue;
            return false;
        }
        return true;
    }

    private void collectConnections(UIComponent component, ComponentConnections connections, LinkedList<UIComponent> parentComponents) {
        parentComponents.addLast(component);
        if (component instanceof UIDatascroller && DataScrollerViewPhaseListener.isRendered(parentComponents)) {
            UIDatascroller datascroller = (UIDatascroller)component;
            UIData dataTable = datascroller.getDataTable();
            connections.addConnection(dataTable, datascroller);
        }
        Iterator children = component.getFacetsAndChildren();
        while (children.hasNext()) {
            this.collectConnections((UIComponent)children.next(), connections, parentComponents);
        }
        parentComponents.removeLast();
    }

    private static boolean same(Object o1, Object o2) {
        if (o1 instanceof ValueExpression && o2 instanceof ValueExpression) {
            ValueExpression ve1 = (ValueExpression)o1;
            ValueExpression ve2 = (ValueExpression)o2;
            if (DataScrollerViewPhaseListener.same(ve1.getExpressionString(), ve2.getExpressionString()) && DataScrollerViewPhaseListener.same(ve1.getExpectedType(), ve2.getExpectedType())) {
                return true;
            }
        }
        return o1 != null && o1.equals(o2) || o1 == null && o2 == null;
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null) {
            ComponentConnections connections = new ComponentConnections();
            this.collectConnections((UIComponent)viewRoot, connections, new LinkedList<UIComponent>());
            Iterator<Map.Entry<UIData, List<UIDatascroller>>> entries = connections.iterator();
            while (entries.hasNext()) {
                Map.Entry<UIData, List<UIDatascroller>> entry = entries.next();
                List<UIDatascroller> scrollers = entry.getValue();
                if (scrollers.isEmpty()) continue;
                ArrayList<Integer> values = new ArrayList<Integer>(scrollers.size());
                UIData data = entry.getKey();
                UIDatascroller activeComponent = null;
                Map attributes = data.getAttributes();
                Object pageValue = attributes.get("org.richfaces.Datascroller:page");
                if (pageValue == null) {
                    boolean valid = true;
                    for (UIDatascroller datascroller : scrollers) {
                        Integer nextPageValue = null;
                        if (datascroller.isLocalPageSet()) {
                            nextPageValue = datascroller.getPage();
                            attributes.put("org.richfaces.Datascroller:page", nextPageValue);
                            datascroller.resetLocalPage();
                        } else {
                            nextPageValue = datascroller.getValueExpression("page");
                        }
                        if (!values.isEmpty() && !DataScrollerViewPhaseListener.same(values.get(values.size() - 1), nextPageValue)) {
                            valid = false;
                        }
                        values.add(nextPageValue);
                        if (nextPageValue == null) continue;
                        activeComponent = datascroller;
                        pageValue = nextPageValue;
                    }
                    if (!valid) {
                        StringBuilder builder = new StringBuilder("\n[");
                        Iterator<UIDatascroller> scrollerItr = scrollers.iterator();
                        Iterator valueItr = values.iterator();
                        while (scrollerItr.hasNext()) {
                            UIDatascroller next = scrollerItr.next();
                            builder.append(MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)next));
                            builder.append(": ");
                            Object value = valueItr.next();
                            if (value instanceof Expression) {
                                builder.append(((Expression)value).getExpressionString());
                            } else {
                                builder.append(value);
                            }
                            builder.append(scrollerItr.hasNext() ? ",\n" : "]");
                        }
                        String formattedMessage = Messages.getMessage((String)"DATASCROLLER_PAGES_DIFFERENT", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)data), builder});
                        log.error((Object)formattedMessage);
                    }
                }
                if (activeComponent == null) {
                    activeComponent = scrollers.get(scrollers.size() - 1);
                }
                if (pageValue == null) continue;
                activeComponent.setupFirstRowValue();
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ComponentConnections {
        private final Map<UIData, List<UIDatascroller>> map = new HashMap<UIData, List<UIDatascroller>>();

        private ComponentConnections() {
        }

        public void addConnection(UIData one, UIDatascroller multi) {
            List<UIDatascroller> list = this.map.get(one);
            if (list == null) {
                list = new ArrayList<UIDatascroller>(1);
                this.map.put(one, list);
            }
            list.add(multi);
        }

        public Iterator<Map.Entry<UIData, List<UIDatascroller>>> iterator() {
            return this.map.entrySet().iterator();
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.map;
        }
    }
}

