/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.apache.commons.collections.MultiHashMap;
import org.richfaces.component.Draggable;
import org.richfaces.component.Dropzone;
import org.richfaces.event.DnDEvent;

/**
 * @author Nick Belaevski - nbelaevski@exadel.com
 * created 27.12.2006
 * 
 */
final class DnDEventsExchangeMailer {
	private DnDEventsExchangeMailer() {

	}

	private static class EventInfoStructure {
		private DnDEvent dndEvent;
		private EventCallback eventCallback;
		
		private Object type;
		private Object value;
		
		public EventInfoStructure(DnDEvent dndEvent,
				EventCallback eventCallback, Object type, Object value) {
			super();
			this.dndEvent = dndEvent;
			this.eventCallback = eventCallback;
			this.type = type;
			this.value = value;
		}

	}

	static abstract class EventCallback {
		abstract void processEvent(DnDEvent dndEvent, UIComponent source, FacesContext facesContext, Object type, Object value);
	}

	static DnDEventsExchangeMailer getInstance(FacesContext facesContext) {
		synchronized (facesContext) {
			Map requestMap = facesContext.getExternalContext().getRequestMap();

			String attrName = DnDEventsExchangeMailer.class.getName();
			DnDEventsExchangeMailer instance;
			if ((instance = (DnDEventsExchangeMailer) requestMap.get(attrName)) == null) {
				instance = new DnDEventsExchangeMailer();

				requestMap.put(attrName, instance);
			}

			return instance;
		}
	}

	private MultiHashMap queuedMap = new MultiHashMap();

	private Map components = new HashMap();

	private void processEvent(UIComponent source, FacesContext facesContext, DnDEvent dndEvent, EventCallback callback, Object type, Object value) {
		if (callback != null) {
			callback.processEvent(dndEvent, source, facesContext, type, value); 
		}
	}

	public void mailEvent(String sourceId, UIComponent target, FacesContext facesContext, DnDEvent dndEvent, 
			EventCallback callback, Object type, Object value, boolean isDraggable) {
		
		//we should queue event right now to preserve row key if its generator
		//is nested in UIData...
		dndEvent.queue();
		
		UIComponent component = (UIComponent) components.get(sourceId);
		String targetId = target.getClientId(facesContext);
		
		if (component == null) {
			//component with that sourceId have never mailed anything before - wait
			queuedMap.put(sourceId, new EventInfoStructure(dndEvent, callback, type, value));
			components.put(targetId, target);
		} else {
			//check queued mail lists for current component
			List queue = (List) queuedMap.get(targetId);
			if (queue != null) {
				Iterator iterator = queue.iterator();
				if (iterator.hasNext()) {
					EventInfoStructure eventInfo = (EventInfoStructure) iterator.next();
					
					Draggable draggable;
					Dropzone dropzone;
					
					Object acceptedTypes;
					Object dragType;

					if (isDraggable) {
						draggable = (Draggable) target;
						dropzone = (Dropzone) component;
						
						acceptedTypes = eventInfo.type;
						dragType = type;
					} else {
						draggable = (Draggable) component;
						dropzone = (Dropzone) target;
						
						acceptedTypes = type;
						dragType = eventInfo.type;
					}

					if (DnDValidator.validateAcceptTypes(facesContext, 
							draggable, dropzone, 
							dragType, acceptedTypes)) {
						

						processEvent(target, facesContext, eventInfo.dndEvent, eventInfo.eventCallback, 
								type, value);

						//we know the component - process event now
						processEvent(component, facesContext, dndEvent, callback, 
								eventInfo.type, eventInfo.value);

					} else {
						dndEvent.invalidate();
						
						eventInfo.dndEvent.invalidate();
					}
					
					iterator.remove();
				}
				
				if (!iterator.hasNext()) {
					queuedMap.remove(targetId);
				}
			}
		}
	}

}

