package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIRichMessage;

public class HtmlRichMessage extends UIRichMessage{

final public static  String COMPONENT_FAMILY = "org.richfaces.component.RichMessage";

final public static  String COMPONENT_TYPE = "org.richfaces.component.RichMessage";

/*
* CSS style class to apply to any message with a severity class of "ERROR"
*/
private  String _errorClass = null;

/*
* CSS style class to apply to any message label with a severity class of "ERROR"
*/
private  String _errorLabelClass = null;

/*
* CSS style class to apply to any message marker with a severity class of "ERROR"
*/
private  String _errorMarkerClass = null;

/*
* CSS style class to apply to any message with a severity class of "FATAL"
*/
private  String _fatalClass = null;

/*
* CSS style class to apply to any message label with a severity class of "FATAL"
*/
private  String _fatalLabelClass = null;

/*
* CSS style class to apply to any message marker with a severity class of "FATAL"
*/
private  String _fatalMarkerClass = null;

/*
* CSS style class to apply to any message with a severity class of "INFO"
*/
private  String _infoClass = null;

/*
* CSS style class to apply to any message label with a severity class of "INFO"
*/
private  String _infoLabelClass = null;

/*
* CSS style class to apply to any message marker with a severity class of "INFO"
*/
private  String _infoMarkerClass = null;

/*
* Flag for mark all child components to non-transient. If "true", all children components will be set to non-transient state and keep in saved components tree.
				For output in self-renderer region all content (By default, all content in &amp;lt;f:verbatim&amp;gt; tags and non-jsf elements in facelets, marked as transient - since, self-rendered ajax regions don't plain output for ajax processing).
*/
private  boolean _keepTransient = false;

private  boolean _keepTransientSet = false;

/*
* CSS style class to apply to label
*/
private  String _labelClass = null;

/*
* A comma-separated list of messages categories which should be displayed. Default value is "ALL".
*/
private  String _level = null;

/*
* CSS style class to apply to marker
*/
private  String _markerClass = null;

/*
* CSS style(s) is/are to be applied to marker when this component is rendered
*/
private  String _markerStyle = null;

/*
* Attribute should define the label to be displayed when no message appears
*/
private  String _passedLabel = null;

/*
* The CSS style for message
*/
private  String _style = null;

/*
* Space-separated list of CSS style class(es) to be applied when this element is rendered.  This value must be passed through as the "class" attribute on generated markup
*/
private  String _styleClass = null;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;

/*
* Flag indicating whether the detail portion of the message should be displayed as a tooltip.  Default value is "false".
*/
private  boolean _tooltip = false;

private  boolean _tooltipSet = false;

/*
* CSS style class to apply to any message with a severity class of "WARN"
*/
private  String _warnClass = null;

/*
* CSS style class to apply to any message label with a severity class of "WARN"
*/
private  String _warnLabelClass = null;

/*
* CSS style class to apply any message marker with a severity class of "WARN"
*/
private  String _warnMarkerClass = null;


public HtmlRichMessage(){
setRendererType("org.richfaces.RichMessageRenderer");
}

public String getErrorClass(){
	if (this._errorClass != null) {
		return this._errorClass;
	}
	ValueExpression ve = getValueExpression("errorClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setErrorClass(String _errorClass){
this._errorClass = _errorClass;
}

public String getErrorLabelClass(){
	if (this._errorLabelClass != null) {
		return this._errorLabelClass;
	}
	ValueExpression ve = getValueExpression("errorLabelClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setErrorLabelClass(String _errorLabelClass){
this._errorLabelClass = _errorLabelClass;
}

public String getErrorMarkerClass(){
	if (this._errorMarkerClass != null) {
		return this._errorMarkerClass;
	}
	ValueExpression ve = getValueExpression("errorMarkerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setErrorMarkerClass(String _errorMarkerClass){
this._errorMarkerClass = _errorMarkerClass;
}

public String getFatalClass(){
	if (this._fatalClass != null) {
		return this._fatalClass;
	}
	ValueExpression ve = getValueExpression("fatalClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFatalClass(String _fatalClass){
this._fatalClass = _fatalClass;
}

public String getFatalLabelClass(){
	if (this._fatalLabelClass != null) {
		return this._fatalLabelClass;
	}
	ValueExpression ve = getValueExpression("fatalLabelClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFatalLabelClass(String _fatalLabelClass){
this._fatalLabelClass = _fatalLabelClass;
}

public String getFatalMarkerClass(){
	if (this._fatalMarkerClass != null) {
		return this._fatalMarkerClass;
	}
	ValueExpression ve = getValueExpression("fatalMarkerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFatalMarkerClass(String _fatalMarkerClass){
this._fatalMarkerClass = _fatalMarkerClass;
}

public String getInfoClass(){
	if (this._infoClass != null) {
		return this._infoClass;
	}
	ValueExpression ve = getValueExpression("infoClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setInfoClass(String _infoClass){
this._infoClass = _infoClass;
}

public String getInfoLabelClass(){
	if (this._infoLabelClass != null) {
		return this._infoLabelClass;
	}
	ValueExpression ve = getValueExpression("infoLabelClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setInfoLabelClass(String _infoLabelClass){
this._infoLabelClass = _infoLabelClass;
}

public String getInfoMarkerClass(){
	if (this._infoMarkerClass != null) {
		return this._infoMarkerClass;
	}
	ValueExpression ve = getValueExpression("infoMarkerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setInfoMarkerClass(String _infoMarkerClass){
this._infoMarkerClass = _infoMarkerClass;
}

public boolean isKeepTransient(){
	if (this._keepTransientSet) {
	    return (this._keepTransient);
	}
	ValueExpression ve = getValueExpression("keepTransient");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._keepTransient);
	    }
	    
	    return value;
	} else {
	    return (this._keepTransient);
	}

}

public void setKeepTransient(boolean _keepTransient){
this._keepTransient = _keepTransient;
this._keepTransientSet = true;
}

public String getLabelClass(){
	if (this._labelClass != null) {
		return this._labelClass;
	}
	ValueExpression ve = getValueExpression("labelClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLabelClass(String _labelClass){
this._labelClass = _labelClass;
}

public String getLevel(){
	if (this._level != null) {
		return this._level;
	}
	ValueExpression ve = getValueExpression("level");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "ALL";
	

}

public void setLevel(String _level){
this._level = _level;
}

public String getMarkerClass(){
	if (this._markerClass != null) {
		return this._markerClass;
	}
	ValueExpression ve = getValueExpression("markerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setMarkerClass(String _markerClass){
this._markerClass = _markerClass;
}

public String getMarkerStyle(){
	if (this._markerStyle != null) {
		return this._markerStyle;
	}
	ValueExpression ve = getValueExpression("markerStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setMarkerStyle(String _markerStyle){
this._markerStyle = _markerStyle;
}

public String getPassedLabel(){
	if (this._passedLabel != null) {
		return this._passedLabel;
	}
	ValueExpression ve = getValueExpression("passedLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setPassedLabel(String _passedLabel){
this._passedLabel = _passedLabel;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public boolean isTooltip(){
	if (this._tooltipSet) {
	    return (this._tooltip);
	}
	ValueExpression ve = getValueExpression("tooltip");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._tooltip);
	    }
	    
	    return value;
	} else {
	    return (this._tooltip);
	}

}

public void setTooltip(boolean _tooltip){
this._tooltip = _tooltip;
this._tooltipSet = true;
}

public String getWarnClass(){
	if (this._warnClass != null) {
		return this._warnClass;
	}
	ValueExpression ve = getValueExpression("warnClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setWarnClass(String _warnClass){
this._warnClass = _warnClass;
}

public String getWarnLabelClass(){
	if (this._warnLabelClass != null) {
		return this._warnLabelClass;
	}
	ValueExpression ve = getValueExpression("warnLabelClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setWarnLabelClass(String _warnLabelClass){
this._warnLabelClass = _warnLabelClass;
}

public String getWarnMarkerClass(){
	if (this._warnMarkerClass != null) {
		return this._warnMarkerClass;
	}
	ValueExpression ve = getValueExpression("warnMarkerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setWarnMarkerClass(String _warnMarkerClass){
this._warnMarkerClass = _warnMarkerClass;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[25];
state[0] = super.saveState(context);
state[1] = _errorClass;
state[2] = _errorLabelClass;
state[3] = _errorMarkerClass;
state[4] = _fatalClass;
state[5] = _fatalLabelClass;
state[6] = _fatalMarkerClass;
state[7] = _infoClass;
state[8] = _infoLabelClass;
state[9] = _infoMarkerClass;
state[10] = Boolean.valueOf(_keepTransient);
state[11] = Boolean.valueOf(_keepTransientSet);
state[12] = _labelClass;
state[13] = _level;
state[14] = _markerClass;
state[15] = _markerStyle;
state[16] = _passedLabel;
state[17] = _style;
state[18] = _styleClass;
state[19] = _title;
state[20] = Boolean.valueOf(_tooltip);
state[21] = Boolean.valueOf(_tooltipSet);
state[22] = _warnClass;
state[23] = _warnLabelClass;
state[24] = _warnMarkerClass;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_errorClass = (String)states[1];;
		_errorLabelClass = (String)states[2];;
		_errorMarkerClass = (String)states[3];;
		_fatalClass = (String)states[4];;
		_fatalLabelClass = (String)states[5];;
		_fatalMarkerClass = (String)states[6];;
		_infoClass = (String)states[7];;
		_infoLabelClass = (String)states[8];;
		_infoMarkerClass = (String)states[9];;
		_keepTransient = ((Boolean)states[10]).booleanValue();
		_keepTransientSet = ((Boolean)states[11]).booleanValue();
		_labelClass = (String)states[12];;
		_level = (String)states[13];;
		_markerClass = (String)states[14];;
		_markerStyle = (String)states[15];;
		_passedLabel = (String)states[16];;
		_style = (String)states[17];;
		_styleClass = (String)states[18];;
		_title = (String)states[19];;
		_tooltip = ((Boolean)states[20]).booleanValue();
		_tooltipSet = ((Boolean)states[21]).booleanValue();
		_warnClass = (String)states[22];;
		_warnLabelClass = (String)states[23];;
		_warnMarkerClass = (String)states[24];;
	
}

}
