package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIJQuery;

public class HtmlJQuery extends UIJQuery{

final public static  String COMPONENT_FAMILY = "org.richfaces.JQuery";

final public static  String COMPONENT_TYPE = "org.richfaces.JQuery";

/*
* The name of a function that will be generated to execute a query. The "name" attribute is required 
			    if "timing" attribute equals to "onJScall"
*/
private  String _name = null;

/*
* The query string that is executed for a given selector.
*/
private  String _query = null;

/*
* Selector for query. The "selector" attribute uses defined by w3c
			    consortium syntax for CSS rule selector with some jQuery extensions.
*/
private  String _selector = null;

/*
* The attribute that defines when to perform the query. The possible values are "immediate","onload" and "onJScall". 
			 "immediate" performs the query right away. "onload" adds the task to the
			 time when a document is loaded (the DOM tree is created). "onJScall" allows to invoke the 
			 query by Javascipt function name defined with "name" attribute. The default value is 
			 "immediate".
*/
private  String _timing = null;


public HtmlJQuery(){
setRendererType("org.richfaces.JQueryRenderer");
}

public String getName(){
	if (this._name != null) {
		return this._name;
	}
	ValueExpression ve = getValueExpression("name");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setName(String _name){
this._name = _name;
}

public String getQuery(){
	if (this._query != null) {
		return this._query;
	}
	ValueExpression ve = getValueExpression("query");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setQuery(String _query){
this._query = _query;
}

public String getSelector(){
	if (this._selector != null) {
		return this._selector;
	}
	ValueExpression ve = getValueExpression("selector");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setSelector(String _selector){
this._selector = _selector;
}

public String getTiming(){
	if (this._timing != null) {
		return this._timing;
	}
	ValueExpression ve = getValueExpression("timing");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "immediate";
	

}

public void setTiming(String _timing){
this._timing = _timing;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[5];
state[0] = super.saveState(context);
state[1] = _name;
state[2] = _query;
state[3] = _selector;
state[4] = _timing;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_name = (String)states[1];;
		_query = (String)states[2];;
		_selector = (String)states[3];;
		_timing = (String)states[4];;
	
}

}
