package org.ajax4jsf.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UIAjaxOutputPanel;

public class HtmlAjaxOutputPanel extends UIAjaxOutputPanel{

public static final  String COMPONENT_FAMILY = "javax.faces.Panel";

public static final  String COMPONENT_TYPE = "org.ajax4jsf.OutputPanel";

/*
* Defines, whether the content of this component must be
				(or not) included in AJAX response created by parent
				AJAX Container, even if it is not forced by reRender
				list of ajax action. Ignored if component marked to
				output by Ajax action. Default value is "false".
*/
private  boolean _ajaxRendered = false;

private  boolean _ajaxRenderedSet = false;

/*
* Direction indication for text that does not inherit
			directionality. Valid values are "LTR" (left-to-right)
			and "RTL" (right-to-left)
*/
private  String _dir = null;

/*
* Flag to mark all child components to non-transient. If
            true, all children components will be set to non-transient state
            and keep in saved components tree. For output in self-renderer
            region all content ( By default, all content in &amp;lt;f:verbatim&amp;gt;
            tags and non-jsf elements in facelets, marked as transient -
            since, self-rendered ajax regions don't plain output for ajax
            processing ).
*/
private  boolean _keepTransient = true;

private  boolean _keepTransientSet = false;

/*
* Code describing the language used in the generated markup for this component
*/
private  String _lang = null;

/*
* HTML layout for generated markup. Possible values: "block"
            for generating an HTML &amp;lt;div&amp;gt; element, "inline" for
            generating an HTML &amp;lt;span&amp;gt; element, and "none" for generating
            no HTML element. There is a minor exception for the "none" case
            where a child element has the property "rendered" set to "false".
            In this case, we create an empty &amp;lt;span&amp;gt; element with same ID
            as the child element to use as a placeholder for later
            processing.
*/
private  String _layout = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;


public HtmlAjaxOutputPanel(){
setRendererType("org.ajax4jsf.components.AjaxOutputPanelRenderer");
}

public boolean isAjaxRendered(){
	if (this._ajaxRenderedSet) {
	    return (this._ajaxRendered);
	}
	ValueExpression ve = getValueExpression("ajaxRendered");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxRendered);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxRendered);
	}

}

public void setAjaxRendered(boolean _ajaxRendered){
this._ajaxRendered = _ajaxRendered;
this._ajaxRenderedSet = true;
}

public String getDir(){
	if (this._dir != null) {
		return this._dir;
	}
	ValueExpression ve = getValueExpression("dir");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDir(String _dir){
this._dir = _dir;
}

public boolean isKeepTransient(){
	if (this._keepTransientSet) {
	    return (this._keepTransient);
	}
	ValueExpression ve = getValueExpression("keepTransient");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._keepTransient);
	    }
	    
	    return value;
	} else {
	    return (this._keepTransient);
	}

}

public void setKeepTransient(boolean _keepTransient){
this._keepTransient = _keepTransient;
this._keepTransientSet = true;
}

public String getLang(){
	if (this._lang != null) {
		return this._lang;
	}
	ValueExpression ve = getValueExpression("lang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLang(String _lang){
this._lang = _lang;
}

public String getLayout(){
	if (this._layout != null) {
		return this._layout;
	}
	ValueExpression ve = getValueExpression("layout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "inline";
	

}

public void setLayout(String _layout){
this._layout = _layout;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[21];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_ajaxRendered);
state[2] = Boolean.valueOf(_ajaxRenderedSet);
state[3] = _dir;
state[4] = Boolean.valueOf(_keepTransient);
state[5] = Boolean.valueOf(_keepTransientSet);
state[6] = _lang;
state[7] = _layout;
state[8] = _onclick;
state[9] = _ondblclick;
state[10] = _onkeydown;
state[11] = _onkeypress;
state[12] = _onkeyup;
state[13] = _onmousedown;
state[14] = _onmousemove;
state[15] = _onmouseout;
state[16] = _onmouseover;
state[17] = _onmouseup;
state[18] = _style;
state[19] = _styleClass;
state[20] = _title;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_ajaxRendered = ((Boolean)states[1]).booleanValue();
		_ajaxRenderedSet = ((Boolean)states[2]).booleanValue();
		_dir = (String)states[3];;
		_keepTransient = ((Boolean)states[4]).booleanValue();
		_keepTransientSet = ((Boolean)states[5]).booleanValue();
		_lang = (String)states[6];;
		_layout = (String)states[7];;
		_onclick = (String)states[8];;
		_ondblclick = (String)states[9];;
		_onkeydown = (String)states[10];;
		_onkeypress = (String)states[11];;
		_onkeyup = (String)states[12];;
		_onmousedown = (String)states[13];;
		_onmousemove = (String)states[14];;
		_onmouseout = (String)states[15];;
		_onmouseover = (String)states[16];;
		_onmouseup = (String)states[17];;
		_style = (String)states[18];;
		_styleClass = (String)states[19];;
		_title = (String)states[20];;
	
}

}
