/**
 * 
 */
package org.richfaces.renderkit.html;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils.HTML;

/**
 * @author Maksim Kaszynski
 *
 */
public abstract class SortIconRenderer extends RendererBase {
	
	
	public void renderAscIcon(FacesContext context, UIComponent component) throws IOException{
		renderFacetOrIcon(context, component, "ascIcon", "dr-sdt-sort-asc");
	}

	public void renderDescIcon(FacesContext context, UIComponent component) throws IOException{
		renderFacetOrIcon(context, component, "descIcon", "dr-sdt-sort-desc");
	}
	
	private void renderFacetOrIcon(FacesContext context, UIComponent component, String facetName, String clazz) throws IOException{
		UIComponent facet = component.getFacet(facetName);
		if (facet != null) {
			renderChild(context, facet);
		} else {
			renderIcon(context.getResponseWriter(), clazz);
		}
	}
	
	private void renderIcon(ResponseWriter writer, String clazz) throws IOException {
		writer.startElement(HTML.DIV_ELEM, null);
		if (clazz != null) {
			writer.writeAttribute(HTML.class_ATTRIBUTE, clazz, null);
		}
		writer.endElement(HTML.DIV_ELEM);
	}
}
