if(!window.Richfaces) window.Richfaces = {};
Richfaces.ComboBoxList = Class.create();
Richfaces.ComboBoxList.prototype = {
	
	initialize: function(listId, parentListId, selectFirstOnUpdate, classes, width, height, itemsText, onlistcall, fieldId, shadowId,decorationId,
						 showDelay, hideDelay) {
		 
		this.list = $(listId);
		this.listParent = $(parentListId);
		//this.iframe = $(iframeId);
		this.iframe = null;
		this.fieldElem = $(fieldId);
		this.itemsText = itemsText;
		this.shadowElem = $(shadowId);
		this.onlistcall = onlistcall; 
		
		if (this.onlistcall) {
			this.listParent.observe("rich:onlistcall", this.onlistcall);
		}
		
		this.selectFirstOnUpdate = selectFirstOnUpdate;
		this.classes = classes;
		this.isList = false;
		
		this.defaultRowsAmount = 15; 
		
		this.selectedItem = null;
		this.activeItem = null;
		
		this.showDelay = showDelay;
		this.hideDelay = hideDelay;
		
		this.width = width;
		this.height = height;
		
		this.initDimensions();
		
	},
	
	initDimensions : function() {
		this.listParent.style.visibility = "hidden";
		this.listParent.show();
		
		var el = this.listParent.childNodes[1].firstChild;
		this.LAYOUT_BORDER_V = Richfaces.getBorderWidth(el, "tb");
		this.LAYOUT_BORDER_H = Richfaces.getBorderWidth(el, "lr");
		this.LAYOUT_PADDING_V = Richfaces.getPaddingWidth(el, "tb");
		this.LAYOUT_PADDING_H = Richfaces.getPaddingWidth(el, "lr");
				
		this.listParent.hide();
		this.listParent.style.visibility = "visible";
	},
	
	createDefaultList : function() {
		var items = new Array();
		for (var i = 0; i < this.itemsText.length; i++) {
			items.push(this.createItem(this.itemsText[i], this.classes.ITEM.NORMAL));
		}
		this.createNewList(items);
	},
	
	getItems : function() {
		return this.list.childNodes;
	},
	
	showWithDelay : function() {
		this.show();
		/*setTimeout(function(){
			this.show();
		}.bind(this), this.showDelay);*/
	},
	
	show : function() {
		this.fieldDimensions = Richfaces.ComboBoxList.getElemXY(this.fieldElem);
		this.fieldDimensions.height = this.fieldElem.parentNode.offsetHeight;

		this.setSize();
		this.setPosition(this.fieldDimensions.top, this.fieldDimensions.left, this.fieldDimensions.height);
		
		if (this.selectedItem) {
			//was created new item list, so necessary to recreate selectedItem
			this.doSelectItem(this.findItemBySubstr(this.selectedItem.innerHTML.unescapeHTML()));
		}
		
				
		var items = this.getItems(); 
		if (items.length != 0) {
			this.listParent.show();
			if (this.iframe) {
				this.iframe.show();
			}
		}
		
		if (this.selectFirstOnUpdate) {
			var curItems = this.getItems();
			if (curItems.length != 0) {
				if (this.selectedItem) {
					this.doActiveItem(this.selectedItem);
				} else {
					this.doActiveItem(curItems[0]);	
				}
			}
		}
			
		this.listParent.fire("rich:onlistcall", {});
		
	},
	
	hideWithDelay : function() {
		/*setTimeout(function(){
			this.hide();
		}.bind(this), this.hideDelay);*/
		this.hide();
	},
	
	hide : function() {
		this.resetState();
		if (this.iframe) {
			this.iframe.hide();			
		}
		
		var component = this.listParent.parentNode;
		component.style.position = "static";
		component.style.zIndex = 0;
		
		this.listParent.hide();
	},
	
	visible : function() {
		return this.listParent.visible();
	},
	
	setSize : function() {
		var height = this.height;
		
		var currentItemsHeight;
		var rowsAmount;
		var item = this.getItems()[0];
		var actItPars = 0;
		if (item) {
			//FIXME
			this.listParent.style.visibility = "hidden";
			this.listParent.show();
			
		
					
			var itemHeight = item.offsetHeight;
			
			this.listParent.hide();
			this.listParent.style.visibility = "visible";
			
			rowsAmount = this.getItems().length;
			currentItemsHeight = itemHeight * rowsAmount;
			
			if (this.height) {
				if (parseInt(this.height) > currentItemsHeight) {
					height = currentItemsHeight;
				}
			} else {
				if (rowsAmount < this.defaultRowsAmount) {
					height = currentItemsHeight;
				} else {
					height = itemHeight * this.defaultRowsAmount;
				}
			}
			if (Prototype.Browser.IE) {
				height = parseInt(height) + this.LAYOUT_BORDER_V + this.LAYOUT_PADDING_V;
			}
			height = parseInt(height) + "px";
			this.list.style.height = height;
			if (this.shadowElem) {
				if (!Richfaces.browser.isIE6) {
					// shadow offset
					this.shadowElem.style.width = (parseInt(this.width) + 7) + "px";
					this.shadowElem.style.height = (parseInt(height) + 9)+ "px";
				} else {
					this.shadowElem.style.visibility = "hidden";
				}
			}
			if (this.iframe) {
				this.iframe.style.height = height;			
			}
			this.setWidth(this.width);
		}
	},
	
	setWidth : function(width) {
		var positionElem = this.listParent.childNodes[1];
		var combobox = this.listParent.parentNode;
		//positionElem.style.width = width;
		var correction = parseInt(width) - Richfaces.getBorderWidth(positionElem.firstChild, "lr") - Richfaces.getPaddingWidth(positionElem.firstChild, "lr") + "px";
		this.list.style.width = correction;
		combobox.style.width = correction;
		if (this.iframe) {
			this.iframe.style.width = correction;			
		}
	},
	
	setPosition : function(fieldTop, fieldLeft, fieldHeight) {
		var component = this.listParent.parentNode;
		component.style.position = "relative";
		component.style.zIndex = 2;
		
		
		var docHeight = Richfaces.getDocumentHeight();
		var comBottom = fieldTop + fieldHeight - document.documentElement.scrollTop;
		var listHeight = parseInt(this.list.style.height) + Richfaces.getBorderWidth(this.list.parentNode, "tb");
		
		//var top = 0 ;//= -4;
		var top = fieldHeight;
		var topIframe = comBottom;
		
		if (parseInt(listHeight) > (docHeight - comBottom)) {
			if (fieldTop > (docHeight - comBottom)) {
				top = 0 - parseInt(listHeight);
				topIframe = top;
				//var upPos = true;
			}
		} 
		
		this.listParent.style.top = top + "px";
		this.listParent.style.left = 0 + "px";
		
		/*if (!upPos) {
			top = Richfaces.ComboBoxList.getElemXY(this.listParent).top + this.fieldDimensions.height;
		}*/
		if (this.iframe) {
			this.iframe.style.top = topIframe + "px";
			this.iframe.style.left = 0 + "px";
		}
	},
	
	scrolling : function(event) {
		var increment;
		var scrollElem = this.list;
		var listTop = Richfaces.ComboBoxList.getElemXY(scrollElem).top;
		var scrollTop = scrollElem.scrollTop;
		var itemTop = Richfaces.ComboBoxList.getElemXY(this.activeItem).top;
		
		if ((event.keyCode == Event.KEY_UP) || (event.keyCode == 33)) {
			increment = (itemTop - scrollTop) - listTop;
			if (increment < 0) {
				scrollElem.scrollTop += increment;			
			}
		} else if ((event.keyCode == Event.KEY_DOWN) || (event.keyCode == 34)) {
			var itemBottom = itemTop + this.activeItem.offsetHeight;
			var increment = (itemBottom - scrollTop) - (listTop + scrollElem.clientHeight);
			if (increment > 0) {
				scrollElem.scrollTop += increment;			
			} 
		}
		Event.stop(event);
	},
	
	scrollingUpToItem : function(item) {
		var scrollElem = this.list;
		var increment = (Richfaces.ComboBoxList.getElemXY(item).top - scrollElem.scrollTop) - Richfaces.ComboBoxList.getElemXY(scrollElem).top;
		scrollElem.scrollTop += increment;
	},
	
	/* items library*/
	doActiveItem : function(item) {
		if (this.activeItem) {
			this.doNormalItem(this.activeItem);			
		}
		
		this.activeItem = item;
		
		this.changeItem(item, this.classes.ITEM.SELECTED);
	},
	
	doNormalItem : function(item) {
		this.activeItem = null;
		this.changeItem(item, this.classes.ITEM.NORMAL);
	},
	
	doSelectItem : function(item) {
		this.selectedItem = item;
	},
	
	changeItem : function(item, className) {
		item.className = className;
	},
	
	getEventItem : function(event) {
		var item = Event.findElement(event, "span");
		/*if ((item == null) || (item.id == this.listParent.id) || (item.id == this.list.id)) {
			return;
		}*/
		return item;
	},
	
	moveActiveItem : function(event) {
		var item = this.activeItem;
		if (event.keyCode == Event.KEY_UP) {
			if (!this.activeItem) {
				if (!this.selectFirstOnUpdate) {
					var curItems = this.getItems();
					if (curItems != null && curItems.length != 0) {
						this.doActiveItem(curItems[curItems.length - 1]);
						this.scrollingUpToItem(curItems[curItems.length - 1]);
					}
				}
				return;
			}
			var prevItem = item.previousSibling;
			if (prevItem) {
				this.itemsRearrangement(item, prevItem);
			}
		} else if (event.keyCode == Event.KEY_DOWN) {
			if (!this.activeItem) {
				if (!this.selectFirstOnUpdate) {
					var curItems = this.getItems();
					if (curItems != null && curItems.length != 0) {
						this.doActiveItem(curItems[0]);
						this.scrollingUpToItem(curItems[0]);
					}
				}
				return;
			}
			var nextItem = item.nextSibling;
			if (nextItem) {
				this.itemsRearrangement(item, nextItem);				
			}
		}
		this.scrolling(event);
	},
	
	itemsRearrangement : function(item, newItem) {
		this.doActiveItem(newItem);
	},
	
	resetState : function() {
		var tempList = this.list.cloneNode(false);
		this.listParent.childNodes[1].firstChild.replaceChild(tempList, this.list);
		this.list = $(tempList.id);
		this.activeItem = null;
		this.isList = false;
	},
	
	dataFilter : function(text) {
		this.createNewList(this.getFilteredItems(text));	
	},
	
	getFilteredItems : function(text) {
		var items = new Array();
		for (var i = 0; i < this.itemsText.length; i++) {
			var itText = this.itemsText[i];
			if (itText.substr(0, text.length).toLowerCase() == text.toLowerCase()) { //FIXME: to optimaize
				items.push(this.createItem(itText, this.classes.ITEM.NORMAL));
			}
		}
		return items;
	},
	
	findItemBySubstr : function(substr) {
		var items = this.getItems();
		for (var i = 0; i < items.length; i++) {
			var item = items[i]
			var itText = item.innerHTML.unescapeHTML();
			if (itText.substr(0, substr.length).toLowerCase() == substr.toLowerCase()) { //FIXME: to optimaize
				return item;
			}
		}
	},
	
	createNewList : function(items) {
		//FIX for FF
		if (this.selectedItem) {
			var text = this.selectedItem.innerHTML;			
		}
		this.list.innerHTML = items.join("");
		//was created new item list, so necessary to recreate selectedItem
		if (this.selectedItem) {
			var item = this.findItemBySubstr(text);
			if (item) {
				this.doSelectItem(item);
			}
		}
	},
	
	createItem : function(text, className) {
		var escapedText = text.escapeHTML();
		return "<span class=\"" + className+ "\">" + escapedText + "</span>";
	},
	
	createIframe : function(parentElem, width, comboboxId, classes) {
		var iframe = document.createElement("iframe");
		
		iframe.id = "iframe" + comboboxId;
		
		iframe.style.display = "none";
		iframe.frameBorder="0";
		iframe.scrolling="no";
//		iframe.style.backgroundColor="#FFFFFF";
		
		iframe.style.width = width;
//		iframe.style.zIndex = "2";
		
		iframe.className = classes;
		
		parentElem.appendChild(iframe);
		this.iframe = $(iframe.id);
	}
}

Richfaces.ComboBoxList.getElemXY = function(elem) {
    
    // for FF support
    /*var originalVisibility = elem.style.visibility;
    var originalPosition = elem.style.position;
	var originalDisplay = elem.style.display;
	      	
    elem.style.visibility = 'hidden';
    elem.style.position = 'absolute';      
    elem.style.display = 'block';*/
    
    var x = elem.offsetLeft;
    var y = elem.offsetTop;
    
    		 	
    //for (var parent = Element.getOffsetParent(elem); parent != document.body; parent = Element.getOffsetParent(parent)) {
    for (var parent = elem.offsetParent; parent; parent = parent.offsetParent) {
        x += parent.offsetLeft;
        y += parent.offsetTop;
    }
	
	/*elem.style.display = originalDisplay;
	elem.style.visibility = originalVisibility;
	elem.style.position = originalPosition;*/ 
	
	return {left: x, top: y};
}
