/**
 * 
 */
package org.richfaces.event.sort;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.richfaces.component.UIScrollableDataTable;
import org.richfaces.component.util.ColumnUtil;
import org.richfaces.model.SortField;
import org.richfaces.model.SortOrder;

/**
 * Implementation of sortListener for multi-column sorting
 * @author Maksim Kaszynski
 *
 */
public class MultiColumnSortListener extends AbstractSortListener {

	public static final MultiColumnSortListener INSTANCE = new MultiColumnSortListener();
	
	private MultiColumnSortListener() {
	}
	
	/* (non-Javadoc)
	 * @see org.richfaces.event.sort.SortListener#processSort(org.richfaces.event.sort.SortEvent)
	 */
	public void processSort(SortEvent e) {
		UIScrollableDataTable grid = (UIScrollableDataTable) e.getComponent();
		int columnIndex = e.getSortColumn();

		UIComponent column = 
			grid.getChildren().get(columnIndex);
		
		String name = ColumnUtil.getColumnSorting(column);
		
		SortOrder sortOrder = grid.getSortOrder();
		if (sortOrder == null) {
			sortOrder = new SortOrder();
			grid.setSortOrder(sortOrder);
			
			if (grid.getValueExpression("sortOrder") != null) {
				grid.getValueExpression("sortOrder").setValue(FacesContext.getCurrentInstance().getELContext(), sortOrder);
			}
			
		}
		
		Boolean suggested = e.getSuggestedOrder();
		
		SortField[] fields = sortOrder.getFields();
		
		if (fields == null) {
			//If no sorting was applied at all, set sorting to current
			fields = new SortField[] {new SortField(name, columnIndex, nextSortOrder(null, suggested))};
		} else {
			
			List<SortField> newFields = new LinkedList<SortField>(Arrays.asList(fields));
			SortField newField = null;
			
			for (Iterator<SortField> iterator = newFields.iterator(); iterator.hasNext() && newField == null; ) {
				SortField sortField = (SortField) iterator.next();
				if (sortField.getIndex() == columnIndex || 
						(sortField.getName() != null && 
								name != null && 
								name.equals(sortField.getName()))) {
					
					Boolean asc = sortField.getAscending();
					
					newField = new SortField(name, columnIndex, nextSortOrder(asc, suggested));
					iterator.remove();
					
				}				
			}
			
			if (newField == null) {
				
				newField = new SortField(name, columnIndex, nextSortOrder(null, suggested));
			}
			
			newFields.add(newField);
			fields = (SortField[]) newFields.toArray(new SortField[newFields.size()]);
		}
		
		sortOrder.setFields(fields);
	}
	

}
