package org.ajax4jsf.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UIAjaxRegion;

public class HtmlPage extends UIAjaxRegion{

final static public  String COMPONENT_FAMILY = "org.ajax4jsf.components.AjaxRegion";

final static public  String COMPONENT_TYPE = "org.ajax4jsf.components.Page";

/*
* Set custom mime content type to response
*/
private  String _contentType = null;

/*
* Direction indication for text that does not inherit
			directionality. Valid values are "LTR" (left-to-right)
			and "RTL" (right-to-left)
*/
private  String _dir = null;

/*
* Page layout format ( html, xhtml, html-transitional, html-3.2 ) for encoding DOCTYPE, namespace and Content-Type definitions
*/
private  String _format = null;

/*
* Code describing the language used in the generated markup for this component
*/
private  String _lang = null;

/*
* Set html element default namespace
*/
private  String _namespace = null;

/*
* JavaScript code to execute on a page load.
*/
private  String _onload = null;

/*
* JavaScript code to execute on a page unload.
*/
private  String _onunload = null;

/*
* String for output as a page title.
*/
private  String _pageTitle = null;

/*
* Flag to disable rendering in AJAX responses content
				outside of active region. If this attribute set to
				"true" , no one of the components outside of region will
				be included to AJAX response. If set to "false", search
				for components to include in response will be performed
				on all tree. Default "true"
*/
private  boolean _renderRegionOnly = true;

private  boolean _renderRegionOnlySet = false;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* null
*/
private  String _submittedControlId = null;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;


public HtmlPage(){
setRendererType("org.ajax4jsf.components.AjaxPageRenderer");
}

public String getContentType(){
	if (this._contentType != null) {
		return this._contentType;
	}
	ValueExpression ve = getValueExpression("contentType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setContentType(String _contentType){
this._contentType = _contentType;
}

public String getDir(){
	if (this._dir != null) {
		return this._dir;
	}
	ValueExpression ve = getValueExpression("dir");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDir(String _dir){
this._dir = _dir;
}

public String getFormat(){
	if (this._format != null) {
		return this._format;
	}
	ValueExpression ve = getValueExpression("format");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFormat(String _format){
this._format = _format;
}

public String getLang(){
	if (this._lang != null) {
		return this._lang;
	}
	ValueExpression ve = getValueExpression("lang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLang(String _lang){
this._lang = _lang;
}

public String getNamespace(){
	if (this._namespace != null) {
		return this._namespace;
	}
	ValueExpression ve = getValueExpression("namespace");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setNamespace(String _namespace){
this._namespace = _namespace;
}

public String getOnload(){
	if (this._onload != null) {
		return this._onload;
	}
	ValueExpression ve = getValueExpression("onload");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnload(String _onload){
this._onload = _onload;
}

public String getOnunload(){
	if (this._onunload != null) {
		return this._onunload;
	}
	ValueExpression ve = getValueExpression("onunload");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnunload(String _onunload){
this._onunload = _onunload;
}

public String getPageTitle(){
	if (this._pageTitle != null) {
		return this._pageTitle;
	}
	ValueExpression ve = getValueExpression("pageTitle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setPageTitle(String _pageTitle){
this._pageTitle = _pageTitle;
}

public boolean isRenderRegionOnly(){
	if (this._renderRegionOnlySet) {
	    return (this._renderRegionOnly);
	}
	ValueExpression ve = getValueExpression("renderRegionOnly");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._renderRegionOnly);
	    }
	    
	    return value;
	} else {
	    return (this._renderRegionOnly);
	}

}

public void setRenderRegionOnly(boolean _renderRegionOnly){
this._renderRegionOnly = _renderRegionOnly;
this._renderRegionOnlySet = true;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getSubmittedControlId(){
	if (this._submittedControlId != null) {
		return this._submittedControlId;
	}
	ValueExpression ve = getValueExpression("submittedControlId");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSubmittedControlId(String _submittedControlId){
this._submittedControlId = _submittedControlId;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[15];
state[0] = super.saveState(context);
state[1] = _contentType;
state[2] = _dir;
state[3] = _format;
state[4] = _lang;
state[5] = _namespace;
state[6] = _onload;
state[7] = _onunload;
state[8] = _pageTitle;
state[9] = Boolean.valueOf(_renderRegionOnly);
state[10] = Boolean.valueOf(_renderRegionOnlySet);
state[11] = _style;
state[12] = _styleClass;
state[13] = _submittedControlId;
state[14] = _title;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_contentType = (String)states[1];;
		_dir = (String)states[2];;
		_format = (String)states[3];;
		_lang = (String)states[4];;
		_namespace = (String)states[5];;
		_onload = (String)states[6];;
		_onunload = (String)states[7];;
		_pageTitle = (String)states[8];;
		_renderRegionOnly = ((Boolean)states[9]).booleanValue();
		_renderRegionOnlySet = ((Boolean)states[10]).booleanValue();
		_style = (String)states[11];;
		_styleClass = (String)states[12];;
		_submittedControlId = (String)states[13];;
		_title = (String)states[14];;
	
}

}
