/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.model.DataComponentState;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.Column;
import org.richfaces.component.ScriptExportable;
import org.richfaces.component.Selectable;
import org.richfaces.component.Sortable;
import org.richfaces.convert.rowkey.ScrollableDataTableRowKeyConverter;
import org.richfaces.event.AttributeHolder;
import org.richfaces.event.ScrollableGridViewEvent;
import org.richfaces.event.sort.MultiColumnSortListener;
import org.richfaces.event.sort.SingleColumnSortListener;
import org.richfaces.event.sort.SortEvent;
import org.richfaces.event.sort.SortListener;
import org.richfaces.model.DataModelCache;
import org.richfaces.model.ScrollableTableDataModel;
import org.richfaces.model.ScrollableTableDataRange;
import org.richfaces.model.SortOrder;
import org.richfaces.model.internal.ComponentSortableDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIScrollableDataTable
extends UIDataAdaptor
implements AjaxComponent,
Sortable,
Selectable,
ScriptExportable {
    public static final String COMPONENT_TYPE = "org.richfaces.component.ScrollableDataTable";
    public static final String SORT_SINGLE = "single";
    public static final String SORT_MULTI = "multi";
    private static final Log log = LogFactory.getLog(UIScrollableDataTable.class);
    private boolean useSavedRanges = true;
    private List<Range> ranges;
    private Collection<String> responseData = new ArrayList<String>();
    private int reqRowsCount = -1;
    private String scrollPos;
    private SortListener sortListener;
    private Converter defaultRowKeyConverter = new ScrollableDataTableRowKeyConverter();

    public abstract SortOrder getSortOrder();

    public abstract void setSortOrder(SortOrder var1);

    public Collection<String> getResponseData() {
        return this.responseData;
    }

    public void setResponseData(Collection<String> responseData) {
        this.responseData = responseData;
    }

    protected DataComponentState createComponentState() {
        return new DataComponentState(){

            public Range getRange() {
                int curentRow = UIScrollableDataTable.this.getFirst();
                int rows = UIScrollableDataTable.this.reqRowsCount == -1 ? UIScrollableDataTable.this.getRows() : UIScrollableDataTable.this.reqRowsCount;
                int rowsCount = UIScrollableDataTable.this.getExtendedDataModel().getRowCount();
                if (rows > 0) {
                    if ((rows += curentRow) >= 0) {
                        rows = Math.min(rows, rowsCount);
                    }
                } else {
                    rows = rowsCount >= 0 ? rowsCount : -1;
                }
                return new ScrollableTableDataRange(curentRow, rows, UIScrollableDataTable.this.getSortOrder());
            }
        };
    }

    public void processDecodes(FacesContext faces) {
        this.useSavedRanges = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)"UIScrollableDataTable.processDecodes(faces)");
        }
        this.checkRange();
        super.processDecodes(faces);
    }

    public void processValidators(FacesContext faces) {
        this.useSavedRanges = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)"UIScrollableDataTable.processValidators(faces)");
        }
        super.processValidators(faces);
    }

    public void processUpdates(FacesContext faces) {
        this.useSavedRanges = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)"UIScrollableDataTable.processUpdates(faces)");
        }
        super.processUpdates(faces);
        this.ranges = null;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"UIScrollableDataTable.encodeBegin(context)");
        }
        this.useSavedRanges = false;
        this.checkRange();
        super.encodeBegin(context);
    }

    protected ExtendedDataModel createDataModel() {
        Object value = this.getValue();
        ScrollableTableDataModel model = null;
        if (value instanceof ScrollableTableDataModel) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found instanceof " + value.getClass() + " will use it unwrapped"));
            }
            model = (ScrollableTableDataModel)value;
        } else {
            model = new ComponentSortableDataModel(this.getVar(), value);
        }
        if (this.isCacheable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initializing cache of type " + DataModelCache.class));
            }
            model = new DataModelCache(model);
        }
        return model;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.ranges, this.scrollPos, UIScrollableDataTable.saveAttachedState((FacesContext)context, (Object)this.sortListener)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.ranges = (List)values[1];
        this.scrollPos = (String)values[2];
        this.sortListener = (SortListener)UIScrollableDataTable.restoreAttachedState((FacesContext)context, (Object)values[3]);
    }

    protected Iterator<UIComponent> dataChildren() {
        IteratorChain chain = new IteratorChain();
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof Column) && !(kid instanceof UIColumn)) continue;
            chain.addIterator(kid.getChildren().iterator());
        }
        return chain;
    }

    protected Iterator<UIComponent> fixedChildren() {
        IteratorChain chain = new IteratorChain(this.getFacets().values().iterator());
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof Column) && !(kid instanceof UIColumn)) continue;
            chain.addIterator(kid.getFacets().values().iterator());
        }
        return chain;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof AttributeHolder) {
            ((AttributeHolder)event).applyAttributes((UIComponent)this);
        }
        if (event instanceof AjaxEvent) {
            AjaxContext.getCurrentInstance().addComponentToAjaxRender((UIComponent)this);
        } else if (event instanceof SortEvent) {
            this.processSortingChange(event);
        } else if (event instanceof ScrollableGridViewEvent) {
            this.processScrolling(event);
        }
    }

    protected boolean broadcastLocal(FacesEvent event) {
        return super.broadcastLocal(event) || event instanceof SortEvent || event instanceof ScrollableGridViewEvent;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof AjaxEvent) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else if (event instanceof SortEvent) {
            new AjaxEvent((UIComponent)this).queue();
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else if (event instanceof ScrollableGridViewEvent) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            new AjaxEvent((UIComponent)this).queue();
        }
        super.queueEvent(event);
    }

    public void processScrolling(FacesEvent event) {
        ScrollableGridViewEvent e = (ScrollableGridViewEvent)event;
        this.setFirst(e.getFirst());
        this.reqRowsCount = e.getRows();
        this.getFacesContext().renderResponse();
    }

    public void processSortingChange(FacesEvent event) {
        SortEvent e = (SortEvent)event;
        this.getSortListener().processSort(e);
        this.setFirst(e.getFirst());
        this.reqRowsCount = e.getRows();
        this.resetDataModel();
        this.getFacesContext().renderResponse();
    }

    public void walk(FacesContext faces, DataVisitor visitor, Object argument) throws IOException {
        Range visitedRange = this.getComponentState().getRange();
        if (this.ranges == null) {
            this.ranges = new ArrayList<Range>();
        }
        if (!this.ranges.contains(visitedRange)) {
            this.ranges.add(visitedRange);
        }
        if (this.useSavedRanges) {
            for (ScrollableTableDataRange scrollableTableDataRange : this.ranges) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Range is: " + scrollableTableDataRange.getFirst() + " - " + scrollableTableDataRange.getLast() + " sortOrder: " + scrollableTableDataRange.getSortOrder()));
                }
                this.getExtendedDataModel().walk(faces, visitor, (Range)scrollableTableDataRange, argument);
            }
        } else {
            super.walk(faces, visitor, argument);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
    }

    public boolean isCacheable() {
        return true;
    }

    public String getScrollPos() {
        return this.scrollPos;
    }

    public void setScrollPos(String scrollPos) {
        this.scrollPos = scrollPos;
    }

    public SortListener getSortListener() {
        if (this.sortListener != null) {
            return this.sortListener;
        }
        if (SORT_MULTI.equals(this.getSortMode())) {
            return MultiColumnSortListener.INSTANCE;
        }
        return SingleColumnSortListener.INSTANCE;
    }

    public void setSortListener(SortListener sortListener) {
        this.sortListener = sortListener;
    }

    public abstract String getSortMode();

    public abstract void setSortMode(String var1);

    public abstract Object getActiveRowKey();

    public abstract void setActiveRowKey(Object var1);

    public void setRowIndex(int index) {
        if (index < 0) {
            this.setRowKey(null);
        }
    }

    public void resetReqRowsCount() {
        this.reqRowsCount = -1;
    }

    private void checkRange() {
        int rows = this.reqRowsCount == -1 ? this.getRows() : this.reqRowsCount;
        if (this.getRowCount() < this.getFirst() + rows) {
            this.setFirst(0);
            this.setScrollPos("0,0," + rows);
        }
    }

    public boolean isLimitToList() {
        return false;
    }

    public void setLimitToList(boolean submitForm) {
    }

    public boolean isAjaxSingle() {
        return false;
    }

    public void setAjaxSingle(boolean single) {
    }

    public Converter getRowKeyConverter() {
        Converter converter = super.getRowKeyConverter();
        if (null == converter) {
            return this.defaultRowKeyConverter;
        }
        return converter;
    }

    public void setRowKeyConverter(Converter rowKeyConverter) {
        super.setRowKeyConverter(rowKeyConverter);
    }
}

