/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.util.HtmlDimensions;
import org.richfaces.component.UITab;
import org.richfaces.component.UITabPanel;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.SwitchablePanelSwitchEvent;
import org.richfaces.renderkit.TabClassBuilder;
import org.richfaces.renderkit.TabInfoCollector;
import org.richfaces.renderkit.TabPanelInfoCollector;

public class TabPanelRendererBase
extends HeaderResourcesRendererBase {
    public static final String ACTIVE_CELL_CLASSES = "dr-tbpnl-tbcell-act rich-tabhdr-cell-active";
    public static final String INACTIVE_CELL_CLASSES = "dr-tbpnl-tbcell-inact rich-tabhdr-cell-inactive";
    public static final String DISABLED_CELL_CLASSES = "dr-tbpnl-tbcell-dsbld rich-tabhdr-cell-disabled";
    private final String TABS_WITH_SAME_NAMES_ERROR = "tabs with the same name not allowed";
    private static final TabInfoCollector collector = new TabInfoCollector(){
        private final JSReference JSR_ACTIVE_CLASS = new JSReference("activeClass");
        private final JSReference JSR_ID = new JSReference("id");
        private final JSReference JSR_INACTIVE_CLASS = new JSReference("inactiveClass");
        private final JSReference JSR_CELL_ACTIVE_CLASS = new JSReference("cellActiveClass");
        private final JSReference JSR_CELL_INACTIVE_CLASS = new JSReference("cellInactiveClass");
        private final JSReference JSR_NAME = new JSReference("name");
        private final JSReference JSR_ONTABLEAVE = new JSReference("ontableave");
        private final JSReference JSR_ONTABENTER = new JSReference("ontabenter");

        public Object collectTabInfo(FacesContext context, UITab tab) {
            HashMap<JSReference, Object> info = new HashMap<JSReference, Object>();
            info.put(this.JSR_ID, tab.getClientId(context));
            info.put(this.JSR_ACTIVE_CLASS, TabPanelRendererBase.getActiveTabClass(tab));
            info.put(this.JSR_INACTIVE_CLASS, TabPanelRendererBase.getInactiveTabClass(tab));
            info.put(this.JSR_CELL_ACTIVE_CLASS, TabPanelRendererBase.ACTIVE_CELL_CLASSES);
            info.put(this.JSR_CELL_INACTIVE_CLASS, TabPanelRendererBase.INACTIVE_CELL_CLASSES);
            info.put(this.JSR_NAME, tab.getName());
            info.put(this.JSR_ONTABLEAVE, tab.getAttributes().get("ontableave"));
            info.put(this.JSR_ONTABENTER, tab.getAttributes().get("ontabenter"));
            return info;
        }
    };
    private static final TabPanelInfoCollector panelInfoCollector = new TabPanelInfoCollector(){
        private final JSReference JSR_ONTABCHANGE = new JSReference("ontabchange");
        private final JSReference JSR_ID = new JSReference("id");

        public Object collectTabPanelInfo(FacesContext context, UITabPanel tabPanel) {
            HashMap info = new HashMap();
            info.put(this.JSR_ONTABCHANGE, tabPanel.getAttributes().get("ontabchange"));
            info.put(this.JSR_ID, tabPanel.getClientId(context));
            return info;
        }
    };

    protected Class getComponentClass() {
        return UITabPanel.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        UITabPanel panel = (UITabPanel)component;
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        UITab eventTab = null;
        Iterator tabsIterator = panel.getRenderedTabs();
        while (tabsIterator.hasNext() && eventTab == null) {
            String tabClientId;
            UITab tab = (UITab)((Object)tabsIterator.next());
            if (tab.isDisabled() || null == requestParameterMap.get(tabClientId = tab.getClientId(context)) && null == requestParameterMap.get(tabClientId + "_server_submit")) continue;
            eventTab = tab;
        }
        if (eventTab != null) {
            new SwitchablePanelSwitchEvent((UIComponent)panel, null, eventTab).queue();
            new ActionEvent(eventTab).queue();
            if ("ajax".equals(eventTab.getSwitchTypeOrDefault())) {
                new AjaxEvent((UIComponent)eventTab).queue();
            }
        } else {
            String newValue = (String)requestParameterMap.get(clientId);
            if (null != newValue) {
                new SwitchablePanelSwitchEvent((UIComponent)panel, (Object)newValue, null).queue();
            }
        }
    }

    public static String encodeStyles(FacesContext context, UIComponent component) throws IOException {
        String style;
        String widthAttrValue = (String)component.getAttributes().get("width");
        String heightAttrValue = (String)component.getAttributes().get("height");
        String styleAttrValue = (String)component.getAttributes().get("style");
        String string = style = styleAttrValue != null ? styleAttrValue : "";
        if (!TabPanelRendererBase.parameterPresent(styleAttrValue, "width")) {
            String width = widthAttrValue != null && widthAttrValue.length() > 0 ? HtmlUtil.qualifySize((String)widthAttrValue) : "";
            style = TabPanelRendererBase.addParameter(style, "width:" + width);
        }
        if (!TabPanelRendererBase.parameterPresent(styleAttrValue, "height")) {
            String height;
            String string2 = height = heightAttrValue != null && heightAttrValue.length() > 0 ? HtmlUtil.qualifySize((String)heightAttrValue) : "";
            if (height.length() > 0) {
                style = TabPanelRendererBase.addParameter(style, "height:" + height);
            }
        }
        return style;
    }

    protected static boolean parameterPresent(String style, String name) {
        if (style != null && style.length() > 0) {
            String[] styles = style.split(";");
            for (int i = 0; i < styles.length; ++i) {
                String[] pair = styles[i].split(":");
                if (!pair[0].trim().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static String addParameter(String style, String element) {
        String s = style.trim();
        return style + (s.length() == 0 || s.endsWith(";") ? "" : ";") + element;
    }

    protected String getValueAsString(FacesContext context, UITabPanel tabPanel) {
        return this.getUtils().getValueAsString(context, (UIComponent)tabPanel);
    }

    private Object checkValue(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            if (s.length() == 0) {
                return null;
            }
            return s;
        }
        return value;
    }

    protected void preEncodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UITabPanel) {
            UITabPanel tabPanel = (UITabPanel)component;
            ComponentVariables componentVariables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)tabPanel);
            componentVariables.setVariable("tabPanel", this.getTabPanelInfoCollector().collectTabPanelInfo(context, (UITabPanel)component));
        }
    }

    public void encodeTabs(FacesContext context, UITabPanel tabPanel) throws IOException {
        ComponentVariables componentVariables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)tabPanel);
        tabPanel.setRenderedValue(null);
        Object checkedValue = this.checkValue(tabPanel.getValue());
        UITabPanel pane = tabPanel;
        UITab activeTab = null;
        TabsIteratorHelper helper = new TabsIteratorHelper(pane.getRenderedTabs(), checkedValue);
        activeTab = helper.getTab();
        if (activeTab == null) {
            Object label = MessageUtil.getLabel((FacesContext)context, (UIComponent)tabPanel);
            String message = label + ": tab panel has no enabled or rendered tabs!";
            context.getExternalContext().log(message);
            return;
        }
        if (helper.isFallback()) {
            Object label = MessageUtil.getLabel((FacesContext)context, (UIComponent)tabPanel);
            String message = label + ": tab panel [@selectedTab=" + checkedValue + "] has no enabled or rendered tab with such name. Tab: " + activeTab.getName() + " will be used instead!";
            context.getExternalContext().log(message);
            tabPanel.setRenderedValue(activeTab.getName());
        } else if (checkedValue == null) {
            tabPanel.setRenderedValue(activeTab.getName());
        } else {
            tabPanel.setRenderedValue(null);
        }
        helper = null;
        ArrayList<Object> tabs = new ArrayList<Object>();
        boolean clientSide = "client".equals(pane.getSwitchType());
        TabInfoCollector tabInfoCollector = this.getTabInfoCollector();
        UITab prevTab = null;
        Iterator iter = pane.getRenderedTabs();
        while (iter.hasNext()) {
            UITab tab = (UITab)((Object)iter.next());
            boolean active = activeTab == tab;
            tab.setActive(active);
            if (!clientSide) {
                clientSide = "client".equals(tab.getSwitchTypeOrDefault());
            }
            if (prevTab != null && prevTab.getName().equals(tab.getName())) {
                throw new FacesException("tabs with the same name not allowed");
            }
            tab.encodeTab(context, active);
            if (!tab.isDisabled()) {
                tabs.add(tabInfoCollector.collectTabInfo(context, tab));
            }
            prevTab = tab;
        }
        componentVariables.setVariable("clientSide", (Object)new Boolean(clientSide));
        componentVariables.setVariable("tabs", tabs);
    }

    public static String getActiveTabCellClass(UITab tab) {
        return TabClassBuilder.activeTabClassBuilder.buildTabClass(tab);
    }

    public static String getDisabledTabCellClass(UITab tab) {
        return TabClassBuilder.disabledTabClassBuilder.buildTabClass(tab);
    }

    public static String getInactiveTabCellClass(UITab tab) {
        return TabClassBuilder.inactiveTabClassBuilder.buildTabClass(tab);
    }

    public static String getActiveTabClass(UITab tab) {
        return TabClassBuilder.activeTabClassBuilder.buildTabClass(tab);
    }

    public static String getDisabledTabClass(UITab tab) {
        return TabClassBuilder.disabledTabClassBuilder.buildTabClass(tab);
    }

    public static String getInactiveTabClass(UITab tab) {
        return TabClassBuilder.inactiveTabClassBuilder.buildTabClass(tab);
    }

    public void encodeTabsScript(FacesContext context, UITabPanel pane) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)pane);
        ArrayList tabs = (ArrayList)variables.getVariable("tabs");
        this.getUtils().writeScript(context, (UIComponent)pane, (Object)("RichFaces.panelTabs['" + pane.getClientId(context) + "']=" + ScriptUtils.toScript((Object)tabs) + ";"));
    }

    public void encodeTabPanelScript(FacesContext context, UITabPanel pane) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)pane);
        Object tabPanel = variables.getVariable("tabPanel");
        this.getUtils().writeScript(context, (UIComponent)pane, (Object)("RichFaces.tabPanel['" + pane.getClientId(context) + "']=" + ScriptUtils.toScript((Object)tabPanel) + ";"));
    }

    protected TabInfoCollector getTabInfoCollector() {
        return collector;
    }

    protected TabPanelInfoCollector getTabPanelInfoCollector() {
        return panelInfoCollector;
    }

    public String encodeHeaderSpacing(FacesContext context, UITabPanel pane) throws IOException {
        String headerSpacing = pane.getHeaderSpacing();
        Double decoded = HtmlDimensions.decode((String)headerSpacing);
        return "width: " + HtmlUtil.qualifySize((String)headerSpacing) + "; ";
    }

    protected static class TabsIteratorHelper {
        private Iterator tabs;
        private UITab namedTab = null;
        private UITab firstApplicableTab = null;
        private boolean fallback;

        public TabsIteratorHelper(Iterator tabs, Object name) {
            UITab tab;
            this.tabs = tabs;
            if (name != null) {
                while (tabs.hasNext()) {
                    tab = this.nextTab();
                    if (!name.equals(tab.getName())) continue;
                    this.namedTab = tab;
                    break;
                }
            }
            if (this.namedTab == null) {
                if (name != null) {
                    this.fallback = true;
                }
                this.namedTab = this.findAnyTab();
            } else if (this.namedTab.isDisabled() && this.namedTab != (tab = this.findAnyTab()) && tab != null && !tab.isDisabled()) {
                this.fallback = true;
                this.namedTab = tab;
            }
        }

        private UITab nextTab() {
            UITab tab = (UITab)((Object)this.tabs.next());
            if (this.firstApplicableTab == null) {
                this.firstApplicableTab = tab;
            } else if (this.firstApplicableTab.isDisabled() && !tab.isDisabled()) {
                this.firstApplicableTab = tab;
            }
            return tab;
        }

        public UITab getTab() {
            return this.namedTab;
        }

        public boolean isFallback() {
            return this.fallback;
        }

        private UITab findAnyTab() {
            while ((this.firstApplicableTab == null || this.firstApplicableTab.isDisabled()) && this.tabs.hasNext()) {
                this.nextTab();
            }
            return this.firstApplicableTab;
        }
    }
}

