package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UIDropSupport;

public class HtmlDropSupport extends UIDropSupport{

final public static  String COMPONENT_FAMILY = "org.richfaces.DropSupport";

final public static  String COMPONENT_TYPE = "org.richfaces.DropSupport";

/*
* list of comma separated cursors that indicates when acceptable draggable over dropzone
*/
private  String _acceptCursors = null;

/*
* A list of drag zones types, which elements are accepted by a drop zone
*/
private  Object _acceptedTypes = null;

/*
* if "true", submits ONLY one field/link, instead of all form controls
*/
private  boolean _ajaxSingle = false;

private  boolean _ajaxSingleSet = false;

/*
* If "true", after process validations phase it skips updates of model beans on a force render response. It can be used for validating components input
*/
private  boolean _bypassUpdates = false;

private  boolean _bypassUpdatesSet = false;

/*
* mapping between drop types and acceptable cursors
*/
private  Object _cursorTypeMapping = null;

/*
* Serialized (on default with JSON) data passed on the client by a developer on AJAX request. It's accessible via "data.foo" syntax
*/
private  Object _data = null;

/*
* Disable default action for target event (append "return false;" to JavaScript)
*/
private  String _disableDefault = null;

/*
* MethodBinding representing an action listener method that will be notified after drop operation.
*/
private  MethodBinding _dropListener = null;

/*
* Data to be processed after a drop event
*/
private  Object _dropValue = null;

/*
* Name of requests queue to avoid send next request before complete other from same event. Can be used to reduce number of requests of frequently events (key press, mouse move etc.)
*/
private  String _eventsQueue = null;

/*
* id of element to set focus after request completed on client side
*/
private  String _focus = null;

/*
* Attribute allows to ignore an Ajax Response produced by a request if the newest 'similar' request is
in a queue already. ignoreDupResponses="true" does not cancel the request while it is processed on the server,
but just allows to avoid unnecessary updates on the client side if the response isn't actual now
*/
private  boolean _ignoreDupResponses = false;

private  boolean _ignoreDupResponsesSet = false;

/*
* If "true", updates on client side ONLY elements from this 'reRender' property. If "false" (default) updates all rendered by ajax region components
*/
private  boolean _limitToList = false;

private  boolean _limitToListSet = false;

/*
* JavaScript code for call before DOM has been updated on client side
*/
private  String _onbeforedomupdate = null;

/*
* JavaScript code for call after request completed on client side
*/
private  String _oncomplete = null;

/*
* A JavaScript event handler called on enter draggable object to zone
*/
private  String _ondragenter = null;

/*
* A JavaScript event handler called after a drag object leaves zone
*/
private  String _ondragexit = null;

/*
* A JavaScript event handler called after a drag object is dropped to zone
*/
private  String _ondrop = null;

/*
* A JavaScript handler for event fired on a drop even the drop for a given type is not available
*/
private  String _ondropend = null;

/*
* JavaScript code for call before submission of ajax event
*/
private  String _onsubmit = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, processed at the phases 2-5 in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _process = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, rendered in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _reRender = null;

/*
* list of comma separated cursors that indicates when rejectable draggable over dropzone
*/
private  String _rejectCursors = null;

/*
* Attribute defines the time (in ms.) that the request will be wait in the queue before it is ready to send.
When the delay time is over, the request will be sent to the server or removed if the newest 'similar' request is in a queue already
*/
private  int _requestDelay = Integer.MIN_VALUE;

private  boolean _requestDelaySet = false;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* Response waiting time on a particular request. If a response is not received during this time, the request is aborted
*/
private  int _timeout = Integer.MIN_VALUE;

private  boolean _timeoutSet = false;

/*
* Map between a draggable type and an indicator name on zone. it's defined with the pair (drag type:indicator name))
*/
private  Object _typeMapping = null;


public HtmlDropSupport(){
setRendererType("org.richfaces.DropSupportRenderer");
}

public String getAcceptCursors(){
	if (this._acceptCursors != null) {
		return this._acceptCursors;
	}
	ValueExpression ve = getValueExpression("acceptCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setAcceptCursors(String _acceptCursors){
this._acceptCursors = _acceptCursors;
}

public Object getAcceptedTypes(){
	if (this._acceptedTypes != null) {
		return this._acceptedTypes;
	}
	ValueExpression ve = getValueExpression("acceptedTypes");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAcceptedTypes(Object _acceptedTypes){
this._acceptedTypes = _acceptedTypes;
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public boolean isBypassUpdates(){
	if (this._bypassUpdatesSet) {
	    return (this._bypassUpdates);
	}
	ValueExpression ve = getValueExpression("bypassUpdates");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._bypassUpdates);
	    }
	    
	    return value;
	} else {
	    return (this._bypassUpdates);
	}

}

public void setBypassUpdates(boolean _bypassUpdates){
this._bypassUpdates = _bypassUpdates;
this._bypassUpdatesSet = true;
}

public Object getCursorTypeMapping(){
	if (this._cursorTypeMapping != null) {
		return this._cursorTypeMapping;
	}
	ValueExpression ve = getValueExpression("cursorTypeMapping");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCursorTypeMapping(Object _cursorTypeMapping){
this._cursorTypeMapping = _cursorTypeMapping;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public String getDisableDefault(){
	if (this._disableDefault != null) {
		return this._disableDefault;
	}
	ValueExpression ve = getValueExpression("disableDefault");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDisableDefault(String _disableDefault){
this._disableDefault = _disableDefault;
}

public MethodBinding getDropListener(){
return _dropListener;
}

public void setDropListener(MethodBinding _dropListener){
this._dropListener = _dropListener;
}

public Object getDropValue(){
	if (this._dropValue != null) {
		return this._dropValue;
	}
	ValueExpression ve = getValueExpression("dropValue");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDropValue(Object _dropValue){
this._dropValue = _dropValue;
}

public String getEventsQueue(){
	if (this._eventsQueue != null) {
		return this._eventsQueue;
	}
	ValueExpression ve = getValueExpression("eventsQueue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEventsQueue(String _eventsQueue){
this._eventsQueue = _eventsQueue;
}

public String getFocus(){
	if (this._focus != null) {
		return this._focus;
	}
	ValueExpression ve = getValueExpression("focus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFocus(String _focus){
this._focus = _focus;
}

public boolean isIgnoreDupResponses(){
	if (this._ignoreDupResponsesSet) {
	    return (this._ignoreDupResponses);
	}
	ValueExpression ve = getValueExpression("ignoreDupResponses");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ignoreDupResponses);
	    }
	    
	    return value;
	} else {
	    return (this._ignoreDupResponses);
	}

}

public void setIgnoreDupResponses(boolean _ignoreDupResponses){
this._ignoreDupResponses = _ignoreDupResponses;
this._ignoreDupResponsesSet = true;
}

public boolean isLimitToList(){
	if (this._limitToListSet) {
	    return (this._limitToList);
	}
	ValueExpression ve = getValueExpression("limitToList");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._limitToList);
	    }
	    
	    return value;
	} else {
	    return (this._limitToList);
	}

}

public void setLimitToList(boolean _limitToList){
this._limitToList = _limitToList;
this._limitToListSet = true;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public String getOndragenter(){
	if (this._ondragenter != null) {
		return this._ondragenter;
	}
	ValueExpression ve = getValueExpression("ondragenter");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndragenter(String _ondragenter){
this._ondragenter = _ondragenter;
}

public String getOndragexit(){
	if (this._ondragexit != null) {
		return this._ondragexit;
	}
	ValueExpression ve = getValueExpression("ondragexit");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndragexit(String _ondragexit){
this._ondragexit = _ondragexit;
}

public String getOndrop(){
	if (this._ondrop != null) {
		return this._ondrop;
	}
	ValueExpression ve = getValueExpression("ondrop");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndrop(String _ondrop){
this._ondrop = _ondrop;
}

public String getOndropend(){
	if (this._ondropend != null) {
		return this._ondropend;
	}
	ValueExpression ve = getValueExpression("ondropend");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndropend(String _ondropend){
this._ondropend = _ondropend;
}

public String getOnsubmit(){
	if (this._onsubmit != null) {
		return this._onsubmit;
	}
	ValueExpression ve = getValueExpression("onsubmit");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnsubmit(String _onsubmit){
this._onsubmit = _onsubmit;
}

public Object getProcess(){
	if (this._process != null) {
		return this._process;
	}
	ValueExpression ve = getValueExpression("process");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProcess(Object _process){
this._process = _process;
}

public Object getReRender(){
	if (this._reRender != null) {
		return this._reRender;
	}
	ValueExpression ve = getValueExpression("reRender");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setReRender(Object _reRender){
this._reRender = _reRender;
}

public String getRejectCursors(){
	if (this._rejectCursors != null) {
		return this._rejectCursors;
	}
	ValueExpression ve = getValueExpression("rejectCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRejectCursors(String _rejectCursors){
this._rejectCursors = _rejectCursors;
}

public int getRequestDelay(){
	if (this._requestDelaySet) {
	    return (this._requestDelay);
	}
	ValueExpression ve = getValueExpression("requestDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._requestDelay);
	    }
	    
	    return value;
	} else {
	    return (this._requestDelay);
	}

}

public void setRequestDelay(int _requestDelay){
this._requestDelay = _requestDelay;
this._requestDelaySet = true;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public int getTimeout(){
	if (this._timeoutSet) {
	    return (this._timeout);
	}
	ValueExpression ve = getValueExpression("timeout");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._timeout);
	    }
	    
	    return value;
	} else {
	    return (this._timeout);
	}

}

public void setTimeout(int _timeout){
this._timeout = _timeout;
this._timeoutSet = true;
}

public Object getTypeMapping(){
	if (this._typeMapping != null) {
		return this._typeMapping;
	}
	ValueExpression ve = getValueExpression("typeMapping");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTypeMapping(Object _typeMapping){
this._typeMapping = _typeMapping;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[34];
state[0] = super.saveState(context);
state[1] = _acceptCursors;
state[2] = saveAttachedState(context, _acceptedTypes);
state[3] = Boolean.valueOf(_ajaxSingle);
state[4] = Boolean.valueOf(_ajaxSingleSet);
state[5] = Boolean.valueOf(_bypassUpdates);
state[6] = Boolean.valueOf(_bypassUpdatesSet);
state[7] = saveAttachedState(context, _cursorTypeMapping);
state[8] = saveAttachedState(context, _data);
state[9] = _disableDefault;
state[10] = saveAttachedState(context, _dropListener);
state[11] = saveAttachedState(context, _dropValue);
state[12] = _eventsQueue;
state[13] = _focus;
state[14] = Boolean.valueOf(_ignoreDupResponses);
state[15] = Boolean.valueOf(_ignoreDupResponsesSet);
state[16] = Boolean.valueOf(_limitToList);
state[17] = Boolean.valueOf(_limitToListSet);
state[18] = _onbeforedomupdate;
state[19] = _oncomplete;
state[20] = _ondragenter;
state[21] = _ondragexit;
state[22] = _ondrop;
state[23] = _ondropend;
state[24] = _onsubmit;
state[25] = saveAttachedState(context, _process);
state[26] = saveAttachedState(context, _reRender);
state[27] = _rejectCursors;
state[28] = Integer.valueOf(_requestDelay);
state[29] = Boolean.valueOf(_requestDelaySet);
state[30] = _status;
state[31] = Integer.valueOf(_timeout);
state[32] = Boolean.valueOf(_timeoutSet);
state[33] = saveAttachedState(context, _typeMapping);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_acceptCursors = (String)states[1];;
		_acceptedTypes = (Object)restoreAttachedState(context, states[2]);
		_ajaxSingle = ((Boolean)states[3]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[4]).booleanValue();
		_bypassUpdates = ((Boolean)states[5]).booleanValue();
		_bypassUpdatesSet = ((Boolean)states[6]).booleanValue();
		_cursorTypeMapping = (Object)restoreAttachedState(context, states[7]);
		_data = (Object)restoreAttachedState(context, states[8]);
		_disableDefault = (String)states[9];;
		_dropListener = (MethodBinding)restoreAttachedState(context, states[10]);
		_dropValue = (Object)restoreAttachedState(context, states[11]);
		_eventsQueue = (String)states[12];;
		_focus = (String)states[13];;
		_ignoreDupResponses = ((Boolean)states[14]).booleanValue();
		_ignoreDupResponsesSet = ((Boolean)states[15]).booleanValue();
		_limitToList = ((Boolean)states[16]).booleanValue();
		_limitToListSet = ((Boolean)states[17]).booleanValue();
		_onbeforedomupdate = (String)states[18];;
		_oncomplete = (String)states[19];;
		_ondragenter = (String)states[20];;
		_ondragexit = (String)states[21];;
		_ondrop = (String)states[22];;
		_ondropend = (String)states[23];;
		_onsubmit = (String)states[24];;
		_process = (Object)restoreAttachedState(context, states[25]);
		_reRender = (Object)restoreAttachedState(context, states[26]);
		_rejectCursors = (String)states[27];;
		_requestDelay = ((Integer)states[28]).intValue();
		_requestDelaySet = ((Boolean)states[29]).booleanValue();
		_status = (String)states[30];;
		_timeout = ((Integer)states[31]).intValue();
		_timeoutSet = ((Boolean)states[32]).booleanValue();
		_typeMapping = (Object)restoreAttachedState(context, states[33]);
	
}

}
