/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.event.sort;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import javax.faces.context.FacesContext;
import org.richfaces.component.Column;
import org.richfaces.component.UIScrollableDataTable;
import org.richfaces.component.util.ColumnUtil;
import org.richfaces.event.sort.AbstractSortListener;
import org.richfaces.event.sort.SortEvent;
import org.richfaces.model.SortField;
import org.richfaces.model.SortOrder;

public class MultiColumnSortListener
extends AbstractSortListener {
    public static final MultiColumnSortListener INSTANCE = new MultiColumnSortListener();

    private MultiColumnSortListener() {
    }

    public void processSort(SortEvent e) {
        UIScrollableDataTable grid = (UIScrollableDataTable)e.getComponent();
        int columnIndex = e.getSortColumn();
        Column column = (Column)grid.getChildren().get(columnIndex);
        String name = ColumnUtil.getColumnSorting((Column)column);
        SortOrder sortOrder = grid.getSortOrder();
        if (sortOrder == null) {
            sortOrder = new SortOrder();
            grid.setSortOrder(sortOrder);
            if (grid.getValueBinding("sortOrder") != null) {
                grid.getValueBinding("sortOrder").setValue(FacesContext.getCurrentInstance(), (Object)sortOrder);
            }
        }
        Boolean suggested = e.getSuggestedOrder();
        SortField[] fields = sortOrder.getFields();
        if (fields == null) {
            fields = new SortField[]{new SortField(name, columnIndex, this.nextSortOrder(null, suggested))};
        } else {
            LinkedList<SortField> newFields = new LinkedList<SortField>(Arrays.asList(fields));
            SortField newField = null;
            Iterator iterator = newFields.iterator();
            while (iterator.hasNext() && newField == null) {
                SortField sortField = (SortField)iterator.next();
                if (sortField.getIndex() != columnIndex && (sortField.getName() == null || name == null || !name.equals(sortField.getName()))) continue;
                Boolean asc = sortField.getAscending();
                newField = new SortField(name, columnIndex, this.nextSortOrder(asc, suggested));
                iterator.remove();
            }
            if (newField == null) {
                newField = new SortField(name, columnIndex, this.nextSortOrder(null, suggested));
            }
            newFields.add(newField);
            fields = newFields.toArray(new SortField[newFields.size()]);
        }
        sortOrder.setFields(fields);
    }
}

