if (!window.RichFaces) {
	window.RichFaces = {};
}

RichFaces.Datascroller = {};

RichFaces.Datascroller.COMPONENT = "rich:datascroller";

RichFaces.Datascroller.initialize = function(id, submitFunction) {
	var scroller = $(id);
	scroller.richfacesComponent = RichFaces.Datascroller.COMPONENT;
	scroller.submitFunction = submitFunction;
};

RichFaces.Datascroller.switchToPage = function(elt, event, newPage) {
	var e = elt;
	while (!e.richfacesComponent || e.richfacesComponent != RichFaces.Datascroller.COMPONENT) {
		e = e.parentNode;
	}

	var id = e.id;
	var inputId = id + "PageIndex";  
	
	var input = e.lastChild;
	while (!input.id || input.id != inputId) {
		input = input.previousSibling;
	}
	
	var value = input.value;

	input.value = newPage;
	try {
		e.submitFunction(event);
	} finally {
		input.value = value;
	}
};