package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIComboBox;

public class HtmlComboBox extends UIComboBox{

final public static  String COMPONENT_FAMILY = "org.richfaces.ComboBox";

final public static  String COMPONENT_TYPE = "org.richfaces.ComboBox";

/*
* This attribute assigns an access key to an element. An access key is a single character from the document character set. Note: Authors should consider the input method of the expected reader when specifying an accesskey
*/
private  String _accesskey = null;

/*
* left|center|right|justify [CI]
            Deprecated. This attribute specifies the horizontal alignment of its element with respect to the surrounding context. Possible values:
            
            * left: text lines are rendered flush left.
            * center: text lines are centered.
            * right: text lines are rendered flush right.
            * justify: text lines are justified to both margins.
            
            The default depends on the base text direction. For left to right text, the default is align=left, while for right to left text, the default is align=right
*/
private  String _align = null;

/*
* For a user agents that cannot display images, forms, or applets, this attribute specifies alternate text. The language of the alternate text is specified by the lang attribute
*/
private  String _alt = null;

/*
* 
*/
private  String _buttonClass = null;

/*
* 
*/
private  String _buttonDisabledClass = null;

/*
* 
*/
private  String _buttonDisabledStyle = null;

/*
* URI
*/
private  String _buttonIcon = null;

/*
* URI
*/
private  String _buttonIconDisabled = null;

/*
* URI
*/
private  String _buttonIconInactive = null;

/*
* 
*/
private  String _buttonInactiveClass = null;

/*
* 
*/
private  String _buttonInactiveStyle = null;

/*
* 
*/
private  String _buttonStyle = null;

/*
* 
*/
private  String _defaultLabel = null;

/*
* not implemented
*/
private  Boolean _directInputSuggestions = null;

/*
* When set for a form control, this boolean attribute disables the control for your input
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* enabled for keybord input
*/
private  boolean _enableManualInput = true;

private  boolean _enableManualInputSet = false;

/*
* 
*/
private  Boolean _filterNewValues = null;

/*
* 
*/
private  Integer _hideDelay = null;

/*
* 
*/
private  String _inputClass = null;

/*
* 
*/
private  String _inputDisabledClass = null;

/*
* 
*/
private  String _inputDisabledStyle = null;

/*
* 
*/
private  String _inputInactiveClass = null;

/*
* 
*/
private  String _inputInactiveStyle = null;

/*
* 
*/
private  String _inputStyle = null;

/*
* 
*/
private  String _itemClass = null;

/*
* 
*/
private  String _listClass = null;

/*
* 
*/
private  String _listHeight = null;

/*
* 
*/
private  String _listStyle = null;

/*
* 
*/
private  String _listWidth = null;

/*
* When the type attribute has the value "text" or "password", this attribute specifies the maximum number of characters you may enter. This number may exceed the specified size, in which case the user agent should offer a scrolling mechanism. The default value for this attribute is an unlimited number
*/
private  int _maxlength = Integer.MIN_VALUE;

private  boolean _maxlengthSet = false;

/*
* HTML: script expression; the element lost the focus
*/
private  String _onblur = null;

/*
* HTML: script expression; the element value was changed
*/
private  String _onchange = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: script expression; the element got the focus
*/
private  String _onfocus = null;

/*
* 
*/
private  String _onitemselected = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* 
*/
private  String _onlistcall = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* HTML: script expression; The onselect event occurs when you select some text in a text field. This attribute may be used with the INPUT and TEXTAREA elements
*/
private  String _onselect = null;

/*
* 
*/
private  Boolean _selectFirstOnUpdate = null;

/*
* 
*/
private  Integer _showDelay = null;

/*
* This attribute tells the user agent the initial width of the control. The width is given in pixels except when type attribute has the value "text" or "password". In that case, its value refers to the (integer) number of characters
*/
private  int _size = Integer.MIN_VALUE;

private  boolean _sizeSet = false;

/*
* 
*/
private  String _style = null;

/*
* 
*/
private  String _styleClass = null;

/*
* suggestionValues
*/
private  Object _suggestionValues = null;

/*
* This attribute specifies the position of the current element in the tabbing order for the current document. This value must be a number between 0 and 32767. User agents should ignore leading zeros
*/
private  String _tabindex = null;

/*
* 
*/
private  String _width = null;


public HtmlComboBox(){
setRendererType("org.richfaces.renderkit.ComboBoxRenderer");
}

public String getAccesskey(){
	if (this._accesskey != null) {
		return this._accesskey;
	}
	ValueExpression ve = getValueExpression("accesskey");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAccesskey(String _accesskey){
this._accesskey = _accesskey;
}

public String getAlign(){
	if (this._align != null) {
		return this._align;
	}
	ValueExpression ve = getValueExpression("align");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlign(String _align){
this._align = _align;
}

public String getAlt(){
	if (this._alt != null) {
		return this._alt;
	}
	ValueExpression ve = getValueExpression("alt");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlt(String _alt){
this._alt = _alt;
}

public String getButtonClass(){
	if (this._buttonClass != null) {
		return this._buttonClass;
	}
	ValueExpression ve = getValueExpression("buttonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setButtonClass(String _buttonClass){
this._buttonClass = _buttonClass;
}

public String getButtonDisabledClass(){
	if (this._buttonDisabledClass != null) {
		return this._buttonDisabledClass;
	}
	ValueExpression ve = getValueExpression("buttonDisabledClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setButtonDisabledClass(String _buttonDisabledClass){
this._buttonDisabledClass = _buttonDisabledClass;
}

public String getButtonDisabledStyle(){
	if (this._buttonDisabledStyle != null) {
		return this._buttonDisabledStyle;
	}
	ValueExpression ve = getValueExpression("buttonDisabledStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setButtonDisabledStyle(String _buttonDisabledStyle){
this._buttonDisabledStyle = _buttonDisabledStyle;
}

public String getButtonIcon(){
	if (this._buttonIcon != null) {
		return this._buttonIcon;
	}
	ValueExpression ve = getValueExpression("buttonIcon");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setButtonIcon(String _buttonIcon){
this._buttonIcon = _buttonIcon;
}

public String getButtonIconDisabled(){
	if (this._buttonIconDisabled != null) {
		return this._buttonIconDisabled;
	}
	ValueExpression ve = getValueExpression("buttonIconDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setButtonIconDisabled(String _buttonIconDisabled){
this._buttonIconDisabled = _buttonIconDisabled;
}

public String getButtonIconInactive(){
	if (this._buttonIconInactive != null) {
		return this._buttonIconInactive;
	}
	ValueExpression ve = getValueExpression("buttonIconInactive");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setButtonIconInactive(String _buttonIconInactive){
this._buttonIconInactive = _buttonIconInactive;
}

public String getButtonInactiveClass(){
	if (this._buttonInactiveClass != null) {
		return this._buttonInactiveClass;
	}
	ValueExpression ve = getValueExpression("buttonInactiveClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setButtonInactiveClass(String _buttonInactiveClass){
this._buttonInactiveClass = _buttonInactiveClass;
}

public String getButtonInactiveStyle(){
	if (this._buttonInactiveStyle != null) {
		return this._buttonInactiveStyle;
	}
	ValueExpression ve = getValueExpression("buttonInactiveStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setButtonInactiveStyle(String _buttonInactiveStyle){
this._buttonInactiveStyle = _buttonInactiveStyle;
}

public String getButtonStyle(){
	if (this._buttonStyle != null) {
		return this._buttonStyle;
	}
	ValueExpression ve = getValueExpression("buttonStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setButtonStyle(String _buttonStyle){
this._buttonStyle = _buttonStyle;
}

public String getDefaultLabel(){
	if (this._defaultLabel != null) {
		return this._defaultLabel;
	}
	ValueExpression ve = getValueExpression("defaultLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDefaultLabel(String _defaultLabel){
this._defaultLabel = _defaultLabel;
}

public Boolean getDirectInputSuggestions(){
	if (this._directInputSuggestions != null) {
		return this._directInputSuggestions;
	}
	ValueExpression ve = getValueExpression("directInputSuggestions");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return false;
	

}

public void setDirectInputSuggestions(Boolean _directInputSuggestions){
this._directInputSuggestions = _directInputSuggestions;
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public boolean isEnableManualInput(){
	if (this._enableManualInputSet) {
	    return (this._enableManualInput);
	}
	ValueExpression ve = getValueExpression("enableManualInput");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._enableManualInput);
	    }
	    
	    return value;
	} else {
	    return (this._enableManualInput);
	}

}

public void setEnableManualInput(boolean _enableManualInput){
this._enableManualInput = _enableManualInput;
this._enableManualInputSet = true;
}

public Boolean getFilterNewValues(){
	if (this._filterNewValues != null) {
		return this._filterNewValues;
	}
	ValueExpression ve = getValueExpression("filterNewValues");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return true;
	

}

public void setFilterNewValues(Boolean _filterNewValues){
this._filterNewValues = _filterNewValues;
}

public Integer getHideDelay(){
	if (this._hideDelay != null) {
		return this._hideDelay;
	}
	ValueExpression ve = getValueExpression("hideDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return 0;
	

}

public void setHideDelay(Integer _hideDelay){
this._hideDelay = _hideDelay;
}

public String getInputClass(){
	if (this._inputClass != null) {
		return this._inputClass;
	}
	ValueExpression ve = getValueExpression("inputClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setInputClass(String _inputClass){
this._inputClass = _inputClass;
}

public String getInputDisabledClass(){
	if (this._inputDisabledClass != null) {
		return this._inputDisabledClass;
	}
	ValueExpression ve = getValueExpression("inputDisabledClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setInputDisabledClass(String _inputDisabledClass){
this._inputDisabledClass = _inputDisabledClass;
}

public String getInputDisabledStyle(){
	if (this._inputDisabledStyle != null) {
		return this._inputDisabledStyle;
	}
	ValueExpression ve = getValueExpression("inputDisabledStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setInputDisabledStyle(String _inputDisabledStyle){
this._inputDisabledStyle = _inputDisabledStyle;
}

public String getInputInactiveClass(){
	if (this._inputInactiveClass != null) {
		return this._inputInactiveClass;
	}
	ValueExpression ve = getValueExpression("inputInactiveClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setInputInactiveClass(String _inputInactiveClass){
this._inputInactiveClass = _inputInactiveClass;
}

public String getInputInactiveStyle(){
	if (this._inputInactiveStyle != null) {
		return this._inputInactiveStyle;
	}
	ValueExpression ve = getValueExpression("inputInactiveStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setInputInactiveStyle(String _inputInactiveStyle){
this._inputInactiveStyle = _inputInactiveStyle;
}

public String getInputStyle(){
	if (this._inputStyle != null) {
		return this._inputStyle;
	}
	ValueExpression ve = getValueExpression("inputStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setInputStyle(String _inputStyle){
this._inputStyle = _inputStyle;
}

public String getItemClass(){
	if (this._itemClass != null) {
		return this._itemClass;
	}
	ValueExpression ve = getValueExpression("itemClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setItemClass(String _itemClass){
this._itemClass = _itemClass;
}

public String getListClass(){
	if (this._listClass != null) {
		return this._listClass;
	}
	ValueExpression ve = getValueExpression("listClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setListClass(String _listClass){
this._listClass = _listClass;
}

public String getListHeight(){
	if (this._listHeight != null) {
		return this._listHeight;
	}
	ValueExpression ve = getValueExpression("listHeight");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "200px";
	

}

public void setListHeight(String _listHeight){
this._listHeight = _listHeight;
}

public String getListStyle(){
	if (this._listStyle != null) {
		return this._listStyle;
	}
	ValueExpression ve = getValueExpression("listStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setListStyle(String _listStyle){
this._listStyle = _listStyle;
}

public String getListWidth(){
	if (this._listWidth != null) {
		return this._listWidth;
	}
	ValueExpression ve = getValueExpression("listWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setListWidth(String _listWidth){
this._listWidth = _listWidth;
}

public int getMaxlength(){
	if (this._maxlengthSet) {
	    return (this._maxlength);
	}
	ValueExpression ve = getValueExpression("maxlength");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._maxlength);
	    }
	    
	    return value;
	} else {
	    return (this._maxlength);
	}

}

public void setMaxlength(int _maxlength){
this._maxlength = _maxlength;
this._maxlengthSet = true;
}

public String getOnblur(){
	if (this._onblur != null) {
		return this._onblur;
	}
	ValueExpression ve = getValueExpression("onblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnblur(String _onblur){
this._onblur = _onblur;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnfocus(){
	if (this._onfocus != null) {
		return this._onfocus;
	}
	ValueExpression ve = getValueExpression("onfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfocus(String _onfocus){
this._onfocus = _onfocus;
}

public String getOnitemselected(){
	if (this._onitemselected != null) {
		return this._onitemselected;
	}
	ValueExpression ve = getValueExpression("onitemselected");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnitemselected(String _onitemselected){
this._onitemselected = _onitemselected;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnlistcall(){
	if (this._onlistcall != null) {
		return this._onlistcall;
	}
	ValueExpression ve = getValueExpression("onlistcall");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnlistcall(String _onlistcall){
this._onlistcall = _onlistcall;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselect(){
	if (this._onselect != null) {
		return this._onselect;
	}
	ValueExpression ve = getValueExpression("onselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselect(String _onselect){
this._onselect = _onselect;
}

public Boolean getSelectFirstOnUpdate(){
	if (this._selectFirstOnUpdate != null) {
		return this._selectFirstOnUpdate;
	}
	ValueExpression ve = getValueExpression("selectFirstOnUpdate");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return true;
	

}

public void setSelectFirstOnUpdate(Boolean _selectFirstOnUpdate){
this._selectFirstOnUpdate = _selectFirstOnUpdate;
}

public Integer getShowDelay(){
	if (this._showDelay != null) {
		return this._showDelay;
	}
	ValueExpression ve = getValueExpression("showDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return 0;
	

}

public void setShowDelay(Integer _showDelay){
this._showDelay = _showDelay;
}

public int getSize(){
	if (this._sizeSet) {
	    return (this._size);
	}
	ValueExpression ve = getValueExpression("size");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._size);
	    }
	    
	    return value;
	} else {
	    return (this._size);
	}

}

public void setSize(int _size){
this._size = _size;
this._sizeSet = true;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public Object getSuggestionValues(){
	if (this._suggestionValues != null) {
		return this._suggestionValues;
	}
	ValueExpression ve = getValueExpression("suggestionValues");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSuggestionValues(Object _suggestionValues){
this._suggestionValues = _suggestionValues;
}

public String getTabindex(){
	if (this._tabindex != null) {
		return this._tabindex;
	}
	ValueExpression ve = getValueExpression("tabindex");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTabindex(String _tabindex){
this._tabindex = _tabindex;
}

public String getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "150";
	

}

public void setWidth(String _width){
this._width = _width;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[59];
state[0] = super.saveState(context);
state[1] = _accesskey;
state[2] = _align;
state[3] = _alt;
state[4] = _buttonClass;
state[5] = _buttonDisabledClass;
state[6] = _buttonDisabledStyle;
state[7] = _buttonIcon;
state[8] = _buttonIconDisabled;
state[9] = _buttonIconInactive;
state[10] = _buttonInactiveClass;
state[11] = _buttonInactiveStyle;
state[12] = _buttonStyle;
state[13] = _defaultLabel;
state[14] = _directInputSuggestions;
state[15] = Boolean.valueOf(_disabled);
state[16] = Boolean.valueOf(_disabledSet);
state[17] = Boolean.valueOf(_enableManualInput);
state[18] = Boolean.valueOf(_enableManualInputSet);
state[19] = _filterNewValues;
state[20] = _hideDelay;
state[21] = _inputClass;
state[22] = _inputDisabledClass;
state[23] = _inputDisabledStyle;
state[24] = _inputInactiveClass;
state[25] = _inputInactiveStyle;
state[26] = _inputStyle;
state[27] = _itemClass;
state[28] = _listClass;
state[29] = _listHeight;
state[30] = _listStyle;
state[31] = _listWidth;
state[32] = Integer.valueOf(_maxlength);
state[33] = Boolean.valueOf(_maxlengthSet);
state[34] = _onblur;
state[35] = _onchange;
state[36] = _onclick;
state[37] = _ondblclick;
state[38] = _onfocus;
state[39] = _onitemselected;
state[40] = _onkeydown;
state[41] = _onkeypress;
state[42] = _onkeyup;
state[43] = _onlistcall;
state[44] = _onmousedown;
state[45] = _onmousemove;
state[46] = _onmouseout;
state[47] = _onmouseover;
state[48] = _onmouseup;
state[49] = _onselect;
state[50] = _selectFirstOnUpdate;
state[51] = _showDelay;
state[52] = Integer.valueOf(_size);
state[53] = Boolean.valueOf(_sizeSet);
state[54] = _style;
state[55] = _styleClass;
state[56] = saveAttachedState(context, _suggestionValues);
state[57] = _tabindex;
state[58] = _width;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_accesskey = (String)states[1];;
		_align = (String)states[2];;
		_alt = (String)states[3];;
		_buttonClass = (String)states[4];;
		_buttonDisabledClass = (String)states[5];;
		_buttonDisabledStyle = (String)states[6];;
		_buttonIcon = (String)states[7];;
		_buttonIconDisabled = (String)states[8];;
		_buttonIconInactive = (String)states[9];;
		_buttonInactiveClass = (String)states[10];;
		_buttonInactiveStyle = (String)states[11];;
		_buttonStyle = (String)states[12];;
		_defaultLabel = (String)states[13];;
		_directInputSuggestions = (Boolean)states[14];;
		_disabled = ((Boolean)states[15]).booleanValue();
		_disabledSet = ((Boolean)states[16]).booleanValue();
		_enableManualInput = ((Boolean)states[17]).booleanValue();
		_enableManualInputSet = ((Boolean)states[18]).booleanValue();
		_filterNewValues = (Boolean)states[19];;
		_hideDelay = (Integer)states[20];;
		_inputClass = (String)states[21];;
		_inputDisabledClass = (String)states[22];;
		_inputDisabledStyle = (String)states[23];;
		_inputInactiveClass = (String)states[24];;
		_inputInactiveStyle = (String)states[25];;
		_inputStyle = (String)states[26];;
		_itemClass = (String)states[27];;
		_listClass = (String)states[28];;
		_listHeight = (String)states[29];;
		_listStyle = (String)states[30];;
		_listWidth = (String)states[31];;
		_maxlength = ((Integer)states[32]).intValue();
		_maxlengthSet = ((Boolean)states[33]).booleanValue();
		_onblur = (String)states[34];;
		_onchange = (String)states[35];;
		_onclick = (String)states[36];;
		_ondblclick = (String)states[37];;
		_onfocus = (String)states[38];;
		_onitemselected = (String)states[39];;
		_onkeydown = (String)states[40];;
		_onkeypress = (String)states[41];;
		_onkeyup = (String)states[42];;
		_onlistcall = (String)states[43];;
		_onmousedown = (String)states[44];;
		_onmousemove = (String)states[45];;
		_onmouseout = (String)states[46];;
		_onmouseover = (String)states[47];;
		_onmouseup = (String)states[48];;
		_onselect = (String)states[49];;
		_selectFirstOnUpdate = (Boolean)states[50];;
		_showDelay = (Integer)states[51];;
		_size = ((Integer)states[52]).intValue();
		_sizeSet = ((Boolean)states[53]).booleanValue();
		_style = (String)states[54];;
		_styleClass = (String)states[55];;
		_suggestionValues = (Object)restoreAttachedState(context, states[56]);
		_tabindex = (String)states[57];;
		_width = (String)states[58];;
	
}

}
