if(!window.Richfaces) window.Richfaces = {};
Richfaces.InplaceSelect = Class.create(Richfaces.InplaceInput, {
	initialize : function($super, listObj, clientId, temValueKeepId, valueKeepId, tabberId, attributes, events, classes, barParams, buttonId) {
		this.comboList = listObj;
		this.button = $(buttonId);
		$super(clientId, temValueKeepId, valueKeepId, tabberId, attributes, events, classes, barParams);
		this.clickOnBar = false;
		
		this.button.style.top = Richfaces.getBorderWidth(this.tempValueKeeper, "t") + "px";
	},
	
	initHandlers : function($super) {
		$super();
		this.tempValueKeeper.observe("click", function(e){this.tempKeeperClickHandler(e);}.bindAsEventListener(this));
		this.tempValueKeeper.observe("keydown", function(e){this.tmpValueKeyDownHandlerIn(e);}.bindAsEventListener(this));
		
		this.button.observe("mousedown", function(e){this.buttonClickHandler(e);}.bindAsEventListener(this));
		
		this.comboList.listParent.observe("mousedown", function(e){this.listMousedownHandler(e);}.bindAsEventListener(this));
		this.comboList.listParent.observe("mousemove", function(e){this.listMouseMoveHandler(e)}.bindAsEventListener(this));
		this.comboList.listParent.observe("click", function(e){this.listClickHandler(e);}.bindAsEventListener(this));
	},
	
	setInputWidth : function($super, textSize) {
		$super(textSize);
		this.button.show();
		this.button.style.left = (parseInt(this.tempValueKeeper.style.width) - this.button.offsetWidth) + "px";
	},
	
	switchingStatesHandler : function($super, e) {
		var el = (e.srcElement) ? e.srcElement : e.target;
		if ((el.id == this.inplaceInput.id) || (e.type == "focus")) {
			$super(e);
		} else {
			this.tempValueKeeper.focus();
		}
	},
	
	startEditableState : function($super, textSize) {
		this.inplaceInput.style.position = "relative";
		$super(textSize);
		this.button.show();
		if (this.attributes.openOnEdit) {
			this.comboList.showWithDelay();
		}
	},
	
	endEditableState : function($super) {
		this.inplaceInput.style.position = "";
		$super();
		this.button.hide();
	},
	
	tempKeeperClickHandler : function() {
		this.comboList.isList = false;
		this.comboList.showWithDelay();
	},
	
	buttonClickHandler : function(e) {
		this.tempKeeperClickHandler();
		Event.stop(e);
	},
	
	tmpValueBlurHandler : function($super, event) {
		$super(event);
		
		if (!this.comboList.isList || this.clickOnBar) {
			this.comboList.hideWithDelay();
		}
		if (this.attributes.showControls) {
			this.inputProcessing();
		}
		this.comboList.isList = false;
		/*this.comboList.hideWithDelay();*/
		
	},
	
	listClickHandler : function(event) {
		this.tempValueKeeper.focus();
		this.comboList.hideWithDelay();
	},
	
	listMouseMoveHandler : function(event) {
		//changes item's decoration
		var item = this.comboList.getEventItem(event);
		if (item) {
			this.comboList.doActiveItem(this.comboList.getEventItem(event));			
		}
	},
	
	listMousedownHandler : function(e) {
		if (Prototype.Browser.IE) {
			if (!this.comboList.getEventItem(e)) {
				this.clickOnScroll = true;
			}
			this.comboList.isList = true;
		} else if (Prototype.Browser.Gecko) {
			if (this.comboList.getEventItem(e)) {
				this.comboList.isList = true;			
			}
		} else {
			this.comboList.isList = true;
		}
	},
	
	tmpValueKeyDownHandlerIn : function(event) {
		switch (event.keyCode) {
			case Event.KEY_RETURN : 
				this.inputProcessing();
				this.comboList.hideWithDelay();
				Event.stop(event);
				break;
			case Event.KEY_DOWN : 
				this.comboList.moveActiveItem(event);
				Event.stop(event);
				break;
			case Event.KEY_UP :
				this.comboList.moveActiveItem(event);
				Event.stop(event);
				break; 
			case Event.KEY_ESC : 
				this.comboList.hideWithDelay();
				break;
		}
	},
	
	inputProcessing : function($super) {
		if (this.comboList.activeItem) {
			var userValue = this.comboList.activeItem.innerHTML;
			this.tempValueKeeper.value = userValue;
			this.comboList.selectedItem = this.comboList.activeItem;
			//this.clickOnField = false;
		}
		if (!this.comboList.isList || this.clickOnBar) {
			$super();
		}
	},
	
	deleteViewArtifacts : function () {
		var text = this.inplaceInput.childNodes[6];
		if (text) {
			this.inplaceInput.removeChild(text);
		}
	},
	
	getCurrentText : function() {
		return this.inplaceInput.childNodes[6];
	}
});
