/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.PrototypeScript;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIGmap;

public class GmapRenderer
extends HeaderResourcesRendererBase {
    private final InternetResource[] styles = new InternetResource[]{this.getResource("css/gmap.xcss")};
    private InternetResource[] stylesAll = null;
    private final InternetResource[] scripts = new InternetResource[]{new PrototypeScript(), this.getResource("script/gmap.js")};
    private InternetResource[] scriptsAll = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternetResource[] getStyles() {
        GmapRenderer gmapRenderer = this;
        synchronized (gmapRenderer) {
            if (this.stylesAll == null) {
                boolean ignoreThis;
                InternetResource[] rsrcs = super.getStyles();
                boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
                boolean bl = ignoreThis = this.styles == null || this.styles.length == 0;
                if (ignoreSuper) {
                    this.stylesAll = ignoreThis ? new InternetResource[0] : this.styles;
                } else if (ignoreThis) {
                    this.stylesAll = rsrcs;
                } else {
                    int i;
                    LinkedHashSet<InternetResource> rsrcsSet = new LinkedHashSet<InternetResource>();
                    for (i = 0; i < rsrcs.length; ++i) {
                        rsrcsSet.add(rsrcs[i]);
                    }
                    for (i = 0; i < this.styles.length; ++i) {
                        rsrcsSet.add(this.styles[i]);
                    }
                    this.stylesAll = rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
                }
            }
        }
        return this.stylesAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternetResource[] getScripts() {
        GmapRenderer gmapRenderer = this;
        synchronized (gmapRenderer) {
            if (this.scriptsAll == null) {
                boolean ignoreThis;
                InternetResource[] rsrcs = super.getScripts();
                boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
                boolean bl = ignoreThis = this.scripts == null || this.scripts.length == 0;
                if (ignoreSuper) {
                    this.scriptsAll = ignoreThis ? new InternetResource[0] : this.scripts;
                } else if (ignoreThis) {
                    this.scriptsAll = rsrcs;
                } else {
                    int i;
                    LinkedHashSet<InternetResource> rsrcsSet = new LinkedHashSet<InternetResource>();
                    for (i = 0; i < rsrcs.length; ++i) {
                        rsrcsSet.add(rsrcs[i]);
                    }
                    for (i = 0; i < this.scripts.length; ++i) {
                        rsrcsSet.add(this.scripts[i]);
                    }
                    this.scriptsAll = rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
                }
            }
        }
        return this.scriptsAll;
    }

    private String convertToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private String convertToString(boolean b) {
        return String.valueOf(b);
    }

    private String convertToString(int b) {
        return b != Integer.MIN_VALUE ? String.valueOf(b) : "";
    }

    private String convertToString(long b) {
        return b != Long.MIN_VALUE ? String.valueOf(b) : "";
    }

    private boolean isEmpty(Object o) {
        if (null == o) {
            return true;
        }
        if (o instanceof String) {
            return 0 == ((String)o).length();
        }
        if (o instanceof Collection) {
            return 0 == ((Collection)o).size();
        }
        if (o instanceof Map) {
            return 0 == ((Map)o).size();
        }
        if (o.getClass().isArray()) {
            return 0 == ((Object[])o).length;
        }
        return false;
    }

    protected Class getComponentClass() {
        return UIGmap.class;
    }

    public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIGmap component, ComponentVariables variables) throws IOException {
        String clientId = component.getClientId(context);
        variables.setVariable("key", component.getAttributes().get("gmapKey"));
        variables.setVariable("zoom", component.getAttributes().get("zoom"));
        variables.setVariable("map", component.getAttributes().get("gmapVar"));
        variables.setVariable("lat", component.getAttributes().get("lat"));
        variables.setVariable("lng", component.getAttributes().get("lng"));
        variables.setVariable("mapType", component.getAttributes().get("mapType"));
        variables.setVariable("oninit", component.getAttributes().get("oninit"));
        variables.setVariable("warningMessage", component.getAttributes().get("warningMessage"));
        variables.setVariable("isGScale", component.getAttributes().get("showGScaleControl"));
        variables.setVariable("isGMapType", component.getAttributes().get("showGMapTypeControl"));
        variables.setVariable("isGLarge", component.getAttributes().get("showGLargeMapControl"));
        variables.setVariable("enableDragging", component.getAttributes().get("enableDragging"));
        variables.setVariable("enableInfoWindow", component.getAttributes().get("enableInfoWindow"));
        variables.setVariable("enableDoubleClickZoom", component.getAttributes().get("enableDoubleClickZoom"));
        variables.setVariable("enableContinuousZoom", component.getAttributes().get("enableContinuousZoom"));
        writer.startElement("div", (UIComponent)component);
        this.getUtils().writeAttribute(writer, "class", (Object)("dr-gmap rich-gmap " + this.convertToString(component.getAttributes().get("styleClass"))));
        this.getUtils().writeAttribute(writer, "id", (Object)clientId);
        this.getUtils().encodePassThruWithExclusions(context, (UIComponent)component, "id,class");
        writer.startElement("script", (UIComponent)component);
        this.getUtils().writeAttribute(writer, "src", (Object)("http://maps.google.com/maps?file=api&v=2&key=" + this.convertToString(variables.getVariable("key"))));
        this.getUtils().writeAttribute(writer, "type", (Object)"text/javascript");
        writer.endElement("script");
        writer.startElement("script", (UIComponent)component);
        this.getUtils().writeAttribute(writer, "type", (Object)"text/javascript");
        writer.writeText((Object)this.convertToString("//"), null);
        writer.write("<![CDATA[");
        writer.write(this.convertToString("\n\nfunction __initGMap() { __initGmapdiv(\"" + this.convertToString(variables.getVariable("map")) + "\",\"" + this.convertToString(clientId) + "\", \"" + this.convertToString(variables.getVariable("warningMessage")) + "\");\n __applyGmapparam(\"" + this.convertToString(variables.getVariable("map")) + "\"," + this.convertToString(variables.getVariable("lat")) + ", " + this.convertToString(variables.getVariable("lng")) + "," + this.convertToString(variables.getVariable("zoom")) + "," + this.convertToString(variables.getVariable("mapType")) + "," + this.convertToString(variables.getVariable("enableDragging")) + "," + this.convertToString(variables.getVariable("enableInfoWindow")) + "," + this.convertToString(variables.getVariable("enableDoubleClickZoom")) + "," + this.convertToString(variables.getVariable("enableContinuousZoom")) + "," + this.convertToString(variables.getVariable("isGMapType")) + "," + this.convertToString(variables.getVariable("isGScale")) + "," + this.convertToString(variables.getVariable("isGLarge")) + ");\n var userfunc = function(event) { " + this.convertToString(variables.getVariable("oninit")) + " }; userfunc();};__addLoadEvent(__initGMap);__addUnLoadEvent(GUnload); \n//"));
        writer.write("]]>");
        writer.endElement("script");
        writer.endElement("div");
    }

    public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)component);
        this.doEncodeEnd(writer, context, (UIGmap)component, variables);
        ComponentsVariableResolver.removeVariables((RendererBase)this, (UIComponent)component);
    }
}

