/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.ajax4jsf.util.InputUtils;
import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIInplaceSelect;
import org.richfaces.renderkit.ComboBoxBaseRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InplaceSelectBaseRenderer
extends ComboBoxBaseRenderer {
    private static Log logger = LogFactory.getLog(InplaceSelectBaseRenderer.class);
    private static final String RICH_INPLACE_SELECT_CLASSES = "rich-inplace-select-item rich-inplace-select-font";
    private static final String CONTROLS_FACET = "controls";

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId;
        UIInplaceSelect inplaceInput = null;
        if (!(component instanceof UIInplaceSelect)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIInplaceSelect"));
            }
            return;
        }
        inplaceInput = (UIInplaceSelect)component;
        if ((InputUtils.isDisabled((UIComponent)inplaceInput) || InputUtils.isReadOnly((UIComponent)inplaceInput)) && logger.isDebugEnabled()) {
            logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is disabled"));
        }
        if ((clientId = component.getClientId(context)) == null) {
            throw new NullPointerException("component " + inplaceInput.getClientId(context) + " client id is NULL");
        }
        clientId = clientId + "inplaceValue";
        Map request = context.getExternalContext().getRequestParameterMap();
        if (request.containsKey(clientId)) {
            String newValue = (String)request.get(clientId);
            inplaceInput.setSubmittedValue(newValue);
        }
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        UIInplaceSelect select = null;
        Converter converter = null;
        if (component instanceof UIInplaceSelect) {
            select = (UIInplaceSelect)component;
            converter = select.getConverter();
        }
        return this.getConvertedValue(context, component, submittedValue, converter);
    }

    @Override
    public void encodeItems(FacesContext context, UIComponent component) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        ResponseWriter writer = context.getResponseWriter();
        List selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component);
        if (!selectItems.isEmpty()) {
            for (SelectItem selectItem : selectItems) {
                String value = this.getConvertedStringValue(context, component, selectItem.getValue());
                values.add(value);
                this.encodeSuggestion(writer, component, value, RICH_INPLACE_SELECT_CLASSES);
            }
        }
        this.setValuesList(values);
    }

    public void encodeControlsFacet(FacesContext context, UIComponent component) throws IOException {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        if (facet != null && facet.isRendered()) {
            this.renderChild(context, facet);
        }
    }

    public boolean isControlsFacetExists(FacesContext context, UIComponent component) {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        return facet != null && facet.isRendered();
    }

    @Override
    protected String getConvertedStringValue(FacesContext context, UIComponent component, Object value) {
        UIInplaceSelect select = null;
        Converter converter = null;
        if (component instanceof UIInplaceSelect) {
            select = (UIInplaceSelect)component;
            converter = select.getConverter();
        }
        return this.getConvertedStringValue(context, component, value, converter);
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return UIInplaceSelect.class;
    }
}

