/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.picklist.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PickListUtils {
    private static final Log log = LogFactory.getLog(PickListUtils.class);
    public static final Object NOTHING = new Serializable(){};

    public static Converter findUISelectManyConverter(FacesContext context, UISelectMany component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression ve = component.getValueExpression("value");
        if (ve == null) {
            return null;
        }
        Class valueType = ve.getType(context.getELContext());
        if (valueType == null) {
            return null;
        }
        if (List.class.isAssignableFrom(valueType)) {
            SelectItem selectItem;
            Class<?> listComponentType;
            List selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component);
            if (selectItems != null && selectItems.size() > 0 && !String.class.equals(listComponentType = (selectItem = (SelectItem)selectItems.get(0)).getValue().getClass())) {
                try {
                    return context.getApplication().createConverter(listComponentType);
                }
                catch (FacesException e) {
                    log.error((Object)("No Converter for type " + listComponentType.getName() + " found"), (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        if (!valueType.isArray()) {
            throw new IllegalArgumentException("ValueBinding for UISelectMany :  must be of type List or Array");
        }
        Class<?> arrayComponentType = valueType.getComponentType();
        if (String.class.equals(arrayComponentType)) {
            return null;
        }
        if (Object.class.equals(arrayComponentType)) {
            return null;
        }
        try {
            return context.getApplication().createConverter(arrayComponentType);
        }
        catch (FacesException e) {
            log.error((Object)("No Converter for type " + arrayComponentType.getName() + " found"), (Throwable)e);
            return null;
        }
    }

    public static Converter findUISelectManyConverterFailsafe(FacesContext facesContext, UIComponent uiComponent) {
        Converter converter;
        try {
            converter = PickListUtils.findUISelectManyConverter(facesContext, (UISelectMany)uiComponent);
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + uiComponent.getClientId(facesContext)), (Throwable)e);
            converter = null;
        }
        return converter;
    }

    public static Set getSubmittedOrSelectedValuesAsSet(boolean selectMany, UIComponent uiComponent, FacesContext facesContext, Converter converter) {
        Set<String> lookupSet;
        if (selectMany) {
            UISelectMany uiSelectMany = (UISelectMany)uiComponent;
            lookupSet = PickListUtils.getSubmittedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            if (lookupSet == null) {
                lookupSet = PickListUtils.getSelectedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            }
        } else {
            UISelectOne uiSelectOne = (UISelectOne)uiComponent;
            Object lookup = uiSelectOne.getSubmittedValue();
            if (lookup == null) {
                lookup = uiSelectOne.getValue();
                String lookupString = PickListUtils.getConvertedStringValue(facesContext, uiComponent, converter, lookup);
                lookupSet = Collections.singleton(lookupString);
            } else {
                lookupSet = NOTHING.equals(lookup) ? Collections.EMPTY_SET : Collections.singleton(lookup);
            }
        }
        return lookupSet;
    }

    public static Set getSubmittedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object submittedValues = uiSelectMany.getSubmittedValue();
        if (submittedValues == null) {
            return null;
        }
        if (converter != null) {
            converter = new PassThroughAsStringConverter(converter);
        }
        return PickListUtils.internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, submittedValues);
    }

    public static Set getSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object selectedValues = uiSelectMany.getValue();
        return PickListUtils.internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, selectedValues);
    }

    private static Set internalSubmittedOrSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany, Object values) {
        if (values == null || "".equals(values)) {
            return Collections.EMPTY_SET;
        }
        if (values instanceof Object[]) {
            Object[] ar = (Object[])values;
            if (ar.length == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(PickListUtils.calcCapacity(ar.length));
            for (int i = 0; i < ar.length; ++i) {
                set.add(PickListUtils.getConvertedStringValue(context, component, converter, ar[i]));
            }
            return set;
        }
        if (values.getClass().isArray()) {
            int len = Array.getLength(values);
            HashSet<String> set = new HashSet<String>(PickListUtils.calcCapacity(len));
            for (int i = 0; i < len; ++i) {
                set.add(PickListUtils.getConvertedStringValue(context, component, converter, Array.get(values, i)));
            }
            return set;
        }
        if (values instanceof List) {
            List lst = (List)values;
            if (lst.size() == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(PickListUtils.calcCapacity(lst.size()));
            Iterator i = lst.iterator();
            while (i.hasNext()) {
                set.add(PickListUtils.getConvertedStringValue(context, component, converter, i.next()));
            }
            return set;
        }
        throw new IllegalArgumentException("Value of UISelectMany component : is not of type Array or List");
    }

    public static final int calcCapacity(int size) {
        return (size * 4 + 3) / 3;
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component, Converter converter, Object value) {
        if (converter == null) {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new IllegalArgumentException("Value is not String (class=" + value.getClass().getName() + ", value=" + value + ") and component " + component.getClientId(context) + " does not have a Converter");
        }
        return converter.getAsString(context, component, value);
    }

    private static class PassThroughAsStringConverter
    implements Converter {
        private final Converter converter;

        public PassThroughAsStringConverter(Converter converter) {
            this.converter = converter;
        }

        public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
            return this.converter.getAsObject(context, component, value);
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
            return (String)value;
        }
    }
}

