package org.richfaces.picklist.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;

import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;





public class PickListUtils {
	 
	private static final Log log = LogFactory.getLog(PickListUtils.class);
	public static final Object NOTHING = new Serializable() {};

	public static Converter findUISelectManyConverter(FacesContext context, UISelectMany component) {
		
		Converter converter = component.getConverter();
		 
		if (converter != null) return converter;
		 //Try to find out by value binding
		ValueExpression ve = component.getValueExpression("value");
		if (ve == null) return null;

		Class valueType = ve.getType(context.getELContext());
		if (valueType == null) return null;

		if (List.class.isAssignableFrom(valueType)) {
			List selectItems = SelectUtils.getSelectItems(context, component);

			if (selectItems != null && selectItems.size() > 0) {
				SelectItem selectItem = (SelectItem) selectItems.get(0);
				Class listComponentType = selectItem.getValue().getClass();
	
				if (!(String.class.equals(listComponentType))) {
					try {
						return context.getApplication().createConverter(listComponentType);
					}
					catch (FacesException e) {
						log.error("No Converter for type " + listComponentType.getName() + " found", e);
						return null;
					}
				}
			}

			return null;
		}

		if (!valueType.isArray()) {
			throw new IllegalArgumentException("ValueBinding for UISelectMany :  must be of type List or Array");
		}	

		Class arrayComponentType = valueType.getComponentType();
		if (String.class.equals(arrayComponentType)) return null;    //No converter needed for String type
		if (Object.class.equals(arrayComponentType)) return null;    //There is no converter for Object class

		try {
			return context.getApplication().createConverter(arrayComponentType);
		} catch (FacesException e) {
			log.error("No Converter for type " + arrayComponentType.getName() + " found", e);
			return null;
		}
	}	
	
	public static Converter findUISelectManyConverterFailsafe(FacesContext facesContext, UIComponent uiComponent) {
        Converter converter;
        try {
            converter = findUISelectManyConverter(
                facesContext, (UISelectMany) uiComponent);
        }
        catch (FacesException e) {
            log.error("Error finding Converter for component with id "
                + uiComponent.getClientId(facesContext), e);
            converter = null;
        }
        return converter;
    }
	
	public static Set getSubmittedOrSelectedValuesAsSet(boolean selectMany, UIComponent uiComponent, FacesContext facesContext, Converter converter) {
        Set lookupSet;

        if (selectMany) {
            UISelectMany uiSelectMany = (UISelectMany) uiComponent;
            lookupSet = getSubmittedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            if (lookupSet == null) {
                lookupSet = getSelectedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            }
        }
        else {
            UISelectOne uiSelectOne = (UISelectOne) uiComponent;
            Object lookup = uiSelectOne.getSubmittedValue();
            if (lookup == null) {
                lookup = uiSelectOne.getValue();
                String lookupString = getConvertedStringValue(facesContext, uiComponent, converter, lookup);
                lookupSet = Collections.singleton(lookupString);
            }
            else if (NOTHING.equals(lookup)) {
                lookupSet = Collections.EMPTY_SET;
            }
            else {
                lookupSet = Collections.singleton(lookup);
            }
        }
        return lookupSet;
    }
	
	public static Set getSubmittedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object submittedValues = uiSelectMany.getSubmittedValue();
        if (submittedValues == null) {
            return null;
        }
        
        if(converter != null) {
            converter = new PassThroughAsStringConverter(converter);
        }

        return internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, submittedValues);
    }
	
	private static class PassThroughAsStringConverter implements Converter {
	        private final Converter converter;

	        public PassThroughAsStringConverter(Converter converter) {
	            this.converter = converter;
	        }

	        public Object getAsObject(FacesContext context, UIComponent component,
	                String value) throws ConverterException {
	            return converter.getAsObject(context, component, value);
	        }

	        public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
	            return (String)value;
	        }

	}
	  
	  public static Set getSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
	        Object selectedValues = uiSelectMany.getValue();
	        return internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, selectedValues);
	   }
	  
	  private static Set internalSubmittedOrSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany,Object values) {
		
		  if (values == null || "".equals(values)) {
			  return Collections.EMPTY_SET;
		  } else if (values instanceof Object[]) {
			//Object array
			  Object[] ar = (Object[]) values;
			  if (ar.length == 0) {
				  return Collections.EMPTY_SET;
			  }
		
			  HashSet set = new HashSet(calcCapacity(ar.length));
			  for (int i = 0; i < ar.length; i++) {
				  set.add(getConvertedStringValue(context, component, converter, ar[i]));
			  }
			  return set;
		  } else if (values.getClass().isArray()) {
			  //primitive array
			  int len = Array.getLength(values);
			  HashSet set = new HashSet(calcCapacity(len));
			  for (int i = 0; i < len; i++) {
				  set.add(getConvertedStringValue(context, component, converter, Array.get(values, i)));
			  }
			  return set;
		  }	else if (values instanceof List) {
			  List lst = (List) values;
			  if (lst.size() == 0) {
				  return Collections.EMPTY_SET;
			  } else {
				  HashSet set = new HashSet(calcCapacity(lst.size()));
				  for (Iterator i = lst.iterator(); i.hasNext();) {
					  set.add(getConvertedStringValue(context, component, converter, i.next()));
				  }	   
				  return set;
			  }
		  } else {
			  throw new IllegalArgumentException("Value of UISelectMany component : is not of type Array or List");
		  }
	  }
		
	  public static final int calcCapacity(int size) {
		  return ((size * 4) + 3) / 3;
	  }
	  
	  public static String getConvertedStringValue(FacesContext context, UIComponent component, Converter converter, Object value) {
			if (converter == null) {
				if (value == null) {
					return "";
				} else if (value instanceof String) {
					return (String) value;
				} else {
					throw new IllegalArgumentException(
							"Value is not String (class=" + value.getClass().getName() + ", value=" + value + ") and component "
							+ component.getClientId(context) + " does not have a Converter");
				}
			}
			
			return converter.getAsString(context, component, value);
	  }
//	  public static boolean renderHTMLAttributes(ResponseWriter writer,
//              UIComponent component, String[] attributes) throws IOException {
//		boolean somethingDone = false;
//		for (int i = 0, len = attributes.length; i < len; i++) {
//		String attrName = attributes[i];
//		if (renderHTMLAttribute(writer, component, attrName, attrName)) {
//		somethingDone = true;
//		}
//		}
//		return somethingDone;
//	  } 
//	  
//	  public static boolean renderHTMLAttribute(ResponseWriter writer,
//              UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
//			Object value = component.getAttributes().get(componentProperty);
//			return renderHTMLAttribute(writer, componentProperty, htmlAttrName, value);
//	  }
//	  
//	  public static boolean renderHTMLAttribute(ResponseWriter writer,
//              String componentProperty, String attrName, Object value) throws IOException {
//			if (!isDefaultAttributeValue(value)) {
//			// render JSF "styleClass" and "itemStyleClass" attributes as "class"
//			String htmlAttrName =
//			attrName.equals("styleClass") ? "class" : attrName;
//			writer.writeAttribute(htmlAttrName, value, componentProperty);
//			return true;
//			}
//			
//			return false;
//	  }
//	  
//	  public static boolean isDefaultAttributeValue(Object value) {
//	        if (value == null) {
//	            return true;
//	        }
//	        else if (value instanceof Boolean) {
//	            return !((Boolean) value).booleanValue();
//	        }
//	        else if (value instanceof Number) {
//	            if (value instanceof Integer) {
//	                return ((Number) value).intValue() == Integer.MIN_VALUE;
//	            }
//	            else if (value instanceof Double) {
//	                return ((Number) value).doubleValue() == Double.MIN_VALUE;
//	            }
//	            else if (value instanceof Long) {
//	                return ((Number) value).longValue() == Long.MIN_VALUE;
//	            }
//	            else if (value instanceof Byte) {
//	                return ((Number) value).byteValue() == Byte.MIN_VALUE;
//	            }
//	            else if (value instanceof Float) {
//	                return ((Number) value).floatValue() == Float.MIN_VALUE;
//	            }
//	            else if (value instanceof Short) {
//	                return ((Number) value).shortValue() == Short.MIN_VALUE;
//	            }
//	        }
//	        return false;
//	   }

}
