/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.component;

import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;

import org.ajax4jsf.component.AjaxActionComponent;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.event.DataScrollerListener;
import org.richfaces.event.DataScrollerSource;


/** JSF component class */
//xxxx nick -> alex - extend UIComponentBase and
//create event listener & event classes to define PageSwitchEvent
//public abstract class UIDatascroller extends UIComponentBase implements DataScrollerSource{
public abstract class UIDatascroller extends AjaxActionComponent
implements DataScrollerSource, ActionSource {

    private Integer firstRow;

    public static final String COMPONENT_TYPE = "org.richfaces.Datascroller";
    public static final String COMPONENT_FAMILY = "org.richfaces.Datascroller";

    public static final String FIRST_FACET_NAME = "first";

    public static final String LAST_FACET_NAME = "last";

    public static final String NEXT_FACET_NAME = "next";

    public static final String PREVIOUS_FACET_NAME = "previous";

    public static final String FAST_FORWARD_FACET_NAME = "fastforward";

    public static final String FAST_REWIND_FACET_NAME = "fastrewind";


    public static final String FIRST_DISABLED_FACET_NAME = "first_disabled";

    public static final String LAST_DISABLED_FACET_NAME = "last_disabled";

    public static final String NEXT_DISABLED_FACET_NAME = "next_disabled";

    public static final String PREVIOUS_DISABLED_FACET_NAME
    = "previous_disabled";

    public static final String FAST_FORWARD_DISABLED_FACET_NAME
    = "fastforward_disabled";

    public static final String FAST_REWIND_DISABLED_FACET_NAME
    = "fastrewind_disabled";

    public void addScrollerListener(DataScrollerListener listener) {
        addFacesListener(listener);
    }

    public DataScrollerListener[] getScrollerListeners() {
        return (DataScrollerListener[]) getFacesListeners(
                DataScrollerListener.class);
    }

    public void removeScrollerListener(DataScrollerListener listener) {
        removeFacesListener(listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof DataScrollerEvent) {
            DataScrollerEvent dataScrollerEvent = (DataScrollerEvent) event;
            setPage(dataScrollerEvent.getNewScrolVal(), true);

            FacesContext context = FacesContext.getCurrentInstance();
            AjaxRendererUtils.addRegionByName(context, this, this.getId());
            AjaxRendererUtils.addRegionByName(context, this, this.getFor());

            setupReRender(context);

            MethodExpression scrollerListener = getScrollerListener();
            if (scrollerListener != null) {
                scrollerListener.invoke(context.getELContext(), new Object[]{event});
            }
        }
    }

    public abstract MethodExpression getScrollerListener();

    public abstract void setScrollerListener(MethodExpression scrollerListener);

    public abstract void setFor(String f);

    public abstract String getFor();

    public abstract int getFastStep();

    public abstract void setFastStep(int FastStep);

    public abstract boolean isRenderIfSinglePage();

    public abstract void setRenderIfSinglePage(boolean renderIfSinglePage);

    public abstract int getMaxPages();

    public abstract void setMaxPages(int maxPages);

    public abstract String getSelectedStyleClass();

    public abstract void setSelectedStyleClass(String selectedStyleClass);

    public abstract String getSelectedStyle();

    public abstract void setSelectedStyle(String selectedStyle);

    public abstract String getEventsQueue();

    public abstract void setEventsQueue(String eventsQueue);

    public abstract boolean isAjaxSingle();

    public abstract void setAjaxSingle(boolean ajaxSingle);

    public abstract int getRequestDelay();

    public abstract void setRequestDelay(int requestDelay);

    public abstract String getTableStyleClass();

    public abstract void setTableStyleClass(String tableStyleClass);

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String styleClass);

    public abstract void setStyle(String styleClass);

    public abstract String getAlign();

    public abstract void setAlign(String align);

    public abstract String getBoundaryControls();

    public abstract void setBoundaryControls(String boundaryControls);

    public abstract String getFastControls();

    public abstract void setFastControls(String fastControls);

    public abstract String getStepControls();

    public abstract void setStepControls(String stepControls);

    public abstract String getInactiveStyleClass();

    public abstract String getInactiveStyle();

    public abstract void setInactiveStyleClass(String inactiveStyleClass);

    public abstract void setInactiveStyle(String inactiveStyle);
    /**
     * Finds the dataTable which id is mapped to the "for" property
     *
     * @return the dataTable component
     */
    public UIData getDataTable() {
        String forAttribute = getFor();
        UIComponent forComp;
        if (forAttribute == null) {
            forComp = this;
            while ((forComp = forComp.getParent()) != null) {
                if (forComp instanceof UIData) {
                    setFor(forComp.getId());
                    return (UIData) forComp;
                }
            }
            throw new FacesException(
                    "could not find dataTable for  datascroller " + this.getId());
        } else {
            forComp = RendererUtils.getInstance().findComponentFor(this, forAttribute);
        }
        if (forComp == null) {
            throw new IllegalArgumentException("could not find dataTable with id '"
                    + forAttribute + "'");
        } else if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException(
                    "component with id '" + forAttribute
                    + "' must be of type " + UIData.class.getName()
                    + ", not type "
                    + forComp.getClass().getName());
        }
        return (UIData) forComp;
    }

    public int getPageIndex(UIData uiData) {
        //xxxx nick -> alex - suppose this.getRows() would be better here
        int rows = getRows(uiData);
        if (0 == rows) {
            throw new FacesException("Missing 'rows' attribute on component '"
                    + uiData.getId() + "'");
        }

        int firstRow = getFirstRow();

        int pageIndex;
        if (rows > 0) {
            //xxxx nick -> alex - suppose this.getFirst() would be better here
            pageIndex = firstRow / rows + 1;
        } else {
            //TODO nick -> nick - is it valid if under 0?
            pageIndex = 0;
        }

        if (firstRow % rows > 0) {
            pageIndex++;
        }

        return pageIndex;
    }

    /**
     * Gets the index of the current page
     *
     * @return the page index
     */
    public int getPageIndex() {
        UIData uiData = getDataTable();
        return getPageIndex(uiData);
    }

    private void setFirstRowValue(int row) {
        FacesContext context = getFacesContext();
        ValueExpression ve = getValueExpression("firstRow");
        if (ve != null) {
            try {
                ve.setValue(context.getELContext(), row);
                firstRow = null;
            } catch (ELException e) {
                String messageStr = e.getMessage();
                Throwable result = e.getCause();
                while (null != result &&
                        result.getClass().isAssignableFrom(ELException.class)) {
                    messageStr = result.getMessage();
                    result = result.getCause();
                }
                FacesMessage message;
                if (null == messageStr) {
                    message =
                        MessageUtil.getMessage(context, UIInput.UPDATE_MESSAGE_ID,
                                new Object[] { MessageUtil.getLabel(
                                        context, this) });
                } else {
                    message = new FacesMessage(FacesMessage.SEVERITY_ERROR,
                            messageStr,
                            messageStr);
                }
                context.getExternalContext().log(message.getSummary(), result);
                context.addMessage(getClientId(context), message);
                context.renderResponse();
            } catch (IllegalArgumentException e) {
                FacesMessage message =
                    MessageUtil.getMessage(context, UIInput.UPDATE_MESSAGE_ID,
                            new Object[] { MessageUtil.getLabel(
                                    context, this) });
                context.getExternalContext().log(message.getSummary(), e);
                context.addMessage(getClientId(context), message);
                context.renderResponse();
            } catch (Exception e) {
                FacesMessage message =
                    MessageUtil.getMessage(context, UIInput.UPDATE_MESSAGE_ID,
                            new Object[] { MessageUtil.getLabel(
                                    context, this) });
                context.getExternalContext().log(message.getSummary(), e);
                context.addMessage(getClientId(context), message);
                context.renderResponse();
            }
        } else {
            setFirstRow(row);
        }
        //TODO
    }
    
    private int getFirstRowForLastPage(int rowCount, int rows) {
        int delta = rowCount % rows;
        int newFirst = delta > 0 && delta < rows ? rowCount - delta : rowCount
                - rows;
        if (newFirst >= 0) {
            return newFirst;
        } else {
            return 0;
        }
    }

    /**
     * Sets the page number according to the parameter recived from the
     * commandLink
     *
     * @param facetName - can be "first:, "last", "next",  "previous",
     * "fastforward", "fastrewind"
     */
    public void setPage(String facetName) {
        setPage(facetName, false);
    }

    public void setPage(String facetName, boolean updateModel) {
        // check if facet is selected
        if (FIRST_FACET_NAME.equals(facetName)) {
            setFirstRowValue(0);
        } else {
            UIData dataTable = getDataTable();

            int first = getFirstRow();
            int rows = getRows(dataTable);
            int rowCount = getRowCount(dataTable);

            if (PREVIOUS_FACET_NAME.equals(facetName)) {
                int previous = first - rows;
                if (previous >= 0) {
                    setFirstRowValue(previous);
                }
            } else if (NEXT_FACET_NAME.equals(facetName)) {
                int next = first + rows;
                if (next < rowCount) {
                    setFirstRowValue(next);
                }
                //if (rows>0){
                //     if (((next+rows)/rows)>getMaxPages()){
                //        next=getMaxPages()*rows-rows;;
                //     }
                //}
            } else if (FAST_FORWARD_FACET_NAME.equals(facetName)) {
                int fastStep = getFastStep();
                if (fastStep <= 0) {
                    fastStep = 1;
                }
                int next = first + rows * fastStep;
                if (next >= rowCount) {
                    next = (rowCount - 1) - ((rowCount - 1) % rows);
                }
                //if (rows>0){
                // if (((next+rows)/rows)>getMaxPages()){
                //    next=getMaxPages()*rows-rows;;
                //}
                //}
                setFirstRowValue(next);
            } else if (FAST_REWIND_FACET_NAME.equals(facetName)) {
                int fastStep = getFastStep();
                if (fastStep <= 0) {
                    fastStep = 1;
                }
                int previous = first - rows * fastStep;
                if (previous < 0) {
                    previous = 0;
                }
                setFirstRowValue(previous);
            } else if (LAST_FACET_NAME.equals(facetName)) {
                setFirstRow(getFirstRowForLastPage(rowCount, rows));
            }
            // the paginator is selected
            else {
                int pageindex = Integer.parseInt(facetName);
                int pageCount = getPageCount(rowCount, rows);
                if (pageindex > pageCount) {
                    pageindex = pageCount;
                } else if (pageindex <= 0) {
                    pageindex = 1;
                }
                setFirstRowValue(rows * (pageindex - 1));
            }

        }

    }

    public int getPageCount(int rowCount, int rows) {
        int pageCount;
        if (rows > 0) {
            pageCount = rows <= 0 ? 1 : rowCount / rows;
            if (rowCount % rows > 0) {
                pageCount++;
            }
            if (pageCount == 0) {
                pageCount = 1;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    public int getPageCount(UIData data) {
        return getPageCount(getRowCount(data), getRows(data));
    }

    /** @return the page count of the uidata */
    public int getPageCount() {
        return getPageCount(getDataTable());
    }

    public int getRowCount(UIData data) {
        int rowCount = data.getRowCount();
        if (rowCount >= 0) {
            return rowCount;
        }

        return BinarySearch.search(data);
    }

    /** @return int */
    public int getRowCount() {
        //xxx nick -> alex - scrollable models can return -1 here
        //let's implement "dychotomic" discovery
        // setPage(1)... if isPageAvailable() setPage(2) then 4, 8, etc.
        // setPage() { setRowIndex(pageIdx * rows); }
        // isPageAvailable() { return isRowAvailable() }
        //return getUIData().getRowCount();
        return getRowCount(getDataTable());
    }

    public int getRows(UIData data) {
        int row = 0;
        row = data.getRows();
        if (row == 0) {
            row = getRowCount(data);
        }

        return row;
    }

    // facet getter methods
    public UIComponent getFirst() {
        return getFacet(FIRST_FACET_NAME);
    }

    public UIComponent getLast() {
        return getFacet(LAST_FACET_NAME);
    }

    public UIComponent getNext() {
        return getFacet(NEXT_FACET_NAME);
    }

    public UIComponent getFastForward() {
        return getFacet(FAST_FORWARD_FACET_NAME);
    }

    public UIComponent getFastRewind() {
        return getFacet(FAST_REWIND_FACET_NAME);
    }

    public UIComponent getPrevious() {
        return getFacet(PREVIOUS_FACET_NAME);
    }

    public void updateFirstRow() {
        UIData dataTable = getDataTable();
        int rowCount = getRowCount(dataTable);
        int firstRow = getFirstRow();
        
        if (firstRow < 0) {
            setFirstRow(0);
        } else if (firstRow >= rowCount) {
            setFirstRow(getFirstRowForLastPage(rowCount, getRows(dataTable)));
        }
    }

    public int getFirstRow() {
        if (this.firstRow != null) {
            return firstRow;
        } 

        ValueExpression ve = getValueExpression("firstRow");
        if (ve != null) {
            try {
                Integer firstRowObject = (Integer) ve.getValue(getFacesContext().getELContext());

                if (firstRowObject != null) {
                    return firstRowObject;
                } else {
                    return 0;
                }
            } catch (ELException e) {
                throw new FacesException(e);
            }
        } else {
            return 0;
        }
    }

    public void setFirstRow(int row) {
        this.firstRow = row;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    static class BinarySearch {

        public static int search(UIData data) {
            int rowIndex = data.getRowIndex();
            try {
                int n = 1;
                int k = 2;
                for (; ;) {
                    data.setRowIndex(k - 1);
                    if (data.isRowAvailable()) {
                        n = k;
                        k = k * 2;
                    } else {
                        break;
                    }
                }

                while (n < k) {
                    int kk = Math.round((n + k) / 2) + 1;
                    data.setRowIndex(kk - 1);
                    if (data.isRowAvailable()) {
                        n = kk;
                    } else {
                        k = kk - 1;
                    }
                }

                data.setRowIndex(k - 1);
                if (data.isRowAvailable()) {
                    return k;
                } else {
                    return 0;
                }
            } finally {
                data.setRowIndex(rowIndex);
            }
        }
    }

    public Object saveState(FacesContext context) {
        return new Object[] {
                super.saveState(context),    
                firstRow,
        };

    }

    public void restoreState(FacesContext context, Object object) {
        Object[] state = (Object[]) object;

        super.restoreState(context, state[0]);
        firstRow = (Integer) state[1];
    }

}
