/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.taglib;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.webapp.taglib.HtmlComponentTagBase;
import org.richfaces.component.UITabPanel;

public abstract class TabPanelTagBase
extends HtmlComponentTagBase {
    private boolean _selectedTabSet = false;
    private ValueExpression _value = null;

    private void logValueDeprecation(ValueExpression value) {
        FacesContext facesContext = this.getFacesContext();
        facesContext.getExternalContext().log("selectedTab attribute has been already set for component with id: " + this.getId() + "[" + value.getExpressionString() + "]. value attribute is deprecated and thus has been dropped!");
    }

    public void setSelectedTab(ValueExpression tab) {
        if (!this._selectedTabSet && this._value != null) {
            this.logValueDeprecation(tab);
        }
        this._value = tab;
        this._selectedTabSet = true;
    }

    public void setValue(ValueExpression value) {
        if (!this._selectedTabSet) {
            this._value = value;
        } else {
            this.logValueDeprecation(this._value);
        }
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        if (this._value != null) {
            if (this._value.isLiteralText()) {
                UITabPanel tabPanel = (UITabPanel)component;
                try {
                    tabPanel.setSelectedTab(this._value.getExpressionString());
                }
                catch (ELException e) {
                    throw new FacesException((Throwable)e);
                }
            } else {
                component.setValueExpression("selectedTab", this._value);
            }
        }
    }

    public void release() {
        super.release();
        this._selectedTabSet = false;
        this._value = null;
    }
}

